/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.SpLocaleBase;
import edu.ku.brc.specify.datamodel.SpLocaleContainerItem;
import edu.ku.brc.specify.datamodel.SpLocaleItemStr;
import edu.ku.brc.specify.tools.schemalocale.LocalizableContainerIFace;
import edu.ku.brc.specify.tools.schemalocale.LocalizableItemIFace;
import edu.ku.brc.specify.tools.schemalocale.LocalizableStrIFace;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="splocalecontainer")
@Table(appliesTo="splocalecontainer", indexes={@Index(name="SpLocaleContainerNameIDX", columnNames={"Name"})})
public class SpLocaleContainer
extends SpLocaleBase
implements LocalizableContainerIFace {
    public static final Byte CORE_SCHEMA = 0;
    public static final Byte WORKBENCH_SCHEMA = 1;
    private static final Logger log = Logger.getLogger(SpLocaleContainer.class);
    protected Integer spLocaleContainerId;
    protected Byte schemaType;
    protected Set<SpLocaleContainerItem> items;
    protected Set<SpLocaleItemStr> names;
    protected Set<SpLocaleItemStr> descs;
    protected Discipline discipline;
    protected String aggregator;
    protected String defaultUI;
    protected Vector<LocalizableItemIFace> containerItems = null;

    @Override
    public void initialize() {
        super.initialize();
        this.spLocaleContainerId = null;
        this.schemaType = null;
        this.items = new HashSet<SpLocaleContainerItem>();
        this.names = new HashSet<SpLocaleItemStr>();
        this.descs = new HashSet<SpLocaleItemStr>();
        this.discipline = AppContextMgr.getInstance().hasContext() ? AppContextMgr.getInstance().getClassObject(Discipline.class) : null;
        this.containerItems = null;
        this.aggregator = null;
        this.defaultUI = null;
    }

    @Id
    @GeneratedValue
    @Column(name="SpLocaleContainerID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getSpLocaleContainerId() {
        return this.spLocaleContainerId;
    }

    public void setSpLocaleContainerId(Integer spLocaleContainerId) {
        this.spLocaleContainerId = spLocaleContainerId;
    }

    @Column(name="SchemaType", unique=false, nullable=false, insertable=true, updatable=true)
    public Byte getSchemaType() {
        return this.schemaType;
    }

    public void setSchemaType(Byte schemaType) {
        this.schemaType = schemaType;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="container")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<SpLocaleContainerItem> getItems() {
        return this.items;
    }

    public void setItems(Set<SpLocaleContainerItem> items) {
        this.items = items;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="containerDesc")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<SpLocaleItemStr> getDescs() {
        return this.descs;
    }

    public void setDescs(Set<SpLocaleItemStr> descs) {
        this.descs = descs;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="containerName")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<SpLocaleItemStr> getNames() {
        return this.names;
    }

    public void setNames(Set<SpLocaleItemStr> names) {
        this.names = names;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="DisciplineID", unique=false, nullable=false, insertable=true, updatable=true)
    public Discipline getDiscipline() {
        return this.discipline;
    }

    public void setDiscipline(Discipline discipline) {
        this.discipline = discipline;
    }

    @Override
    @Column(name="Aggregator", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getAggregator() {
        return this.aggregator;
    }

    @Override
    public void setAggregator(String aggregator) {
        this.aggregator = aggregator;
    }

    @Column(name="DefaultUI", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getDefaultUI() {
        return this.defaultUI;
    }

    public void setDefaultUI(String defaultUI) {
        this.defaultUI = defaultUI;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return SpLocaleContainer.class;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.spLocaleContainerId;
    }

    @Override
    @Transient
    public int getTableId() {
        return SpLocaleContainer.getClassTableId();
    }

    public static int getClassTableId() {
        return 503;
    }

    @Override
    public int compareTo(SpLocaleContainer obj) {
        return this.name != null && obj != null && obj.getName() != null ? this.name.compareTo(obj.getName()) : 0;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    @Transient
    public Collection<LocalizableItemIFace> getContainerItems() {
        if (this.containerItems == null) {
            this.containerItems = new Vector<SpLocaleContainerItem>(this.items);
        }
        return this.containerItems;
    }

    public void clearCollectionItemsList() {
        this.containerItems = null;
    }

    @Override
    @Transient
    public Boolean getIsRequired() {
        return null;
    }

    @Override
    public void setIsRequired(Boolean required) {
    }

    @Override
    public void removeItem(LocalizableItemIFace item) {
        if (item != null) {
            if (item instanceof SpLocaleContainerItem) {
                SpLocaleContainerItem it = (SpLocaleContainerItem)item;
                this.items.remove(it);
                if (this.containerItems != null) {
                    this.containerItems.remove(it);
                }
            } else {
                log.error((Object)"Trying to remove an item that isn't of class SpLocaleContainerItem");
            }
        }
    }

    @Override
    public int compareTo(LocalizableContainerIFace obj) {
        return this.name != null && obj != null && obj.getName() != null ? this.name.compareTo(obj.getName()) : 0;
    }

    @Override
    public void addItem(LocalizableItemIFace item) {
        if (item != null && item instanceof SpLocaleContainerItem) {
            SpLocaleContainerItem it = (SpLocaleContainerItem)item;
            this.items.add(it);
            it.setContainer(this);
            if (this.containerItems != null) {
                this.containerItems.add(it);
            }
        } else {
            log.error((Object)"LocalizableItemIFace was null or not of Class SpLocaleContainerItem");
        }
    }

    @Override
    public LocalizableItemIFace getItemByName(String nameArg) {
        for (SpLocaleContainerItem item : this.items) {
            if (!nameArg.equals(item.getName())) continue;
            return item;
        }
        return null;
    }

    @Override
    public void fillDescs(List<LocalizableStrIFace> descsArg) {
        descsArg.clear();
        descsArg.addAll(this.descs);
    }

    @Override
    public void fillNames(List<LocalizableStrIFace> namesArg) {
        namesArg.clear();
        namesArg.addAll(this.names);
    }

    @Override
    public void addDesc(LocalizableStrIFace str) {
        if (str != null && str instanceof SpLocaleItemStr) {
            SpLocaleItemStr strItem = (SpLocaleItemStr)str;
            strItem.setContainerDesc(this);
            this.descs.add(strItem);
        } else {
            log.error((Object)"LocalizableStrIFace was null or not of Class SpLocaleItemStr");
        }
    }

    @Override
    public void addName(LocalizableStrIFace str) {
        if (str != null && str instanceof SpLocaleItemStr) {
            SpLocaleItemStr strItem = (SpLocaleItemStr)str;
            strItem.setContainerName(this);
            this.names.add(strItem);
        } else {
            log.error((Object)"LocalizableStrIFace was null or not of Class SpLocaleItemStr");
        }
    }

    @Override
    public void removeDesc(LocalizableStrIFace str) {
        if (str != null && str instanceof SpLocaleItemStr) {
            this.descs.remove(str);
        } else {
            log.error((Object)"LocalizableStrIFace was null or not of Class SpLocaleItemStr");
        }
    }

    @Override
    public void removeName(LocalizableStrIFace str) {
        if (str != null && str instanceof SpLocaleItemStr) {
            this.names.remove((SpLocaleItemStr)str);
        } else {
            log.error((Object)"LocalizableStrIFace was null or not of Class SpLocaleItemStr");
        }
    }

    @Override
    @Transient
    public String getWebLinkName() {
        return null;
    }

    @Override
    public void setWebLinkName(String webLinkName) {
    }

    @Override
    @Transient
    public Set<SpLocaleItemStr> getNamesSet() {
        return this.names;
    }

    @Override
    @Transient
    public Set<SpLocaleItemStr> getDescsSet() {
        return this.descs;
    }
}

