/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.datamodel.CollectionMember;
import edu.ku.brc.specify.datamodel.SpExportSchema;
import edu.ku.brc.specify.datamodel.SpExportSchemaItemMapping;
import edu.ku.brc.specify.datamodel.SpQuery;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="spexportschemamapping")
@Table(appliesTo="spexportschemamapping", indexes={@Index(name="SPEXPSCHMMAPColMemIDX", columnNames={"CollectionMemberID"})})
public class SpExportSchemaMapping
extends CollectionMember {
    protected static final Logger log = Logger.getLogger(SpExportSchemaMapping.class);
    protected Integer spExportSchemaMappingId;
    protected Set<SpExportSchema> spExportSchemas;
    protected String mappingName;
    protected String description;
    protected Timestamp timestampExported;
    protected Set<SpExportSchemaItemMapping> mappings;

    public void toXML(StringBuilder sb) {
        sb.append("<spexportschemamapping ");
        XMLHelper.addAttr(sb, "mappingName", this.mappingName);
        XMLHelper.addAttr(sb, "description", this.description);
        sb.append(">\r\n");
        sb.append("<spexportschemas>\n");
        for (SpExportSchema schema : this.spExportSchemas) {
            schema.toXML(sb);
        }
        sb.append("</spexportschemas>\n");
        sb.append("<spexportschemaitemmappings>\n");
        for (SpExportSchemaItemMapping mapping : this.mappings) {
            mapping.toXML(sb);
        }
        sb.append("</spexportschemaitemmappings>\n");
        sb.append("</spexportschemamapping>");
    }

    public void fromXML(Element element, SpQuery query) {
        this.mappingName = XMLHelper.getAttr(element, "mappingName", null);
        this.description = XMLHelper.getAttr(element, "description", null);
        for (Object obj : element.selectNodes("spexportschemas/spexportschema")) {
            Element schemaEl = (Element)obj;
            SpExportSchema schema = new SpExportSchema();
            schema.initialize();
            schema.fromXML(schemaEl);
            schema.getSpExportSchemaMappings().add(this);
            this.spExportSchemas.add(schema);
        }
        for (Object obj : element.selectNodes("spexportschemaitemmappings/spexportschemaitemmapping")) {
            Element mappingEl = (Element)obj;
            SpExportSchemaItemMapping mapping = new SpExportSchemaItemMapping();
            mapping.initialize();
            mapping.fromXML(mappingEl, query, this);
            mapping.setExportSchemaMapping(this);
            this.mappings.add(mapping);
        }
    }

    @Id
    @GeneratedValue
    @Column(name="SpExportSchemaMappingID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getSpExportSchemaMappingId() {
        return this.spExportSchemaMappingId;
    }

    public void setSpExportSchemaMappingId(Integer spExportSchemaMappingId) {
        this.spExportSchemaMappingId = spExportSchemaMappingId;
    }

    @Column(name="TimeStampExported")
    public Timestamp getTimestampExported() {
        return this.timestampExported;
    }

    public void setTimestampExported(Timestamp timestampExported) {
        this.timestampExported = timestampExported;
    }

    @ManyToMany(cascade={}, fetch=FetchType.LAZY)
    @JoinTable(name="sp_schema_mapping", joinColumns={@JoinColumn(name="SpExportSchemaMappingID", unique=false, nullable=false, insertable=true, updatable=false)}, inverseJoinColumns={@JoinColumn(name="SpExportSchemaID", unique=false, nullable=false, insertable=true, updatable=false)})
    public Set<SpExportSchema> getSpExportSchemas() {
        return this.spExportSchemas;
    }

    public void setSpExportSchemas(Set<SpExportSchema> spExportSchemas) {
        this.spExportSchemas = spExportSchemas;
    }

    @Transient
    public SpExportSchema getSpExportSchema() {
        if (this.spExportSchemas.size() > 0) {
            if (this.spExportSchemas.size() > 1) {
                log.warn((Object)"getSpExportSchema() called for object with more than one schema.");
            }
            return this.spExportSchemas.iterator().next();
        }
        return null;
    }

    public void setSpExportSchema(SpExportSchema schema) {
        if (this.spExportSchemas.size() > 1) {
            log.warn((Object)"setSpExportSchema() called for object with more than one schema.");
        }
        this.spExportSchemas.clear();
        if (schema != null) {
            this.spExportSchemas.add(schema);
        }
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="exportSchemaMapping")
    @Cascade(value={CascadeType.DELETE, CascadeType.DELETE_ORPHAN})
    public Set<SpExportSchemaItemMapping> getMappings() {
        return this.mappings;
    }

    public void setMappings(Set<SpExportSchemaItemMapping> mappings) {
        this.mappings = mappings;
    }

    @Column(name="MappingName", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getMappingName() {
        return this.mappingName;
    }

    public void setMappingName(String mappingName) {
        this.mappingName = mappingName;
    }

    @Column(name="Description", unique=false, nullable=true, insertable=true, updatable=true, length=255)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return SpExportSchemaMapping.class;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.spExportSchemaMappingId;
    }

    @Override
    @Transient
    public int getTableId() {
        return SpExportSchemaMapping.getClassTableId();
    }

    @Override
    @Transient
    public boolean isChangeNotifier() {
        return false;
    }

    public static int getClassTableId() {
        return 528;
    }

    @Override
    public void initialize() {
        super.init();
        this.spExportSchemaMappingId = null;
        this.spExportSchemas = new HashSet<SpExportSchema>();
        this.mappingName = null;
        this.description = null;
        this.timestampExported = null;
        this.mappings = new HashSet<SpExportSchemaItemMapping>();
    }

    @Override
    public void forceLoad() {
        super.forceLoad();
        for (SpExportSchema schema : this.getSpExportSchemas()) {
            schema.getId();
        }
        boolean loadedQuery = false;
        for (SpExportSchemaItemMapping map : this.getMappings()) {
            if (!loadedQuery) {
                map.getQueryField().getQuery().forceLoad();
                loadedQuery = true;
            }
            map.getExportSchemaItem();
        }
    }
}

