/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.SpExportSchema;
import edu.ku.brc.specify.datamodel.SpExportSchemaItem;
import edu.ku.brc.specify.datamodel.SpExportSchemaMapping;
import edu.ku.brc.specify.datamodel.SpQuery;
import edu.ku.brc.specify.datamodel.SpQueryField;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.dom4j.Element;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="spexportschemaitemmapping")
@Table(appliesTo="spexportschemaitemmapping")
public class SpExportSchemaItemMapping
extends DataModelObjBase {
    protected Integer spExportSchemaItemMappingId;
    protected SpExportSchemaMapping spExportSchemaMapping;
    protected SpExportSchemaItem exportSchemaItem;
    protected SpQueryField queryField;
    protected String remarks;

    public void toXML(StringBuilder sb) {
        sb.append("<spexportschemaitemmapping ");
        XMLHelper.addAttr(sb, "queryField", this.queryField.getStringId());
        XMLHelper.addAttr(sb, "exportSchema", this.exportSchemaItem.getSpExportSchema().getSchemaName());
        XMLHelper.addAttr(sb, "exportSchemaItem", this.exportSchemaItem.getFieldName());
        XMLHelper.addAttr(sb, "remarks", this.remarks);
        sb.append(" />\n");
    }

    public void fromXML(Element element, SpQuery query, SpExportSchemaMapping schemaMapping) {
        this.remarks = XMLHelper.getAttr(element, "remarks", null);
        String qfId = XMLHelper.getAttr(element, "queryField", null);
        for (SpQueryField qf : query.getFields()) {
            if (!qf.getStringId().equals(qfId)) continue;
            this.queryField = qf;
            qf.setMapping(this);
            break;
        }
        String schemaName = XMLHelper.getAttr(element, "exportSchema", null);
        block1: for (SpExportSchema es : schemaMapping.getSpExportSchemas()) {
            if (!es.getSchemaName().equals(schemaName)) continue;
            String itemName = XMLHelper.getAttr(element, "exportSchemaItem", null);
            for (SpExportSchemaItem esi : es.getSpExportSchemaItems()) {
                if (!esi.getFieldName().equals(itemName)) continue;
                this.exportSchemaItem = esi;
                continue block1;
            }
        }
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return SpExportSchemaItemMapping.class;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.spExportSchemaItemMappingId;
    }

    @Override
    @Transient
    public int getTableId() {
        return SpExportSchemaItemMapping.getClassTableId();
    }

    @Override
    @Transient
    public boolean isChangeNotifier() {
        return false;
    }

    public static int getClassTableId() {
        return 527;
    }

    @Override
    public void initialize() {
        super.init();
        this.spExportSchemaItemMappingId = null;
        this.spExportSchemaMapping = null;
        this.exportSchemaItem = null;
        this.queryField = null;
        this.remarks = null;
    }

    @Id
    @GeneratedValue
    @Column(name="SpExportSchemaItemMappingID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getSpExportSchemaItemMappingId() {
        return this.spExportSchemaItemMappingId;
    }

    public void setSpExportSchemaItemMappingId(Integer spExportSchemaItemMappingId) {
        this.spExportSchemaItemMappingId = spExportSchemaItemMappingId;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="ExportSchemaItemID", unique=false, nullable=true, insertable=true, updatable=true)
    public SpExportSchemaItem getExportSchemaItem() {
        return this.exportSchemaItem;
    }

    public void setExportSchemaItem(SpExportSchemaItem exportSchemaItem) {
        this.exportSchemaItem = exportSchemaItem;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="SpQueryFieldID", unique=false, nullable=true, insertable=true, updatable=true)
    public SpQueryField getQueryField() {
        return this.queryField;
    }

    public void setQueryField(SpQueryField queryField) {
        this.queryField = queryField;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="SpExportSchemaMappingID", unique=false, nullable=true, insertable=true, updatable=true)
    public SpExportSchemaMapping getExportSchemaMapping() {
        return this.spExportSchemaMapping;
    }

    public void setExportSchemaMapping(SpExportSchemaMapping spExportSchemaMapping) {
        this.spExportSchemaMapping = spExportSchemaMapping;
    }

    @Column(name="Remarks", unique=false, nullable=true, insertable=true, updatable=true, length=255)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
}

