/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.SpExportSchema;
import edu.ku.brc.specify.datamodel.SpLocaleContainerItem;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.dom4j.Element;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="spexportschemaitem")
@Table(appliesTo="spexportschemaitem")
public class SpExportSchemaItem
extends DataModelObjBase {
    protected Integer spExportSchemaItemId;
    protected String fieldName;
    protected String dataType;
    protected String description;
    protected String formatter;
    protected SpLocaleContainerItem spLocaleContainerItem;
    protected SpExportSchema spExportSchema;

    public void toXML(StringBuilder sb) {
        sb.append("<spexportschemaitem ");
        XMLHelper.addAttr(sb, "fieldName", this.fieldName);
        XMLHelper.addAttr(sb, "dataType", this.dataType);
        XMLHelper.addAttr(sb, "formatter", this.formatter);
        sb.append("> ");
        XMLHelper.xmlNode(sb, "description", this.description, true);
        sb.append(" </spexportschemaitem>\n");
    }

    public void fromXML(Element element) {
        this.fieldName = XMLHelper.getAttr(element, "fieldName", null);
        this.dataType = XMLHelper.getAttr(element, "dataType", null);
        this.formatter = XMLHelper.getAttr(element, "formatter", null);
        List dNodes = element.selectNodes("description");
        this.description = dNodes.size() > 0 ? ((Element)dNodes.get(0)).getStringValue() : null;
    }

    @Override
    public void initialize() {
        super.init();
        this.spExportSchemaItemId = null;
        this.fieldName = null;
        this.dataType = null;
        this.description = null;
        this.formatter = null;
        this.spLocaleContainerItem = null;
        this.spExportSchema = null;
    }

    @Id
    @GeneratedValue
    @Column(name="SpExportSchemaItemID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getSpExportSchemaItemId() {
        return this.spExportSchemaItemId;
    }

    @Column(name="FieldName", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getFieldName() {
        return this.fieldName;
    }

    @Column(name="DataType", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getDataType() {
        return this.dataType;
    }

    @Column(name="Description", unique=false, nullable=true, insertable=true, updatable=true, length=255)
    public String getDescription() {
        return this.description;
    }

    @Column(name="Formatter", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getFormatter() {
        return this.formatter;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="SpLocaleContainerItemID", unique=false, nullable=true, insertable=true, updatable=true)
    public SpLocaleContainerItem getSpLocaleContainerItem() {
        return this.spLocaleContainerItem;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="SpExportSchemaID", unique=false, nullable=false, insertable=true, updatable=true)
    public SpExportSchema getSpExportSchema() {
        return this.spExportSchema;
    }

    public void setSpExportSchemaItemId(Integer exportSchemaItemId) {
        this.spExportSchemaItemId = exportSchemaItemId;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFormatter(String formatter) {
        this.formatter = formatter;
    }

    public void setSpLocaleContainerItem(SpLocaleContainerItem schemaItem) {
        this.spLocaleContainerItem = schemaItem;
    }

    public void setSpExportSchema(SpExportSchema spExportSchema) {
        this.spExportSchema = spExportSchema;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return SpExportSchemaItem.class;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.spExportSchemaItemId;
    }

    @Override
    @Transient
    public int getTableId() {
        return SpExportSchemaItem.getClassTableId();
    }

    @Override
    @Transient
    public boolean isChangeNotifier() {
        return false;
    }

    public static int getClassTableId() {
        return 525;
    }

    @Override
    public String toString() {
        return this.getFieldName();
    }
}

