/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.SpExportSchemaItem;
import edu.ku.brc.specify.datamodel.SpExportSchemaMapping;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.dom4j.Element;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="spexportschema")
@Table(appliesTo="spexportschema")
public class SpExportSchema
extends DataModelObjBase {
    protected Integer spExportSchemaId;
    protected String schemaName;
    protected String schemaVersion;
    protected String description;
    protected Set<SpExportSchemaItem> spExportSchemaItems;
    protected Set<SpExportSchemaMapping> spExportSchemaMappings;
    protected Discipline discipline;

    public void toXML(StringBuilder sb) {
        sb.append("<spexportschema ");
        XMLHelper.addAttr(sb, "schemaName", this.schemaName);
        XMLHelper.addAttr(sb, "schemaVersion", this.schemaVersion);
        XMLHelper.addAttr(sb, "description", this.description);
        sb.append(">\r\n");
        sb.append("<spexportschemaitems>\n");
        for (SpExportSchemaItem item : this.spExportSchemaItems) {
            item.toXML(sb);
        }
        sb.append("</spexportschemaitems>\n");
        sb.append("</spexportschema>");
    }

    public void fromXML(Element element) {
        this.schemaName = XMLHelper.getAttr(element, "schemaName", null);
        this.schemaVersion = XMLHelper.getAttr(element, "schemaVersion", null);
        this.description = XMLHelper.getAttr(element, "description", null);
        for (Object obj : element.selectNodes("spexportschemaitems/spexportschemaitem")) {
            Element itemEl = (Element)obj;
            SpExportSchemaItem item = new SpExportSchemaItem();
            item.initialize();
            item.fromXML(itemEl);
            item.setSpExportSchema(this);
            this.spExportSchemaItems.add(item);
        }
    }

    @Override
    public void initialize() {
        super.init();
        this.spExportSchemaId = null;
        this.schemaName = null;
        this.schemaVersion = null;
        this.description = null;
        this.spExportSchemaItems = new HashSet<SpExportSchemaItem>();
        this.spExportSchemaMappings = new HashSet<SpExportSchemaMapping>();
        this.discipline = null;
    }

    public void setSpExportSchemaId(Integer exportSchemaId) {
        this.spExportSchemaId = exportSchemaId;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setSchemaVersion(String schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setSpExportSchemaItems(Set<SpExportSchemaItem> items) {
        this.spExportSchemaItems = items;
    }

    public void setSpExportSchemaMappings(Set<SpExportSchemaMapping> mappings) {
        this.spExportSchemaMappings = mappings;
    }

    public void setDiscipline(Discipline discipline) {
        this.discipline = discipline;
    }

    @Id
    @GeneratedValue
    @Column(name="SpExportSchemaID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getSpExportSchemaId() {
        return this.spExportSchemaId;
    }

    @Column(name="SchemaName", unique=false, nullable=true, insertable=true, updatable=true, length=80)
    public String getSchemaName() {
        return this.schemaName;
    }

    @Column(name="SchemaVersion", unique=false, nullable=true, insertable=true, updatable=true, length=80)
    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    @Column(name="Description", unique=false, nullable=true, insertable=true, updatable=true, length=255)
    public String getDescription() {
        return this.description;
    }

    @OneToMany(mappedBy="spExportSchema")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<SpExportSchemaItem> getSpExportSchemaItems() {
        return this.spExportSchemaItems;
    }

    @ManyToMany(mappedBy="spExportSchemas")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<SpExportSchemaMapping> getSpExportSchemaMappings() {
        return this.spExportSchemaMappings;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="DisciplineID", unique=false, nullable=false, insertable=true, updatable=true)
    public Discipline getDiscipline() {
        return this.discipline;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return SpExportSchema.class;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.spExportSchemaId;
    }

    @Override
    @Transient
    public int getTableId() {
        return SpExportSchema.getClassTableId();
    }

    @Override
    @Transient
    public boolean isChangeNotifier() {
        return false;
    }

    public static int getClassTableId() {
        return 524;
    }

    @Override
    public String toString() {
        return String.valueOf(this.schemaName) + " (" + this.schemaVersion + ")";
    }

    @Override
    public void forceLoad() {
        super.forceLoad();
        for (SpExportSchemaItem item : this.spExportSchemaItems) {
            item.getId();
        }
    }
}

