/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.SpAppResource;
import edu.ku.brc.specify.datamodel.SpViewSetObj;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="spappresourcedir")
@Table(appliesTo="spappresourcedir", indexes={@Index(name="SpAppResourceDirDispTypeIDX", columnNames={"DisciplineType"})})
public class SpAppResourceDir
extends DataModelObjBase
implements Serializable,
Cloneable {
    protected Integer spAppResourceDirId;
    protected Collection collection;
    protected Discipline discipline;
    protected SpecifyUser specifyUser;
    protected Set<SpAppResource> spPersistedAppResources;
    protected Set<SpViewSetObj> spPersistedViewSets;
    protected String userType;
    protected String disciplineType;
    protected Boolean isPersonal;
    protected Set<SpAppResource> spAppResources = null;
    protected Set<SpViewSetObj> spViewSets = null;
    protected boolean shouldInitialViews = true;
    protected String title = null;

    public SpAppResourceDir() {
    }

    public SpAppResourceDir(Integer spAppResourceDirId) {
        this.spAppResourceDirId = spAppResourceDirId;
    }

    @Override
    public void initialize() {
        super.init();
        this.spAppResourceDirId = null;
        this.collection = AppContextMgr.getInstance().getClassObject(Collection.class);
        this.discipline = null;
        this.specifyUser = null;
        this.spPersistedAppResources = new HashSet<SpAppResource>();
        this.spPersistedViewSets = new HashSet<SpViewSetObj>();
        this.userType = null;
        this.disciplineType = null;
        this.spAppResources = null;
        this.spViewSets = new HashSet<SpViewSetObj>();
        this.isPersonal = false;
    }

    @Id
    @GeneratedValue
    @Column(name="SpAppResourceDirID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getSpAppResourceDirId() {
        return this.spAppResourceDirId;
    }

    @Override
    public void forceLoad() {
        if (this.collection != null) {
            this.collection.getCollectionName();
        }
        if (this.discipline != null) {
            this.discipline.getName();
        }
        if (this.specifyUser != null) {
            this.specifyUser.getName();
        }
        this.getSpPersistedAppResources();
        this.getSpPersistedViewSets();
    }

    @Override
    @Transient
    public boolean isChangeNotifier() {
        return false;
    }

    public void setSpAppResourceDirId(Integer spAppResourceDirId) {
        this.spAppResourceDirId = spAppResourceDirId;
    }

    @Column(name="DisciplineType", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getDisciplineType() {
        return this.disciplineType;
    }

    public void setDisciplineType(String disciplineType) {
        this.disciplineType = disciplineType;
    }

    @Column(name="UserType", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getUserType() {
        return this.userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    @Column(name="IsPersonal", unique=false, nullable=false, insertable=true, updatable=true)
    public Boolean getIsPersonal() {
        return this.isPersonal;
    }

    public void setIsPersonal(Boolean isPersonal) {
        this.isPersonal = isPersonal;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="CollectionID", unique=false, nullable=true, insertable=true, updatable=true)
    public Collection getCollection() {
        return this.collection;
    }

    public void setCollection(Collection collection) {
        this.collection = collection;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="DisciplineID", unique=false, nullable=true, insertable=true, updatable=true)
    public Discipline getDiscipline() {
        return this.discipline;
    }

    public void setDiscipline(Discipline discipline) {
        this.discipline = discipline;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="SpecifyUserID", unique=false, nullable=true, insertable=true, updatable=true)
    public SpecifyUser getSpecifyUser() {
        return this.specifyUser;
    }

    public void setSpecifyUser(SpecifyUser specifyUser) {
        this.specifyUser = specifyUser;
    }

    @OneToMany(mappedBy="spAppResourceDir")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<SpAppResource> getSpPersistedAppResources() {
        return this.spPersistedAppResources;
    }

    public void setSpPersistedAppResources(Set<SpAppResource> persistedAppResources) {
        this.spPersistedAppResources = persistedAppResources;
    }

    @OneToMany(mappedBy="spAppResourceDir")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<SpViewSetObj> getSpPersistedViewSets() {
        return this.spPersistedViewSets;
    }

    public void setSpPersistedViewSets(Set<SpViewSetObj> persistedViewSets) {
        this.spPersistedViewSets = persistedViewSets;
    }

    @Transient
    public Set<SpAppResource> getSpAppResources() {
        if (this.spAppResources == null) {
            this.spAppResources = new HashSet<SpAppResource>();
            this.spAppResources.addAll(this.getSpPersistedAppResources());
        }
        return this.spAppResources;
    }

    public void setSpAppResources(Set<SpAppResource> spAppResources) {
        this.spAppResources = spAppResources;
    }

    @Transient
    public Set<SpViewSetObj> getSpViewSets() {
        if (this.spViewSets == null || this.shouldInitialViews) {
            this.spViewSets = new HashSet<SpViewSetObj>();
            this.spViewSets.addAll(this.getSpPersistedViewSets());
            this.shouldInitialViews = false;
        }
        return this.spViewSets;
    }

    public void setSpViewSets(Set<SpViewSetObj> viewSets) {
        this.spViewSets = viewSets;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Transient
    public String getTitle() {
        return this.title;
    }

    @Transient
    public String getVerboseUniqueIdentifer() {
        if (this.collection == null && this.specifyUser == null && this.discipline == null && this.disciplineType == null && this.userType == null) {
            return "Common";
        }
        StringBuilder strBuf = new StringBuilder();
        strBuf.append(this.collection != null ? this.collection.getCollectionName() : "");
        strBuf.append(" " + (this.specifyUser != null ? this.specifyUser.getName() : ""));
        strBuf.append(" " + (this.discipline != null ? this.discipline.getType() : ""));
        strBuf.append(" " + (this.disciplineType != null ? this.disciplineType : ""));
        strBuf.append(" " + (this.userType != null ? this.userType : ""));
        strBuf.append(" " + this.isPersonal);
        return strBuf.toString();
    }

    @Transient
    public SpAppResource getResourceByName(String arName) {
        for (SpAppResource ar : this.getSpAppResources()) {
            if (ar.getName() == null || !ar.getName().equals(arName)) continue;
            return ar;
        }
        return null;
    }

    @Transient
    public String getUniqueIdentifer() {
        return this.spAppResourceDirId == null ? this.getVerboseUniqueIdentifer() : this.spAppResourceDirId.toString();
    }

    @Override
    @Transient
    public int getTableId() {
        return SpAppResourceDir.getClassTableId();
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        return this.title == null ? super.getIdentityTitle() : this.title;
    }

    @Override
    public String toString() {
        return this.getIdentityTitle();
    }

    public static int getClassTableId() {
        return 516;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.spAppResourceDirId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return SpAppResourceDir.class;
    }

    public boolean containsResource(SpAppResource appRes, boolean checkPersistentOnly) {
        Set<SpAppResource> appResSet = checkPersistentOnly ? this.getSpPersistedAppResources() : this.getSpAppResources();
        for (SpAppResource item : appResSet) {
            if (!item.equals(appRes)) continue;
            return true;
        }
        return false;
    }

    public void mergeTransientResourceAndViewSets() {
        String data;
        File file;
        if (this.spAppResources != null) {
            for (SpAppResource appRes : this.spAppResources) {
                if (appRes.getSpAppResourceDatas().size() != 0 || !(file = new File(appRes.getFileName())).exists()) continue;
                try {
                    data = FileUtils.readFileToString((File)file);
                    if (!StringUtils.isNotEmpty((String)data)) continue;
                    appRes.setDataStr(data);
                    appRes.setSpAppResourceDir(this);
                    this.spPersistedAppResources.add(appRes);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (this.spViewSets != null) {
            for (SpViewSetObj vso : this.spViewSets) {
                if (vso.getSpAppResourceDatas().size() != 0 || !(file = new File(vso.getFileName())).exists()) continue;
                try {
                    data = FileUtils.readFileToString((File)file);
                    if (!StringUtils.isNotEmpty((String)data)) continue;
                    vso.setDataAsString(data);
                    vso.setSpAppResourceDir(this);
                    this.spPersistedViewSets.add(vso);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public boolean removeResource(SpAppResource appRes) {
        return this.removeResource(appRes, true) && this.removeResource(appRes, false);
    }

    public boolean removeResource(SpAppResource appRes, boolean persistedOnly) {
        Set<SpAppResource> appResSet = persistedOnly ? this.getSpPersistedAppResources() : this.getSpAppResources();
        for (SpAppResource item : appResSet) {
            if (!item.equals(appRes)) continue;
            return appResSet.remove(item);
        }
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SpAppResourceDir dir = (SpAppResourceDir)super.clone();
        dir.spPersistedAppResources = new HashSet<SpAppResource>();
        dir.spPersistedViewSets = new HashSet<SpViewSetObj>();
        dir.spAppResources = new HashSet<SpAppResource>();
        dir.spViewSets = new HashSet<SpViewSetObj>();
        for (SpAppResource ar : this.spPersistedAppResources) {
            dir.spPersistedAppResources.add(ar);
        }
        for (SpViewSetObj vso : this.spPersistedViewSets) {
            dir.spPersistedViewSets.add(vso);
        }
        for (SpAppResource ar : this.getSpAppResources()) {
            dir.spAppResources.add(ar);
        }
        for (SpViewSetObj vso : this.getSpViewSets()) {
            dir.spViewSets.add(vso);
        }
        return dir;
    }
}

