/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.af.core.AppResourceIFace;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.SpAppResourceData;
import edu.ku.brc.specify.datamodel.SpAppResourceDir;
import edu.ku.brc.specify.datamodel.SpPrincipal;
import edu.ku.brc.specify.datamodel.SpReport;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.ui.UIRegistry;
import java.io.File;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="spappresource")
@Table(appliesTo="spappresource", indexes={@Index(name="SpAppResNameIDX", columnNames={"Name"}), @Index(name="SpAppResMimeTypeIDX", columnNames={"MimeType"})})
public class SpAppResource
extends DataModelObjBase
implements Serializable,
AppResourceIFace,
Cloneable,
Comparable<SpAppResource> {
    private static final Logger log = Logger.getLogger(SpAppResource.class);
    protected Integer spAppResourceId;
    protected Short level;
    protected String name;
    protected String description;
    protected String mimeType;
    protected String metaData;
    protected Integer ownerPermissionLevel;
    protected Integer groupPermissionLevel;
    protected Integer allPermissionLevel;
    protected Set<SpAppResourceData> spAppResourceDatas;
    protected SpAppResourceDir spAppResourceDir;
    protected Set<SpReport> spReports;
    protected SpecifyUser specifyUser;
    protected SpPrincipal group;
    protected String fileName = null;
    protected Properties metaDataHash = null;

    public SpAppResource() {
    }

    public SpAppResource(Integer spAppResourceId) {
        this.spAppResourceId = spAppResourceId;
    }

    @Override
    public void initialize() {
        super.init();
        this.spAppResourceId = null;
        this.level = null;
        this.name = null;
        this.description = null;
        this.mimeType = null;
        this.metaData = null;
        this.ownerPermissionLevel = null;
        this.groupPermissionLevel = null;
        this.allPermissionLevel = null;
        this.spAppResourceDir = null;
        this.spAppResourceDatas = new HashSet<SpAppResourceData>();
        this.spReports = new HashSet<SpReport>();
        this.specifyUser = null;
        this.group = null;
        this.fileName = null;
    }

    @Id
    @GeneratedValue
    @Column(name="SpAppResourceID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getSpAppResourceId() {
        return this.spAppResourceId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.spAppResourceId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return SpAppResource.class;
    }

    @Override
    @Transient
    public boolean isChangeNotifier() {
        return false;
    }

    public void setSpAppResourceId(Integer spAppResourceId) {
        this.spAppResourceId = spAppResourceId;
    }

    @Override
    @Column(name="Level", unique=false, nullable=false, insertable=true, updatable=true)
    public Short getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(Short level) {
        this.level = level;
    }

    @Override
    @Column(name="Name", unique=false, nullable=false, insertable=true, updatable=true, length=64)
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Column(name="Description", unique=false, nullable=true, insertable=true, updatable=true)
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    @Column(name="MimeType", unique=false, nullable=true, insertable=true, updatable=true)
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    @Override
    @Column(name="MetaData", unique=false, nullable=true, insertable=true, updatable=true)
    public String getMetaData() {
        return this.metaData;
    }

    @Override
    public String getMetaData(String attr) {
        this.initMetaData();
        return this.metaDataHash != null ? this.metaDataHash.getProperty(attr) : null;
    }

    @Override
    public void setMetaData(String metaData) {
        this.metaDataHash = null;
        this.metaData = metaData;
    }

    @Column(name="OwnerPermissionLevel", unique=false, nullable=true, insertable=true, updatable=true)
    public Integer getOwnerPermissionLevel() {
        return this.ownerPermissionLevel;
    }

    public void setOwnerPermissionLevel(Integer ownerPermissionLevel) {
        this.ownerPermissionLevel = ownerPermissionLevel;
    }

    @Override
    @Transient
    public Properties getMetaDataMap() {
        this.initMetaData();
        return this.metaDataHash;
    }

    @Column(name="GroupPermissionLevel", unique=false, nullable=true, insertable=true, updatable=true)
    public Integer getGroupPermissionLevel() {
        return this.groupPermissionLevel;
    }

    public void setGroupPermissionLevel(Integer groupPermissionLevel) {
        this.groupPermissionLevel = groupPermissionLevel;
    }

    @Column(name="AllPermissionLevel", unique=false, nullable=true, insertable=true, updatable=true)
    public Integer getAllPermissionLevel() {
        return this.allPermissionLevel;
    }

    public void setAllPermissionLevel(Integer allPermissionLevel) {
        this.allPermissionLevel = allPermissionLevel;
    }

    protected void initMetaData() {
        if (this.metaDataHash == null) {
            this.metaDataHash = new Properties();
            if (StringUtils.isNotEmpty((String)this.metaData)) {
                String[] stringArray = this.metaData.split(";");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] tokens;
                    String pair = stringArray[n2];
                    if (StringUtils.isNotEmpty((String)pair) && (tokens = pair.split("=")) != null && tokens.length == 2) {
                        this.metaDataHash.put(tokens[0], tokens[1]);
                    }
                    ++n2;
                }
            }
        }
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="appResource")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<SpReport> getSpReports() {
        return this.spReports;
    }

    public void setSpReports(Set<SpReport> spReports) {
        this.spReports = spReports;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="SpAppResourceDirID", unique=false, nullable=false, insertable=true, updatable=true)
    public SpAppResourceDir getSpAppResourceDir() {
        return this.spAppResourceDir;
    }

    public void setSpAppResourceDir(SpAppResourceDir spAppResourceDir) {
        this.spAppResourceDir = spAppResourceDir;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="SpecifyUserID", unique=false, nullable=false, insertable=true, updatable=true)
    public SpecifyUser getSpecifyUser() {
        return this.specifyUser;
    }

    public void setSpecifyUser(SpecifyUser owner) {
        this.specifyUser = owner;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="SpPrincipalID", unique=false, nullable=true, insertable=true, updatable=true)
    public SpPrincipal getGroup() {
        return this.group;
    }

    public void setGroup(SpPrincipal group) {
        this.group = group;
    }

    @Override
    @Transient
    public String getFileName() {
        return this.fileName == null ? this.name : this.fileName;
    }

    @Override
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="spAppResource")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<SpAppResourceData> getSpAppResourceDatas() {
        return this.spAppResourceDatas;
    }

    public void setSpAppResourceDatas(Set<SpAppResourceData> spAppResourceDatas) {
        this.spAppResourceDatas = spAppResourceDatas;
    }

    @Override
    public void setDataAsString(String dataStr) {
        DataProviderSessionIFace session = null;
        try {
            try {
                if (this.getId() != null) {
                    session = DataProviderFactory.getInstance().createSession();
                    session.attach(this);
                }
                this.setDataStr(dataStr);
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(SpAppResource.class, ex);
                log.error((Object)ex);
                ex.printStackTrace();
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public void setDataStr(String dataStr) {
        if (StringUtils.isNotEmpty((String)dataStr)) {
            SpAppResourceData ard;
            if (this.spAppResourceDatas.size() == 0) {
                ard = new SpAppResourceData();
                ard.initialize();
                ard.setSpAppResource(this);
                this.spAppResourceDatas.add(ard);
            } else {
                ard = this.spAppResourceDatas.iterator().next();
            }
            ard.setData(dataStr.getBytes());
        } else if (this.spAppResourceDatas.size() > 0) {
            this.spAppResourceDatas.iterator().next().setData(null);
        }
    }

    @Override
    @Transient
    public String getDataAsString() {
        return this.getDataAsString(null);
    }

    @Transient
    public String getDataAsString(DataProviderSessionIFace sessionArg) {
        SpAppResourceData appResData = null;
        DataProviderSessionIFace session = null;
        try {
            if (this.spAppResourceId != null) {
                session = sessionArg != null ? sessionArg : DataProviderFactory.getInstance().createSession();
                session.attach(this);
            }
            if (this.spAppResourceDatas.size() > 0 && (appResData = this.spAppResourceDatas.iterator().next()) != null) {
                String string = new String(appResData.getData());
                return string;
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(SpAppResource.class, ex);
            log.error((Object)ex);
            ex.printStackTrace();
        }
        finally {
            if (sessionArg == null && session != null) {
                session.close();
            }
        }
        String fileNameToOpen = this.fileName;
        boolean doesFileExist = false;
        if (StringUtils.isNotEmpty((String)fileNameToOpen)) {
            File file = new File(fileNameToOpen);
            if (!file.exists()) {
                String fName = FilenameUtils.getName((String)fileNameToOpen);
                String path = FilenameUtils.getFullPathNoEndSeparator((String)fileNameToOpen);
                path = path.substring(0, FilenameUtils.indexOfLastSeparator((String)path));
                fileNameToOpen = String.valueOf(path) + File.separator + fName;
                doesFileExist = new File(fileNameToOpen).exists();
            } else {
                doesFileExist = true;
            }
        }
        String str = null;
        if (doesFileExist) {
            File file = new File(fileNameToOpen);
            str = XMLHelper.getContents(file);
            this.timestampCreated = new Timestamp(file.lastModified());
        } else {
            UIRegistry.showError("The file in the app_resources.xml [" + this.fileName + "] is missing.");
        }
        if (str != null && str.length() > 0) {
            return StringEscapeUtils.unescapeXml((String)str);
        }
        return null;
    }

    @Override
    @Transient
    public int getTableId() {
        return SpAppResource.getClassTableId();
    }

    public static int getClassTableId() {
        return 514;
    }

    @Override
    public String toString() {
        return this.description;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SpAppResource obj = (SpAppResource)super.clone();
        obj.spAppResourceId = null;
        obj.spAppResourceDatas = new HashSet<SpAppResourceData>();
        return obj;
    }

    @Override
    @Transient
    public Timestamp getTimestampModified() {
        if (this.spAppResourceId == null && StringUtils.isNotEmpty((String)this.fileName)) {
            return new Timestamp(new File(this.fileName).lastModified());
        }
        return super.getTimestampModified();
    }

    public boolean equals(Object obj) {
        int id2;
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        SpAppResource app = (SpAppResource)obj;
        if (this.getId() == null || app.getId() == null) {
            return false;
        }
        int id1 = this.getId();
        return id1 == (id2 = app.getId().intValue());
    }

    @Override
    public int compareTo(SpAppResource o) {
        return this.name.compareToIgnoreCase(o.name);
    }
}

