/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.Borrow;
import edu.ku.brc.specify.datamodel.DisciplineMember;
import edu.ku.brc.specify.datamodel.ExchangeOut;
import edu.ku.brc.specify.datamodel.Gift;
import edu.ku.brc.specify.datamodel.Loan;
import java.io.Serializable;
import java.util.Calendar;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="shipment")
@Table(appliesTo="shipment", indexes={@Index(name="ShipmentNumberIDX", columnNames={"ShipmentNumber"}), @Index(name="ShipmentDateIDX", columnNames={"ShipmentDate"}), @Index(name="ShipmentDspMemIDX", columnNames={"DisciplineID"}), @Index(name="ShipmentMethodIDX", columnNames={"ShipmentMethod"})})
public class Shipment
extends DisciplineMember
implements Serializable {
    protected Integer shipmentId;
    protected Calendar shipmentDate;
    protected String shipmentNumber;
    protected String shipmentMethod;
    protected Short numberOfPackages;
    protected String weight;
    protected String insuredForAmount;
    protected String remarks;
    protected String text1;
    protected String text2;
    protected Float number1;
    protected Float number2;
    protected Boolean yesNo1;
    protected Boolean yesNo2;
    protected Agent shipper;
    protected Agent shippedTo;
    protected Agent shippedBy;
    protected Borrow borrow;
    protected Loan loan;
    protected Gift gift;
    protected ExchangeOut exchangeOut;

    public Shipment() {
    }

    public Shipment(Integer shipmentId) {
        this.shipmentId = shipmentId;
    }

    @Override
    public void initialize() {
        super.init();
        this.shipmentId = null;
        this.shipmentDate = null;
        this.shipmentNumber = null;
        this.shipmentMethod = null;
        this.numberOfPackages = null;
        this.weight = null;
        this.insuredForAmount = null;
        this.remarks = null;
        this.text1 = null;
        this.text2 = null;
        this.number1 = null;
        this.number2 = null;
        this.yesNo1 = null;
        this.yesNo2 = null;
        this.shipper = null;
        this.shippedTo = null;
        this.shippedBy = null;
        this.borrow = null;
        this.loan = null;
        this.gift = null;
        this.exchangeOut = null;
    }

    @Id
    @GeneratedValue
    @Column(name="ShipmentID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getShipmentId() {
        return this.shipmentId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.shipmentId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return Shipment.class;
    }

    public void setShipmentId(Integer shipmentId) {
        this.shipmentId = shipmentId;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="ShipmentDate", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getShipmentDate() {
        return this.shipmentDate;
    }

    public void setShipmentDate(Calendar shipmentDate) {
        this.shipmentDate = shipmentDate;
    }

    @Column(name="ShipmentNumber", unique=false, nullable=false, insertable=true, updatable=true, length=50)
    public String getShipmentNumber() {
        return this.shipmentNumber;
    }

    public void setShipmentNumber(String shipmentNumber) {
        this.shipmentNumber = shipmentNumber;
    }

    @Column(name="ShipmentMethod", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getShipmentMethod() {
        return this.shipmentMethod;
    }

    public void setShipmentMethod(String shipmentMethod) {
        this.shipmentMethod = shipmentMethod;
    }

    @Column(name="NumberOfPackages", unique=false, nullable=true, insertable=true, updatable=true)
    public Short getNumberOfPackages() {
        return this.numberOfPackages;
    }

    public void setNumberOfPackages(Short numberOfPackages) {
        this.numberOfPackages = numberOfPackages;
    }

    @Column(name="Weight", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getWeight() {
        return this.weight;
    }

    public void setWeight(String weight) {
        this.weight = weight;
    }

    @Column(name="InsuredForAmount", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getInsuredForAmount() {
        return this.insuredForAmount;
    }

    public void setInsuredForAmount(String insuredForAmount) {
        this.insuredForAmount = insuredForAmount;
    }

    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Column(name="Text1", length=300, unique=false, nullable=true, insertable=true, updatable=true)
    public String getText1() {
        return this.text1;
    }

    public void setText1(String text1) {
        this.text1 = text1;
    }

    @Column(name="Text2", length=300, unique=false, nullable=true, insertable=true, updatable=true)
    public String getText2() {
        return this.text2;
    }

    public void setText2(String text2) {
        this.text2 = text2;
    }

    @Column(name="Number1", unique=false, nullable=true, insertable=true, updatable=true, length=24)
    public Float getNumber1() {
        return this.number1;
    }

    public void setNumber1(Float number1) {
        this.number1 = number1;
    }

    @Column(name="Number2", unique=false, nullable=true, insertable=true, updatable=true, length=24)
    public Float getNumber2() {
        return this.number2;
    }

    public void setNumber2(Float number2) {
        this.number2 = number2;
    }

    @Column(name="YesNo1", unique=false, nullable=true, updatable=true, insertable=true)
    public Boolean getYesNo1() {
        return this.yesNo1;
    }

    public void setYesNo1(Boolean yesNo1) {
        this.yesNo1 = yesNo1;
    }

    @Column(name="YesNo2", unique=false, nullable=true, updatable=true, insertable=true)
    public Boolean getYesNo2() {
        return this.yesNo2;
    }

    public void setYesNo2(Boolean yesNo2) {
        this.yesNo2 = yesNo2;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="ShipperID", unique=false, nullable=true, insertable=true, updatable=true)
    public Agent getShipper() {
        return this.shipper;
    }

    public void setShipper(Agent agentByShipper) {
        this.shipper = agentByShipper;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="ShippedToID", unique=false, nullable=true, insertable=true, updatable=true)
    public Agent getShippedTo() {
        return this.shippedTo;
    }

    public void setShippedTo(Agent shippedTo) {
        this.shippedTo = shippedTo;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="ShippedByID", unique=false, nullable=true, insertable=true, updatable=true)
    public Agent getShippedBy() {
        return this.shippedBy;
    }

    public void setShippedBy(Agent agent) {
        this.shippedBy = agent;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="BorrowID", unique=false, nullable=true, insertable=true, updatable=true)
    public Borrow getBorrow() {
        return this.borrow;
    }

    public void setBorrow(Borrow borrow) {
        this.borrow = borrow;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="LoanID", unique=false, nullable=true, insertable=true, updatable=true)
    public Loan getLoan() {
        return this.loan;
    }

    public void setLoan(Loan loan) {
        this.loan = loan;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="GiftID", unique=false, nullable=true, insertable=true, updatable=true)
    public Gift getGift() {
        return this.gift;
    }

    public void setGift(Gift gift) {
        this.gift = gift;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="ExchangeOutID", unique=false, nullable=true, insertable=true, updatable=true)
    public ExchangeOut getExchangeOut() {
        return this.exchangeOut;
    }

    public void setExchangeOut(ExchangeOut exchangeOut) {
        this.exchangeOut = exchangeOut;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        if (this.borrow != null) {
            return Borrow.getClassTableId();
        }
        if (this.loan != null) {
            return Loan.getClassTableId();
        }
        if (this.exchangeOut != null) {
            return ExchangeOut.getClassTableId();
        }
        if (this.gift != null) {
            return Gift.getClassTableId();
        }
        return null;
    }

    @Override
    @Transient
    public Integer getParentId() {
        if (this.borrow != null) {
            return this.borrow.getId();
        }
        if (this.loan != null) {
            return this.loan.getId();
        }
        if (this.exchangeOut != null) {
            return this.exchangeOut.getId();
        }
        if (this.gift != null) {
            return this.gift.getId();
        }
        return null;
    }

    @Override
    @Transient
    public int getTableId() {
        return Shipment.getClassTableId();
    }

    public static int getClassTableId() {
        return 71;
    }
}

