/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Accession;
import edu.ku.brc.specify.datamodel.AccessionAgent;
import edu.ku.brc.specify.datamodel.AccessionAuthorization;
import edu.ku.brc.specify.datamodel.AddressOfRecord;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.AttachmentOwnerIFace;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.datamodel.RepositoryAgreementAttachment;
import java.io.Serializable;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="repositoryagreement")
@Table(appliesTo="repositoryagreement", indexes={@Index(name="RefWrkNumberIDX", columnNames={"RepositoryAgreementNumber"}), @Index(name="RefWrkStartDate", columnNames={"StartDate"})})
public class RepositoryAgreement
extends DataModelObjBase
implements AttachmentOwnerIFace<RepositoryAgreementAttachment>,
Serializable {
    protected Integer repositoryAgreementId;
    protected String repositoryAgreementNumber;
    protected String status;
    protected Calendar startDate;
    protected Calendar endDate;
    protected Calendar dateReceived;
    protected String text1;
    protected String text2;
    protected String text3;
    protected Float number1;
    protected Float number2;
    protected String remarks;
    protected Boolean yesNo1;
    protected Boolean yesNo2;
    protected Set<AccessionAuthorization> repositoryAgreementAuthorizations;
    protected Set<AccessionAgent> repositoryAgreementAgents;
    protected Set<Accession> accessions;
    protected Agent originator;
    protected Set<RepositoryAgreementAttachment> repositoryAgreementAttachments;
    protected AddressOfRecord addressOfRecord;
    protected Division division;

    public RepositoryAgreement() {
    }

    public RepositoryAgreement(Integer repositoryAgreementId) {
        this.repositoryAgreementId = repositoryAgreementId;
    }

    @Override
    public void initialize() {
        super.init();
        this.repositoryAgreementId = null;
        this.repositoryAgreementNumber = null;
        this.status = null;
        this.startDate = null;
        this.endDate = null;
        this.dateReceived = null;
        this.text1 = null;
        this.text2 = null;
        this.text3 = null;
        this.number1 = null;
        this.number2 = null;
        this.remarks = null;
        this.yesNo1 = null;
        this.yesNo2 = null;
        this.repositoryAgreementAuthorizations = new HashSet<AccessionAuthorization>();
        this.repositoryAgreementAgents = new HashSet<AccessionAgent>();
        this.accessions = new HashSet<Accession>();
        this.repositoryAgreementAttachments = new HashSet<RepositoryAgreementAttachment>();
        this.originator = null;
        this.addressOfRecord = null;
        this.division = null;
    }

    @Id
    @GeneratedValue
    @Column(name="RepositoryAgreementID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getRepositoryAgreementId() {
        return this.repositoryAgreementId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.repositoryAgreementId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return RepositoryAgreement.class;
    }

    public void setRepositoryAgreementId(Integer repositoryAgreementId) {
        this.repositoryAgreementId = repositoryAgreementId;
    }

    @Column(name="RepositoryAgreementNumber", unique=false, nullable=false, insertable=true, updatable=true, length=60)
    public String getRepositoryAgreementNumber() {
        return this.repositoryAgreementNumber;
    }

    public void setRepositoryAgreementNumber(String number) {
        this.repositoryAgreementNumber = number;
    }

    @Column(name="Status", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="StartDate", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Calendar startDate) {
        this.startDate = startDate;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="EndDate", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Calendar endDate) {
        this.endDate = endDate;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DateReceived", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getDateReceived() {
        return this.dateReceived;
    }

    public void setDateReceived(Calendar dateReceived) {
        this.dateReceived = dateReceived;
    }

    @Column(name="Text1", length=255, unique=false, nullable=true, insertable=true, updatable=true)
    public String getText1() {
        return this.text1;
    }

    public void setText1(String text1) {
        this.text1 = text1;
    }

    @Column(name="Text2", length=255, unique=false, nullable=true, insertable=true, updatable=true)
    public String getText2() {
        return this.text2;
    }

    public void setText2(String text2) {
        this.text2 = text2;
    }

    @Column(name="Text3", length=255, unique=false, nullable=true, insertable=true, updatable=true)
    public String getText3() {
        return this.text3;
    }

    public void setText3(String text3) {
        this.text3 = text3;
    }

    @Column(name="Number1", unique=false, nullable=true, insertable=true, updatable=true)
    public Float getNumber1() {
        return this.number1;
    }

    public void setNumber1(Float number1) {
        this.number1 = number1;
    }

    @Column(name="Number2", unique=false, nullable=true, insertable=true, updatable=true)
    public Float getNumber2() {
        return this.number2;
    }

    public void setNumber2(Float number2) {
        this.number2 = number2;
    }

    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Column(name="YesNo1", unique=false, nullable=true, updatable=true, insertable=true)
    public Boolean getYesNo1() {
        return this.yesNo1;
    }

    public void setYesNo1(Boolean yesNo1) {
        this.yesNo1 = yesNo1;
    }

    @Column(name="YesNo2", unique=false, nullable=true, updatable=true, insertable=true)
    public Boolean getYesNo2() {
        return this.yesNo2;
    }

    public void setYesNo2(Boolean yesNo2) {
        this.yesNo2 = yesNo2;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="repositoryAgreement")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<AccessionAuthorization> getRepositoryAgreementAuthorizations() {
        return this.repositoryAgreementAuthorizations;
    }

    public void setRepositoryAgreementAuthorizations(Set<AccessionAuthorization> repositoryAgreementAuthorizations) {
        this.repositoryAgreementAuthorizations = repositoryAgreementAuthorizations;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="repositoryAgreement")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<AccessionAgent> getRepositoryAgreementAgents() {
        return this.repositoryAgreementAgents;
    }

    public void setRepositoryAgreementAgents(Set<AccessionAgent> repositoryAgreementAgents) {
        this.repositoryAgreementAgents = repositoryAgreementAgents;
    }

    @OneToMany(mappedBy="repositoryAgreement")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @OrderBy(value="ordinal ASC")
    public Set<RepositoryAgreementAttachment> getRepositoryAgreementAttachments() {
        return this.repositoryAgreementAttachments;
    }

    public void setRepositoryAgreementAttachments(Set<RepositoryAgreementAttachment> repositoryAgreementAttachments) {
        this.repositoryAgreementAttachments = repositoryAgreementAttachments;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="AgentID", unique=false, nullable=false, insertable=true, updatable=true)
    public Agent getOriginator() {
        return this.originator;
    }

    public void setOriginator(Agent originator) {
        this.originator = originator;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="repositoryAgreement")
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.LOCK})
    public Set<Accession> getAccessions() {
        return this.accessions;
    }

    public void setAccessions(Set<Accession> accessions) {
        this.accessions = accessions;
    }

    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="AddressOfRecordID", unique=false, nullable=true, insertable=true, updatable=true)
    public AddressOfRecord getAddressOfRecord() {
        return this.addressOfRecord;
    }

    public void setAddressOfRecord(AddressOfRecord addressOfRecord) {
        this.addressOfRecord = addressOfRecord;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="DivisionID", unique=false, nullable=false, insertable=true, updatable=true)
    public Division getDivision() {
        return this.division;
    }

    public void setDivision(Division division) {
        this.division = division;
    }

    @Override
    @Transient
    public Integer getParentId() {
        if (this.division != null) {
            this.parentTblId = Division.getClassTableId();
            return this.division.getId();
        }
        Vector<Object> ids = BasicSQLUtils.querySingleCol("SELECT AccessionID FROM accession WHERE RepositoryAgreementID = " + this.repositoryAgreementId);
        if (ids.size() == 1) {
            this.parentTblId = Accession.getClassTableId();
            return (Integer)ids.get(0);
        }
        this.parentTblId = null;
        return null;
    }

    @Override
    @Transient
    public int getTableId() {
        return RepositoryAgreement.getClassTableId();
    }

    public static int getClassTableId() {
        return 70;
    }

    @Override
    @Transient
    public Set<RepositoryAgreementAttachment> getAttachmentReferences() {
        return this.repositoryAgreementAttachments;
    }
}

