/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.af.ui.db.PickListDBAdapterIFace;
import edu.ku.brc.af.ui.db.PickListItemIFace;
import edu.ku.brc.specify.datamodel.Author;
import edu.ku.brc.specify.datamodel.CollectionObjectCitation;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.DeterminationCitation;
import edu.ku.brc.specify.datamodel.Exsiccata;
import edu.ku.brc.specify.datamodel.Journal;
import edu.ku.brc.specify.datamodel.LocalityCitation;
import edu.ku.brc.specify.datamodel.ReferenceWorkAttachment;
import edu.ku.brc.specify.datamodel.TaxonCitation;
import edu.ku.brc.specify.dbsupport.TypeCode;
import edu.ku.brc.specify.dbsupport.TypeCodeItem;
import edu.ku.brc.ui.UIRegistry;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="referencework")
@Table(appliesTo="referencework", indexes={@Index(name="RefWrkTitleIDX", columnNames={"Title"}), @Index(name="RefWrkPublisherIDX", columnNames={"Publisher"}), @Index(name="RefWrkGuidIDX", columnNames={"GUID"}), @Index(name="ISBNIDX", columnNames={"ISBN"})})
public class ReferenceWork
extends DataModelObjBase
implements Serializable {
    public static final byte BOOK = 0;
    public static final byte ELECTRONIC_MEDIA = 1;
    public static final byte PAPER = 2;
    public static final byte TECHNICAL_REPORT = 3;
    public static final byte THESIS = 4;
    public static final byte SECTION_IN_BOOK = 5;
    protected Integer referenceWorkId;
    protected Byte referenceWorkType;
    protected String title;
    protected String publisher;
    protected String placeOfPublication;
    protected String workDate;
    protected String volume;
    protected String pages;
    protected String url;
    protected String libraryNumber;
    protected String isbn;
    protected String remarks;
    protected String text1;
    protected String text2;
    protected Float number1;
    protected Float number2;
    protected Boolean isPublished;
    protected Boolean yesNo1;
    protected Boolean yesNo2;
    protected String guid;
    protected Set<LocalityCitation> localityCitations;
    protected Set<CollectionObjectCitation> collectionObjectCitations;
    protected Set<TaxonCitation> taxonCitations;
    protected Set<DeterminationCitation> determinationCitations;
    protected Journal journal;
    protected Set<Author> authors;
    protected Set<Exsiccata> exsiccatae;
    protected ReferenceWork containedRFParent;
    protected Set<ReferenceWork> containedReferenceWorks;
    protected Set<ReferenceWorkAttachment> referenceWorkAttachments;

    public ReferenceWork() {
    }

    public ReferenceWork(Integer referenceWorkId) {
        this.referenceWorkId = referenceWorkId;
    }

    @Override
    public void initialize() {
        super.init();
        this.referenceWorkId = null;
        this.referenceWorkType = null;
        this.title = null;
        this.publisher = null;
        this.placeOfPublication = null;
        this.workDate = null;
        this.volume = null;
        this.pages = null;
        this.url = null;
        this.libraryNumber = null;
        this.isbn = null;
        this.remarks = null;
        this.text1 = null;
        this.text2 = null;
        this.number1 = null;
        this.number2 = null;
        this.isPublished = null;
        this.yesNo1 = null;
        this.yesNo2 = null;
        this.guid = null;
        this.localityCitations = new HashSet<LocalityCitation>();
        this.collectionObjectCitations = new HashSet<CollectionObjectCitation>();
        this.taxonCitations = new HashSet<TaxonCitation>();
        this.determinationCitations = new HashSet<DeterminationCitation>();
        this.journal = null;
        this.authors = new HashSet<Author>();
        this.exsiccatae = new HashSet<Exsiccata>();
        this.containedRFParent = null;
        this.containedReferenceWorks = new HashSet<ReferenceWork>();
    }

    @Id
    @GeneratedValue
    @Column(name="ReferenceWorkID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getReferenceWorkId() {
        return this.referenceWorkId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.referenceWorkId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return ReferenceWork.class;
    }

    public void setReferenceWorkId(Integer referenceWorkId) {
        this.referenceWorkId = referenceWorkId;
    }

    @Column(name="ReferenceWorkType", unique=false, nullable=false, insertable=true, updatable=true)
    public Byte getReferenceWorkType() {
        return this.referenceWorkType;
    }

    public void setReferenceWorkType(Byte referenceWorkType) {
        this.referenceWorkType = referenceWorkType;
    }

    @OneToMany(mappedBy="containedRFParent")
    @Cascade(value={CascadeType.SAVE_UPDATE, CascadeType.MERGE, CascadeType.LOCK})
    public Set<ReferenceWork> getContainedReferenceWorks() {
        return this.containedReferenceWorks;
    }

    public void setContainedReferenceWorks(Set<ReferenceWork> containedReferenceWorks) {
        this.containedReferenceWorks = containedReferenceWorks;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="ContainedRFParentID")
    public ReferenceWork getContainedRFParent() {
        return this.containedRFParent;
    }

    public void setContainedRFParent(ReferenceWork containedRFParent) {
        this.containedRFParent = containedRFParent;
    }

    @Column(name="Title", unique=false, nullable=true, insertable=true, updatable=true)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Column(name="Publisher", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    @Column(name="PlaceOfPublication", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getPlaceOfPublication() {
        return this.placeOfPublication;
    }

    public void setPlaceOfPublication(String placeOfPublication) {
        this.placeOfPublication = placeOfPublication;
    }

    @Column(name="WorkDate", unique=false, nullable=true, insertable=true, updatable=true, length=25)
    public String getWorkDate() {
        return this.workDate;
    }

    public void setWorkDate(String workDate) {
        this.workDate = workDate;
    }

    @Column(name="Volume", unique=false, nullable=true, insertable=true, updatable=true, length=25)
    public String getVolume() {
        return this.volume;
    }

    public void setVolume(String volume) {
        this.volume = volume;
    }

    @Column(name="Pages", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getPages() {
        return this.pages;
    }

    public void setPages(String pages) {
        this.pages = pages;
    }

    @Column(name="URL", length=1024, unique=false, nullable=true, insertable=true, updatable=true)
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Column(name="LibraryNumber", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getLibraryNumber() {
        return this.libraryNumber;
    }

    public void setLibraryNumber(String libraryNumber) {
        this.libraryNumber = libraryNumber;
    }

    @Column(name="ISBN", unique=false, nullable=true, insertable=true, updatable=true, length=16)
    public String getIsbn() {
        return this.isbn;
    }

    public void setIsbn(String isbn) {
        this.isbn = isbn;
    }

    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Column(name="GUID", unique=false, nullable=true, insertable=true, updatable=true, length=128)
    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    @Column(name="Text1", length=300, unique=false, nullable=true, insertable=true, updatable=true)
    public String getText1() {
        return this.text1;
    }

    public void setText1(String text1) {
        this.text1 = text1;
    }

    @Column(name="Text2", length=300, unique=false, nullable=true, insertable=true, updatable=true)
    public String getText2() {
        return this.text2;
    }

    public void setText2(String text2) {
        this.text2 = text2;
    }

    @Column(name="Number1", unique=false, nullable=true, insertable=true, updatable=true)
    public Float getNumber1() {
        return this.number1;
    }

    public void setNumber1(Float number1) {
        this.number1 = number1;
    }

    @Column(name="Number2", unique=false, nullable=true, insertable=true, updatable=true)
    public Float getNumber2() {
        return this.number2;
    }

    public void setNumber2(Float number2) {
        this.number2 = number2;
    }

    @Column(name="IsPublished", unique=false, nullable=true, insertable=true, updatable=true)
    public Boolean getIsPublished() {
        return this.isPublished;
    }

    public void setIsPublished(Boolean published) {
        this.isPublished = published;
    }

    @Column(name="YesNo1", unique=false, nullable=true, updatable=true, insertable=true)
    public Boolean getYesNo1() {
        return this.yesNo1;
    }

    public void setYesNo1(Boolean yesNo1) {
        this.yesNo1 = yesNo1;
    }

    @Column(name="YesNo2", unique=false, nullable=true, updatable=true, insertable=true)
    public Boolean getYesNo2() {
        return this.yesNo2;
    }

    public void setYesNo2(Boolean yesNo2) {
        this.yesNo2 = yesNo2;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="referenceWork")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<LocalityCitation> getLocalityCitations() {
        return this.localityCitations;
    }

    public void setLocalityCitations(Set<LocalityCitation> localityCitations) {
        this.localityCitations = localityCitations;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="referenceWork")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<CollectionObjectCitation> getCollectionObjectCitations() {
        return this.collectionObjectCitations;
    }

    public void setCollectionObjectCitations(Set<CollectionObjectCitation> collectionObjectCitations) {
        this.collectionObjectCitations = collectionObjectCitations;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="referenceWork")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<TaxonCitation> getTaxonCitations() {
        return this.taxonCitations;
    }

    public void setTaxonCitations(Set<TaxonCitation> taxonCitations) {
        this.taxonCitations = taxonCitations;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="referenceWork")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<DeterminationCitation> getDeterminationCitations() {
        return this.determinationCitations;
    }

    public void setDeterminationCitations(Set<DeterminationCitation> determinationCitations) {
        this.determinationCitations = determinationCitations;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="JournalID", unique=false, nullable=true, insertable=true, updatable=true)
    public Journal getJournal() {
        return this.journal;
    }

    public void setJournal(Journal journal) {
        this.journal = journal;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="referenceWork")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<Author> getAuthors() {
        return this.authors;
    }

    public void setAuthors(Set<Author> authors) {
        this.authors = authors;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="referenceWork")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<Exsiccata> getExsiccatae() {
        return this.exsiccatae;
    }

    public void setExsiccatae(Set<Exsiccata> exsiccatae) {
        this.exsiccatae = exsiccatae;
    }

    @OneToMany(mappedBy="referenceWork")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    @OrderBy(value="ordinal ASC")
    public Set<ReferenceWorkAttachment> getReferenceWorkAttachments() {
        return this.referenceWorkAttachments;
    }

    public void setReferenceWorkAttachments(Set<ReferenceWorkAttachment> referenceWorkAttachments) {
        this.referenceWorkAttachments = referenceWorkAttachments;
    }

    public void addLocalityCitations(LocalityCitation localityCitation) {
        this.localityCitations.add(localityCitation);
        localityCitation.setReferenceWork(this);
    }

    public void addCollectionObjectCitations(CollectionObjectCitation collectionObjectCitation) {
        this.collectionObjectCitations.add(collectionObjectCitation);
        collectionObjectCitation.setReferenceWork(this);
    }

    public void addTaxonCitations(TaxonCitation taxonCitation) {
        this.taxonCitations.add(taxonCitation);
        taxonCitation.setReferenceWork(this);
    }

    public void addDeterminationCitations(DeterminationCitation determinationCitation) {
        this.determinationCitations.add(determinationCitation);
        determinationCitation.setReferenceWork(this);
    }

    public void addAuthor(Author author) {
        this.authors.add(author);
        author.setReferenceWork(this);
    }

    public void addExsiccata(Exsiccata exsiccata) {
        this.exsiccatae.add(exsiccata);
        exsiccata.setReferenceWork(this);
    }

    public void removeLocalityCitations(LocalityCitation localityCitation) {
        this.localityCitations.remove(localityCitation);
        localityCitation.setReferenceWork(null);
    }

    public void removeCollectionObjectCitations(CollectionObjectCitation collectionObjectCitation) {
        this.collectionObjectCitations.remove(collectionObjectCitation);
        collectionObjectCitation.setReferenceWork(null);
    }

    public void removeTaxonCitations(TaxonCitation taxonCitation) {
        this.taxonCitations.remove(taxonCitation);
        taxonCitation.setReferenceWork(null);
    }

    public void removeDeterminationCitations(DeterminationCitation determinationCitation) {
        this.determinationCitations.remove(determinationCitation);
        determinationCitation.setReferenceWork(null);
    }

    public void removeAuthor(Author author) {
        this.authors.remove(author);
        author.setReferenceWork(null);
    }

    public void removeExsiccata(Exsiccata exsiccata) {
        this.exsiccatae.remove(exsiccata);
        exsiccata.setReferenceWork(null);
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        Integer tblId;
        Integer n = tblId = this.journal != null ? Integer.valueOf(Journal.getClassTableId()) : null;
        tblId = tblId != null ? tblId : (this.containedRFParent != null ? Integer.valueOf(ReferenceWork.getClassTableId()) : null);
        return tblId;
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.journal != null ? this.journal.getId() : (this.containedRFParent != null ? this.containedRFParent.getId() : null);
    }

    @Override
    @Transient
    public int getTableId() {
        return ReferenceWork.getClassTableId();
    }

    public static int getClassTableId() {
        return 69;
    }

    @Transient
    public static List<PickListDBAdapterIFace> getSpSystemTypeCodes() {
        Vector<PickListDBAdapterIFace> result = new Vector<PickListDBAdapterIFace>(1);
        Vector<PickListItemIFace> stats = new Vector<PickListItemIFace>(4);
        stats.add(new TypeCodeItem(UIRegistry.getResourceString("ReferenceWork_BOOK"), (Object)0));
        stats.add(new TypeCodeItem(UIRegistry.getResourceString("ReferenceWork_ELECTRONIC_MEDIA"), (Object)1));
        stats.add(new TypeCodeItem(UIRegistry.getResourceString("ReferenceWork_PAPER"), (Object)2));
        stats.add(new TypeCodeItem(UIRegistry.getResourceString("ReferenceWork_TECHNICAL_REPORT"), (Object)3));
        stats.add(new TypeCodeItem(UIRegistry.getResourceString("ReferenceWork_THESIS"), (Object)4));
        stats.add(new TypeCodeItem(UIRegistry.getResourceString("ReferenceWorks_SECTION_IN_BOOK"), (Object)5));
        result.add(new TypeCode(stats, "referenceWorkType"));
        return result;
    }

    @Transient
    public static String[] getSpSystemTypeCodeFlds() {
        String[] result = new String[]{"referenceWorkType"};
        return result;
    }
}

