/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.af.auth.specify.policy.DatabaseService;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.dbsupport.RecordSetItemIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.CollectionMember;
import edu.ku.brc.specify.datamodel.InfoRequest;
import edu.ku.brc.specify.datamodel.RecordSetItem;
import edu.ku.brc.specify.datamodel.SpPrincipal;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import javax.swing.ImageIcon;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="recordset")
@Table(appliesTo="recordset", indexes={@Index(name="RecordSetNameIDX", columnNames={"name"})})
public class RecordSet
extends CollectionMember
implements Serializable,
RecordSetIFace,
Cloneable {
    public static final Byte GLOBAL = 0;
    public static final Byte WB_UPLOAD = 1;
    public static final Byte HIDDEN = 2;
    protected Integer recordSetId;
    protected Byte type;
    protected String name;
    protected Integer dbTableId;
    protected String remarks;
    protected Set<RecordSetItem> recordSetItems;
    protected SpecifyUser specifyUser;
    protected Integer ownerPermissionLevel;
    protected Integer groupPermissionLevel;
    protected Integer allPermissionLevel;
    protected SpPrincipal group;
    protected InfoRequest infoRequest;
    protected Vector<RecordSetItemIFace> items = null;
    protected ImageIcon dataSpecificIcon = null;

    @Override
    public void initialize() {
        super.init();
        this.recordSetId = null;
        this.type = GLOBAL;
        this.name = null;
        this.dbTableId = null;
        this.remarks = null;
        this.ownerPermissionLevel = null;
        this.groupPermissionLevel = null;
        this.allPermissionLevel = null;
        this.recordSetItems = new HashSet<RecordSetItem>();
        this.specifyUser = null;
        this.group = null;
        this.infoRequest = null;
    }

    public void set(String nameArg, int dbTableIdArg, Byte typeArg) {
        this.name = nameArg;
        this.dbTableId = dbTableIdArg;
        this.type = typeArg;
    }

    @Override
    @Id
    @GeneratedValue
    @Column(name="RecordSetID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getRecordSetId() {
        return this.recordSetId;
    }

    @Column(name="Type", unique=false, nullable=false, insertable=true, updatable=true)
    public Byte getType() {
        return this.type;
    }

    @Override
    public void setType(Byte type) {
        this.type = type;
    }

    @Override
    public void setRecordSetId(Integer recordSetId) {
        this.recordSetId = recordSetId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.recordSetId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return RecordSet.class;
    }

    @Override
    @Transient
    public boolean isChangeNotifier() {
        return false;
    }

    @Override
    @Column(name="Name", unique=false, nullable=false, insertable=true, updatable=true, length=64)
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Column(name="TableID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getDbTableId() {
        return this.dbTableId;
    }

    @Override
    public void setDbTableId(Integer tableId) {
        this.dbTableId = tableId;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, mappedBy="recordSet")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<RecordSetItem> getRecordSetItems() {
        return this.recordSetItems;
    }

    public void setRecordSetItems(Set<RecordSetItem> recordSetItems) {
        this.recordSetItems = recordSetItems;
    }

    @ManyToOne(cascade={}, fetch=FetchType.EAGER)
    @JoinColumn(name="InfoRequestID", unique=false, nullable=true, insertable=true, updatable=true)
    public InfoRequest getInfoRequest() {
        return this.infoRequest;
    }

    public void setInfoRequest(InfoRequest infoRequest) {
        this.infoRequest = infoRequest;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="SpecifyUserID", unique=false, nullable=false, insertable=true, updatable=true)
    public SpecifyUser getSpecifyUser() {
        return this.specifyUser;
    }

    public void setSpecifyUser(SpecifyUser owner) {
        this.specifyUser = owner;
    }

    @Transient
    public SpecifyUser getOwner() {
        return this.getSpecifyUser();
    }

    public void setOwner(SpecifyUser owner) {
        this.setSpecifyUser(owner);
    }

    @Override
    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="SpPrincipalID", unique=false, nullable=true, insertable=true, updatable=true)
    public SpPrincipal getGroup() {
        return this.group;
    }

    public void setGroup(SpPrincipal group) {
        this.group = group;
    }

    @Override
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Column(name="OwnerPermissionLevel", unique=false, nullable=true, insertable=true, updatable=true)
    public Integer getOwnerPermissionLevel() {
        return this.ownerPermissionLevel;
    }

    public void setOwnerPermissionLevel(Integer ownerPermissionLevel) {
        this.ownerPermissionLevel = ownerPermissionLevel;
    }

    @Column(name="GroupPermissionLevel", unique=false, nullable=true, insertable=true, updatable=true)
    public Integer getGroupPermissionLevel() {
        return this.groupPermissionLevel;
    }

    public void setGroupPermissionLevel(Integer groupPermissionLevel) {
        this.groupPermissionLevel = groupPermissionLevel;
    }

    @Column(name="AllPermissionLevel", unique=false, nullable=true, insertable=true, updatable=true)
    public Integer getAllPermissionLevel() {
        return this.allPermissionLevel;
    }

    public void setAllPermissionLevel(Integer allPermissionLevel) {
        this.allPermissionLevel = allPermissionLevel;
    }

    @Override
    @Transient
    public int getNumItems() {
        return this.recordSetItems.size();
    }

    private void ensureItemsList(boolean doClear) {
        if (this.items == null) {
            this.items = new Vector();
            this.items.addAll(this.recordSetItems);
        } else if (doClear) {
            this.items.clear();
        }
    }

    @Override
    public void addAll(Collection<RecordSetItemIFace> list) {
        this.ensureItemsList(true);
        for (RecordSetItemIFace rsi : list) {
            this.items.add(rsi);
            this.recordSetItems.add((RecordSetItem)rsi);
        }
    }

    @Override
    public void clearItems() {
        if (this.items != null) {
            this.items.clear();
        }
        this.recordSetItems.clear();
    }

    @Override
    @Transient
    public Set<RecordSetItemIFace> getItems() {
        if (this.items == null) {
            this.items = new Vector();
            for (RecordSetItem rsi : this.recordSetItems) {
                this.items.add(rsi);
            }
        }
        return new HashSet<RecordSetItemIFace>(this.items);
    }

    @Override
    @Transient
    public List<RecordSetItemIFace> getOrderedItems() {
        if (this.items == null) {
            this.items = new Vector();
            for (RecordSetItem rsi : this.recordSetItems) {
                this.items.add(rsi);
            }
        }
        return this.items;
    }

    @Override
    public void removeItem(RecordSetItemIFace rsi) {
        if (this.items != null) {
            this.items.remove(rsi);
        }
        this.recordSetItems.remove(rsi);
    }

    @Override
    public void setItems(Set<RecordSetItemIFace> itemsSet) {
        this.ensureItemsList(true);
        this.recordSetItems.clear();
        for (RecordSetItemIFace rsi : itemsSet) {
            this.items.add(rsi);
            this.recordSetItems.add((RecordSetItem)rsi);
        }
    }

    @Override
    public RecordSetItemIFace addItem(Integer recordId) {
        this.ensureItemsList(false);
        RecordSetItem rsi = new RecordSetItem(recordId);
        this.items.add(rsi);
        this.recordSetItems.add(rsi);
        rsi.setRecordSet(this);
        return rsi;
    }

    @Override
    public RecordSetItemIFace addItem(String recordId) {
        this.ensureItemsList(false);
        RecordSetItem rsi = new RecordSetItem(recordId);
        this.items.add(rsi);
        this.recordSetItems.add(rsi);
        rsi.setRecordSet(this);
        return rsi;
    }

    @Override
    public RecordSetItemIFace addItem(RecordSetItemIFace item) {
        this.ensureItemsList(false);
        this.items.add(item);
        this.recordSetItems.add((RecordSetItem)item);
        ((RecordSetItem)item).setRecordSet(this);
        return item;
    }

    public static List<Integer> getIdList(Integer rsId, Set<RecordSetItem> rsiSet) {
        if (rsId != null) {
            String sql = "FROM recordsetitem WHERE RecordSetID = " + rsId;
            int count = BasicSQLUtils.getCount("SELECT count(*) " + sql);
            if (count > 0) {
                ArrayList<Integer> ids = new ArrayList<Integer>(count);
                Connection conn = null;
                Statement stmt = null;
                try {
                    try {
                        conn = DatabaseService.getInstance().getConnection();
                        stmt = conn.createStatement(1004, 1007);
                        ResultSet rs = stmt.executeQuery("SELECT RecordId " + sql);
                        while (rs.next()) {
                            ids.add(rs.getInt(1));
                        }
                        rs.close();
                    }
                    catch (SQLException e) {
                        UsageTracker.incrSQLUsageCount();
                        ExceptionTracker.getInstance().capture(RecordSet.class, e);
                        e.printStackTrace();
                        try {
                            if (conn != null) {
                                conn.close();
                            }
                            if (stmt != null) {
                                stmt.close();
                            }
                        }
                        catch (SQLException e2) {
                            UsageTracker.incrSQLUsageCount();
                            ExceptionTracker.getInstance().capture(RecordSet.class, e2);
                            e2.printStackTrace();
                        }
                    }
                }
                finally {
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException e) {
                        UsageTracker.incrSQLUsageCount();
                        ExceptionTracker.getInstance().capture(RecordSet.class, e);
                        e.printStackTrace();
                    }
                }
                return ids;
            }
            return new ArrayList<Integer>();
        }
        if (rsiSet != null && rsiSet.size() > 0) {
            ArrayList<Integer> ids = new ArrayList<Integer>(rsiSet.size());
            for (RecordSetItem item : rsiSet) {
                ids.add(item.getRecordSetItemId());
            }
        }
        return new ArrayList<Integer>();
    }

    @Override
    @Transient
    public Class<?> getDataClassFormItems() {
        DBTableInfo ti = DBTableIdMgr.getInstance().getInfoById(this.dbTableId);
        if (ti != null) {
            try {
                return Class.forName(ti.getClassName());
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(RecordSet.class, ex);
                ex.printStackTrace();
            }
        }
        return null;
    }

    @Override
    @Transient
    public RecordSetItemIFace getOnlyItem() {
        if (this.items != null && this.items.size() == 1) {
            return this.items.iterator().next();
        }
        return null;
    }

    @Override
    @Transient
    public ImageIcon getDataSpecificIcon() {
        return this.dataSpecificIcon;
    }

    @Override
    public void setDataSpecificIcon(ImageIcon dataSpecificIcon) {
        this.dataSpecificIcon = dataSpecificIcon;
    }

    @Override
    @Transient
    public int getTableId() {
        return RecordSet.getClassTableId();
    }

    public static int getClassTableId() {
        return 68;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        RecordSet obj = (RecordSet)super.clone();
        obj.recordSetId = null;
        obj.items = null;
        return obj;
    }
}

