/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.CollectionMember;
import edu.ku.brc.specify.datamodel.CollectionObject;
import java.io.Serializable;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="project")
@Table(appliesTo="project", indexes={@Index(name="ProjectNameIDX", columnNames={"ProjectName"}), @Index(name="ProjectNumberIDX", columnNames={"ProjectNumber"})})
public class Project
extends CollectionMember
implements Serializable {
    protected Integer projectId;
    protected String projectName;
    protected String projectNumber;
    protected String projectDescription;
    protected String grantNumber;
    protected String grantAgency;
    protected String url;
    protected Calendar startDate;
    protected Calendar endDate;
    protected String remarks;
    protected String text1;
    protected String text2;
    protected Float number1;
    protected Float number2;
    protected Boolean yesNo1;
    protected Boolean yesNo2;
    protected Agent agent;
    protected Set<CollectionObject> collectionObjects;

    public Project() {
    }

    public Project(Integer projectId) {
        this.projectId = projectId;
    }

    @Override
    public void initialize() {
        super.init();
        this.projectId = null;
        this.projectName = null;
        this.projectNumber = null;
        this.grantAgency = null;
        this.grantNumber = null;
        this.projectDescription = null;
        this.url = null;
        this.startDate = null;
        this.endDate = null;
        this.remarks = null;
        this.text1 = null;
        this.text2 = null;
        this.number1 = null;
        this.number2 = null;
        this.yesNo1 = null;
        this.yesNo2 = null;
        this.agent = null;
        this.collectionObjects = new HashSet<CollectionObject>();
    }

    @Id
    @GeneratedValue
    @Column(name="ProjectID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getProjectId() {
        return this.projectId;
    }

    @Override
    public void forceLoad() {
        this.collectionObjects.size();
    }

    @Override
    @Transient
    public Integer getId() {
        return this.projectId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return Project.class;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    @Column(name="ProjectName", unique=false, nullable=false, insertable=true, updatable=true, length=128)
    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Column(name="ProjectDescription", length=255, unique=false, nullable=true, insertable=true, updatable=true)
    public String getProjectDescription() {
        return this.projectDescription;
    }

    public void setProjectDescription(String projectDescription) {
        this.projectDescription = projectDescription;
    }

    @Column(name="GrantNumber", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getGrantNumber() {
        return this.grantNumber;
    }

    public void setGrantNumber(String grantNumber) {
        this.grantNumber = grantNumber;
    }

    public void setProjectNumber(String projectNumber) {
        this.projectNumber = projectNumber;
    }

    @Column(name="ProjectNumber", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getProjectNumber() {
        return this.projectNumber;
    }

    @Column(name="GrantAgency", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getGrantAgency() {
        return this.grantAgency;
    }

    public void setGrantAgency(String grantAgency) {
        this.grantAgency = grantAgency;
    }

    @Column(name="URL", length=1024, unique=false, nullable=true, insertable=true, updatable=true)
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="StartDate", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Calendar startDate) {
        this.startDate = startDate;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="EndDate", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Calendar endDate) {
        this.endDate = endDate;
    }

    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Column(name="Text1", length=300, unique=false, nullable=true, insertable=true, updatable=true)
    public String getText1() {
        return this.text1;
    }

    public void setText1(String text1) {
        this.text1 = text1;
    }

    @Column(name="Text2", length=300, unique=false, nullable=true, insertable=true, updatable=true)
    public String getText2() {
        return this.text2;
    }

    public void setText2(String text2) {
        this.text2 = text2;
    }

    @Column(name="Number1", unique=false, nullable=true, insertable=true, updatable=true, length=24)
    public Float getNumber1() {
        return this.number1;
    }

    public void setNumber1(Float number1) {
        this.number1 = number1;
    }

    @Column(name="Number2", unique=false, nullable=true, insertable=true, updatable=true, length=24)
    public Float getNumber2() {
        return this.number2;
    }

    public void setNumber2(Float number2) {
        this.number2 = number2;
    }

    @Column(name="YesNo1", unique=false, nullable=true, updatable=true, insertable=true)
    public Boolean getYesNo1() {
        return this.yesNo1;
    }

    public void setYesNo1(Boolean yesNo1) {
        this.yesNo1 = yesNo1;
    }

    @Column(name="YesNo2", unique=false, nullable=true, updatable=true, insertable=true)
    public Boolean getYesNo2() {
        return this.yesNo2;
    }

    public void setYesNo2(Boolean yesNo2) {
        this.yesNo2 = yesNo2;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="ProjectAgentID", unique=false, nullable=true, insertable=true, updatable=true)
    public Agent getAgent() {
        return this.agent;
    }

    public void setAgent(Agent agent) {
        this.agent = agent;
    }

    @ManyToMany(cascade={}, fetch=FetchType.LAZY)
    @JoinTable(name="project_colobj", joinColumns={@JoinColumn(name="ProjectID", unique=false, nullable=false, insertable=true, updatable=false)}, inverseJoinColumns={@JoinColumn(name="CollectionObjectID", unique=false, nullable=false, insertable=true, updatable=false)})
    public Set<CollectionObject> getCollectionObjects() {
        return this.collectionObjects;
    }

    public void setCollectionObjects(Set<CollectionObject> projectCollectionObjects) {
        this.collectionObjects = projectCollectionObjects;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return Collection.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.collectionMemberId != null ? this.collectionMemberId : null;
    }

    @Override
    @Transient
    public int getTableId() {
        return Project.getClassTableId();
    }

    public static int getClassTableId() {
        return 66;
    }
}

