/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.dbsupport.AttributeIFace;
import edu.ku.brc.specify.datamodel.AttributeDef;
import edu.ku.brc.specify.datamodel.CollectionMember;
import edu.ku.brc.specify.datamodel.Preparation;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="preparationattr")
@Table(appliesTo="preparationattr", indexes={@Index(name="PrepAttrColMemIDX", columnNames={"CollectionMemberID"})})
public class PreparationAttr
extends CollectionMember
implements AttributeIFace,
Serializable {
    protected Integer attrId;
    protected String strValue;
    protected Double dblValue;
    protected AttributeDef definition;
    protected Preparation preparation;

    public PreparationAttr() {
    }

    public PreparationAttr(Integer attrId) {
        this.attrId = attrId;
    }

    @Override
    public void initialize() {
        super.init();
        this.attrId = null;
        this.strValue = null;
        this.dblValue = null;
        this.definition = null;
        this.preparation = null;
    }

    @Override
    @Id
    @GeneratedValue
    @Column(name="AttrID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getAttrId() {
        return this.attrId;
    }

    @Override
    public void setAttrId(Integer attrId) {
        this.attrId = attrId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.attrId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return PreparationAttr.class;
    }

    protected void verifyType(AttributeIFace.FieldType type) {
        if (this.definition == null) {
            throw new RuntimeException("Attribute being accessed without a definition.");
        }
        if (this.definition.getDataType().shortValue() != type.getType()) {
            throw new RuntimeException("Attribute being accessed as [" + AttributeIFace.FieldType.getString(type.getType()) + "] when it is of type[" + AttributeIFace.FieldType.getString(this.definition.getDataType()) + "]");
        }
    }

    @Override
    @Column(name="StrValue", unique=false, nullable=true, insertable=true, updatable=true)
    public String getStrValue() {
        return this.strValue;
    }

    @Override
    public void setStrValue(String strValue) {
        this.strValue = strValue;
    }

    @Override
    @Column(name="DoubleValue", unique=false, nullable=true, insertable=true, updatable=true)
    public Double getDblValue() {
        return this.dblValue;
    }

    @Override
    public void setDblValue(Double value) {
        this.dblValue = value;
    }

    @Override
    @Transient
    public Float getFloatValue() {
        return new Float(this.dblValue);
    }

    @Override
    public void setFloatValue(Float value) {
        this.dblValue = new Double(value.floatValue());
    }

    @Override
    @Transient
    public Integer getIntValue() {
        return new Integer(this.dblValue.intValue());
    }

    @Override
    public void setIntValue(Integer value) {
        this.dblValue = new Double(value.intValue());
    }

    @Override
    @Transient
    public Boolean getBoolValue() {
        return new Boolean(this.dblValue.intValue() == 1);
    }

    @Override
    public void setBoolValue(Boolean value) {
        this.dblValue = new Double(value != false ? 1.0 : 0.0);
    }

    @Override
    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="AttributeDefID", unique=false, nullable=false, insertable=true, updatable=true)
    public AttributeDef getDefinition() {
        return this.definition;
    }

    public void setDefinition(AttributeDef definition) {
        this.definition = definition;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="PreparationId", unique=false, nullable=false, insertable=true, updatable=true)
    public Preparation getPreparation() {
        return this.preparation;
    }

    public void setPreparation(Preparation preparation) {
        this.preparation = preparation;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return Preparation.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.preparation != null ? this.preparation.getId() : null;
    }

    @Override
    @Transient
    public int getTableId() {
        return PreparationAttr.getClassTableId();
    }

    public static int getClassTableId() {
        return 64;
    }
}

