/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.dbsupport.AttributeIFace;
import edu.ku.brc.dbsupport.AttributeProviderIFace;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.AttachmentOwnerIFace;
import edu.ku.brc.specify.datamodel.CollectionMember;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.DeaccessionPreparation;
import edu.ku.brc.specify.datamodel.ExchangeInPrep;
import edu.ku.brc.specify.datamodel.ExchangeOutPrep;
import edu.ku.brc.specify.datamodel.GiftPreparation;
import edu.ku.brc.specify.datamodel.LoanPreparation;
import edu.ku.brc.specify.datamodel.PrepType;
import edu.ku.brc.specify.datamodel.PreparationAttachment;
import edu.ku.brc.specify.datamodel.PreparationAttr;
import edu.ku.brc.specify.datamodel.PreparationAttribute;
import edu.ku.brc.specify.datamodel.Storage;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="preparation")
@Table(appliesTo="preparation", indexes={@Index(name="PreparedDateIDX", columnNames={"preparedDate"}), @Index(name="PrepColMemIDX", columnNames={"CollectionMemberID"})})
public class Preparation
extends CollectionMember
implements AttachmentOwnerIFace<PreparationAttachment>,
AttributeProviderIFace,
Serializable,
Comparable<Preparation>,
Cloneable {
    protected Integer preparationId;
    protected String text1;
    protected String text2;
    protected Integer countAmt;
    protected String storageLocation;
    protected String remarks;
    protected Calendar preparedDate;
    protected Byte preparedDatePrecision;
    protected String status;
    protected String sampleNumber;
    protected String description;
    protected Float number1;
    protected Float number2;
    protected Boolean yesNo1;
    protected Boolean yesNo2;
    protected Boolean yesNo3;
    protected Set<GiftPreparation> giftPreparations;
    protected Set<LoanPreparation> loanPreparations;
    protected PrepType prepType;
    protected CollectionObject collectionObject;
    protected Agent preparedByAgent;
    protected Storage storage;
    protected Set<DeaccessionPreparation> deaccessionPreparations;
    protected PreparationAttribute preparationAttribute;
    protected Set<PreparationAttr> preparationAttrs;
    protected Set<PreparationAttachment> preparationAttachments;
    protected Set<ExchangeInPrep> exchangeInPreps;
    protected Set<ExchangeOutPrep> exchangeOutPreps;
    protected Boolean isOnLoan = null;

    public Preparation() {
    }

    public Preparation(Integer preparationId) {
        this.preparationId = preparationId;
    }

    @Override
    public void initialize() {
        super.init();
        this.preparationId = null;
        this.text1 = null;
        this.text2 = null;
        this.countAmt = null;
        this.storageLocation = null;
        this.remarks = null;
        this.preparedDate = null;
        this.preparedDatePrecision = null;
        this.status = null;
        this.sampleNumber = null;
        this.description = null;
        this.number1 = null;
        this.number2 = null;
        this.yesNo1 = null;
        this.yesNo2 = null;
        this.yesNo3 = null;
        this.giftPreparations = new HashSet<GiftPreparation>();
        this.loanPreparations = new HashSet<LoanPreparation>();
        this.prepType = null;
        this.collectionObject = null;
        this.preparedByAgent = null;
        this.storage = null;
        this.deaccessionPreparations = new HashSet<DeaccessionPreparation>();
        this.preparationAttribute = null;
        this.preparationAttrs = new HashSet<PreparationAttr>();
        this.preparationAttachments = new HashSet<PreparationAttachment>();
        this.exchangeInPreps = new HashSet<ExchangeInPrep>();
        this.exchangeOutPreps = new HashSet<ExchangeOutPrep>();
    }

    @Id
    @GeneratedValue
    @Column(name="PreparationID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getPreparationId() {
        return this.preparationId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.preparationId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return Preparation.class;
    }

    public void setPreparationId(Integer preparationId) {
        this.preparationId = preparationId;
    }

    @Column(name="Text1", length=300, unique=false, nullable=true, insertable=true, updatable=true)
    public String getText1() {
        return this.text1;
    }

    public void setText1(String text1) {
        this.text1 = text1;
    }

    @Column(name="Text2", length=300, unique=false, nullable=true, insertable=true, updatable=true)
    public String getText2() {
        return this.text2;
    }

    public void setText2(String text2) {
        this.text2 = text2;
    }

    @Column(name="CountAmt", unique=false, nullable=true, insertable=true, updatable=true)
    public Integer getCountAmt() {
        return this.countAmt;
    }

    public void setCountAmt(Integer countAmt) {
        this.countAmt = countAmt;
    }

    @Transient
    public int getLoanAvailable() {
        int cnt = this.countAmt != null ? this.countAmt : 0;
        return cnt - this.getLoanQuantityOut();
    }

    @Transient
    public int getLoanQuantityOut() {
        int stillOut = 0;
        for (LoanPreparation lpo : this.getLoanPreparations()) {
            int quantityLoaned = lpo.getQuantity() != null ? lpo.getQuantity() : 0;
            int quantityResolved = lpo.getQuantityResolved() != null ? lpo.getQuantityResolved() : 0;
            stillOut += quantityLoaned - quantityResolved;
        }
        return stillOut;
    }

    /*
     * Unable to fully structure code
     */
    @Transient
    public Boolean getIsOnLoan() {
        block32: {
            block31: {
                block29: {
                    block30: {
                        if (this.isOnLoan != null) break block32;
                        conn = null;
                        stmt = null;
                        conn = DBConnection.getInstance().createConnection();
                        if (conn == null) ** GOTO lbl43
                        stmt = conn.createStatement();
                        sql = "SELECT p.CountAmt, lp.Quantity, lp.QuantityResolved, lp.QuantityReturned, lp.IsResolved FROM preparation p INNER JOIN loanpreparation lp ON p.PreparationID = lp.PreparationID WHERE p.PreparationID = " + this.getId();
                        rs = stmt.executeQuery(sql);
                        totalOnLoan = 0;
                        prepQty = null;
                        while (rs.next()) {
                            prepQty = rs.getObject(1) != null ? rs.getInt(1) : 0;
                            isResolved = rs.getObject(5) != null ? rs.getBoolean(5) : false;
                            loanQty = rs.getObject(2) != null ? rs.getInt(2) : 0;
                            v0 = qtyRes = rs.getObject(3) != null ? rs.getInt(3) : 0;
                            if (isResolved && qtyRes != loanQty) {
                                qtyRes = loanQty;
                            }
                            totalOnLoan += loanQty - qtyRes;
                        }
                        rs.close();
                        if (prepQty != null) break block29;
                        var11_11 = false;
                        if (stmt == null) break block30;
                        try {
                            stmt.close();
                        }
                        catch (SQLException var12_12) {
                            // empty catch block
                        }
                    }
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException var12_13) {
                            // empty catch block
                        }
                    }
                    return var11_11;
                }
                try {
                    try {
                        this.isOnLoan = totalOnLoan > 0;
                        break block31;
lbl43:
                        // 1 sources

                        UsageTracker.incrNetworkUsageCount();
                    }
                    catch (SQLException ex) {
                        ExceptionTracker.getInstance().capture(Preparation.class, ex);
                        UsageTracker.incrSQLUsageCount();
                        ex.printStackTrace();
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (SQLException var12_14) {
                                // empty catch block
                            }
                        }
                        if (conn == null) ** GOTO lbl88
                        try {
                            conn.close();
                        }
                        catch (SQLException var12_15) {}
                    }
                }
                catch (Throwable var10_20) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException var12_16) {
                            // empty catch block
                        }
                    }
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException var12_17) {
                            // empty catch block
                        }
                    }
                    throw var10_20;
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException var12_18) {
                    // empty catch block
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException var12_19) {
                    // empty catch block
                }
            }
        }
        return this.isOnLoan == null ? false : this.isOnLoan;
    }

    public void setIsOnLoan(Boolean isOnLoan) {
        this.isOnLoan = isOnLoan;
    }

    @Column(name="StorageLocation", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getStorageLocation() {
        return this.storageLocation;
    }

    public void setStorageLocation(String storageLocation) {
        this.storageLocation = storageLocation;
    }

    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="PreparedDate", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getPreparedDate() {
        return this.preparedDate;
    }

    public void setPreparedDate(Calendar preparedDate) {
        this.preparedDate = preparedDate;
    }

    @Column(name="PreparedDatePrecision", unique=false, nullable=true, insertable=true, updatable=true)
    public Byte getPreparedDatePrecision() {
        return this.preparedDatePrecision != null ? this.preparedDatePrecision : (byte)UIFieldFormatterIFace.PartialDateEnum.Full.ordinal();
    }

    public void setPreparedDatePrecision(Byte preparedDatePrecision) {
        this.preparedDatePrecision = preparedDatePrecision;
    }

    @Column(name="Status", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Column(name="SampleNumber", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getSampleNumber() {
        return this.sampleNumber;
    }

    public void setSampleNumber(String sampleNumber) {
        this.sampleNumber = sampleNumber;
    }

    @Column(name="Description", unique=false, nullable=true, insertable=true, updatable=true, length=255)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Column(name="Number1", unique=false, nullable=true, insertable=true, updatable=true)
    public Float getNumber1() {
        return this.number1;
    }

    public void setNumber1(Float number1) {
        this.number1 = number1;
    }

    @Column(name="Number2", unique=false, nullable=true, insertable=true, updatable=true)
    public Float getNumber2() {
        return this.number2;
    }

    public void setNumber2(Float number2) {
        this.number2 = number2;
    }

    @Column(name="YesNo1", unique=false, nullable=true, insertable=true, updatable=true)
    public Boolean getYesNo1() {
        return this.yesNo1;
    }

    public void setYesNo1(Boolean yesNo1) {
        this.yesNo1 = yesNo1;
    }

    @Column(name="YesNo2", unique=false, nullable=true, insertable=true, updatable=true)
    public Boolean getYesNo2() {
        return this.yesNo2;
    }

    public void setYesNo2(Boolean yesNo2) {
        this.yesNo2 = yesNo2;
    }

    @Column(name="YesNo3", unique=false, nullable=true, insertable=true, updatable=true)
    public Boolean getYesNo3() {
        return this.yesNo3;
    }

    public void setYesNo3(Boolean yesNo3) {
        this.yesNo3 = yesNo3;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="preparation")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<LoanPreparation> getLoanPreparations() {
        return this.loanPreparations;
    }

    public void setLoanPreparations(Set<LoanPreparation> loanPreparations) {
        this.loanPreparations = loanPreparations;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="preparation")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<GiftPreparation> getGiftPreparations() {
        return this.giftPreparations;
    }

    public void setGiftPreparations(Set<GiftPreparation> giftPreparations) {
        this.giftPreparations = giftPreparations;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="preparation")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<ExchangeInPrep> getExchangeInPreps() {
        return this.exchangeInPreps;
    }

    public void setExchangeInPreps(Set<ExchangeInPrep> exchangeInPreps) {
        this.exchangeInPreps = exchangeInPreps;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="preparation")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<ExchangeOutPrep> getExchangeOutPreps() {
        return this.exchangeOutPreps;
    }

    public void setExchangeOutPreps(Set<ExchangeOutPrep> exchangeOutPreps) {
        this.exchangeOutPreps = exchangeOutPreps;
    }

    @OneToMany(targetEntity=PreparationAttr.class, cascade={}, fetch=FetchType.LAZY, mappedBy="preparation")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<PreparationAttr> getPreparationAttrs() {
        return this.preparationAttrs;
    }

    public void setPreparationAttrs(Set<PreparationAttr> preparationAttrs) {
        this.preparationAttrs = preparationAttrs;
    }

    @Override
    @Transient
    public Set<AttributeIFace> getAttrs() {
        return new HashSet<AttributeIFace>(this.preparationAttrs);
    }

    @Override
    public void setAttrs(Set<AttributeIFace> preparationAttrs) {
        this.preparationAttrs.clear();
        for (AttributeIFace a : preparationAttrs) {
            if (!(a instanceof PreparationAttr)) continue;
            this.preparationAttrs.add((PreparationAttr)a);
        }
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="PrepTypeID", unique=false, nullable=false, insertable=true, updatable=true)
    public PrepType getPrepType() {
        return this.prepType;
    }

    public void setPrepType(PrepType prepType) {
        this.prepType = prepType;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="CollectionObjectID", unique=false, nullable=false, insertable=true, updatable=true)
    public CollectionObject getCollectionObject() {
        return this.collectionObject;
    }

    public void setCollectionObject(CollectionObject collectionObject) {
        this.collectionObject = collectionObject;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="PreparedByID", unique=false, nullable=true, insertable=true, updatable=true)
    public Agent getPreparedByAgent() {
        return this.preparedByAgent;
    }

    public void setPreparedByAgent(Agent preparedByAgent) {
        this.preparedByAgent = preparedByAgent;
    }

    @OneToMany(mappedBy="preparation")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @OrderBy(value="ordinal ASC")
    public Set<PreparationAttachment> getPreparationAttachments() {
        return this.preparationAttachments;
    }

    public void setPreparationAttachments(Set<PreparationAttachment> preparationAttachments) {
        this.preparationAttachments = preparationAttachments;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="StorageID", unique=false, nullable=true, insertable=true, updatable=true)
    public Storage getStorage() {
        return this.storage;
    }

    public void setStorage(Storage storage) {
        this.storage = storage;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="preparation")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<DeaccessionPreparation> getDeaccessionPreparations() {
        return this.deaccessionPreparations;
    }

    public void setDeaccessionPreparations(Set<DeaccessionPreparation> deaccessionPreparations) {
        this.deaccessionPreparations = deaccessionPreparations;
    }

    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="PreparationAttributeID", unique=false, nullable=true, insertable=true, updatable=true)
    public PreparationAttribute getPreparationAttribute() {
        return this.preparationAttribute;
    }

    public void setPreparationAttribute(PreparationAttribute preparationAttribute) {
        this.preparationAttribute = preparationAttribute;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return CollectionObject.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.collectionObject != null ? this.collectionObject.getId() : null;
    }

    @Override
    @Transient
    public int getTableId() {
        return Preparation.getClassTableId();
    }

    public static int getClassTableId() {
        return 63;
    }

    @Override
    @Transient
    public Set<PreparationAttachment> getAttachmentReferences() {
        return this.preparationAttachments;
    }

    @Override
    public void forceLoad() {
        this.preparationAttachments.size();
        this.preparationAttrs.size();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Preparation obj = (Preparation)super.clone();
        obj.preparationId = null;
        obj.loanPreparations = new HashSet<LoanPreparation>();
        obj.collectionObject = null;
        obj.deaccessionPreparations = new HashSet<DeaccessionPreparation>();
        obj.preparationAttachments = new HashSet<PreparationAttachment>();
        obj.preparationAttribute = this.preparationAttribute != null ? (PreparationAttribute)this.preparationAttribute.clone() : null;
        obj.preparationAttrs = new HashSet<PreparationAttr>();
        for (PreparationAttr pa : this.preparationAttrs) {
            PreparationAttr newPA = (PreparationAttr)pa.clone();
            obj.preparationAttrs.add(newPA);
            newPA.setPreparation(obj);
        }
        return obj;
    }

    @Override
    public int compareTo(Preparation obj) {
        if (this.prepType != null && obj != null && StringUtils.isNotEmpty((String)this.prepType.name) && StringUtils.isNotEmpty((String)obj.prepType.name)) {
            return this.prepType.name.toLowerCase().compareTo(obj.prepType.name.toLowerCase());
        }
        return this.timestampCreated != null && obj != null && obj.timestampCreated != null ? this.timestampCreated.compareTo(obj.timestampCreated) : 0;
    }
}

