/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.af.ui.db.PickListIFace;
import edu.ku.brc.af.ui.db.PickListItemIFace;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.PickList;
import edu.ku.brc.ui.TitleValueIFace;
import edu.ku.brc.util.Orderable;
import java.io.Serializable;
import java.sql.Timestamp;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Proxy;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@Table(name="picklistitem")
public class PickListItem
extends DataModelObjBase
implements PickListItemIFace,
Orderable,
Serializable,
TitleValueIFace {
    protected Integer pickListItemId;
    private String title;
    private String value;
    private Integer ordinal;
    protected PickList pickList;
    private Object valueObject;

    public PickListItem() {
    }

    public PickListItem(String title, String value, Timestamp timestampCreated) {
        this.initialize();
        this.title = title;
        this.value = value;
        this.timestampCreated = timestampCreated;
    }

    public PickListItem(String title, Object valueObject, Timestamp timestampCreated) {
        this.initialize();
        this.title = title;
        this.valueObject = valueObject;
        this.timestampCreated = timestampCreated;
    }

    @Override
    public void initialize() {
        super.init();
        this.pickListItemId = null;
        this.title = null;
        this.value = null;
        this.pickList = null;
        this.ordinal = 0;
    }

    @Id
    @GeneratedValue
    @Column(name="PickListItemID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getPickListItemId() {
        return this.pickListItemId;
    }

    public void setPickListItemId(Integer pickListItemId) {
        this.pickListItemId = pickListItemId;
    }

    @Override
    @Column(name="Title", nullable=false, length=64)
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    @ManyToOne(cascade={}, fetch=FetchType.EAGER)
    @Cascade(value={CascadeType.SAVE_UPDATE, CascadeType.MERGE, CascadeType.LOCK})
    @JoinColumn(name="PickListID", nullable=false)
    public PickList getPickList() {
        return this.pickList;
    }

    @Override
    public void SetPickList(PickListIFace pickListArg) {
        if (!(pickListArg instanceof PickList)) {
            throw new RuntimeException("PickListIFace is not of class PickList");
        }
        this.pickList = (PickList)pickListArg;
    }

    public void setPickList(PickList pickList) {
        this.pickList = pickList;
    }

    @Override
    public void setPickList(PickListIFace pickList) {
        this.setPickList((PickList)pickList);
    }

    @Override
    @Column(name="Value", length=64)
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    @Transient
    public Object getValueObject() {
        return this.valueObject == null ? this.value : this.valueObject;
    }

    @Override
    public void setValueObject(Object valueObject) {
        this.valueObject = valueObject;
    }

    @Override
    @Column(name="Ordinal")
    public Integer getOrdinal() {
        return this.ordinal == null ? 0 : this.ordinal;
    }

    @Override
    public void setOrdinal(Integer ordinal) {
        this.ordinal = ordinal;
    }

    @Override
    public String toString() {
        return this.title;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.pickListItemId;
    }

    @Override
    @Transient
    public int getTableId() {
        return PickListItem.getClassTableId();
    }

    @Transient
    public static int getClassTableId() {
        return 501;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return PickListItem.class;
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        return StringUtils.isNotEmpty((String)this.title) ? this.title : super.getIdentityTitle();
    }

    @Override
    @Transient
    public int getOrderIndex() {
        return this.getOrdinal();
    }

    @Override
    public void setOrderIndex(int order) {
        this.ordinal = order;
    }

    @Override
    public int compareTo(PickListItemIFace obj) {
        Byte sortType = null;
        if (this.pickList != null) {
            sortType = this.pickList.getSortType();
        }
        if (sortType != null && sortType.equals((byte)2)) {
            if (this.ordinal.equals(obj.getOrdinal())) {
                return 0;
            }
            return this.ordinal.compareTo(obj.getOrdinal());
        }
        if (this.title != null && obj != null && obj.getTitle() != null) {
            return this.title.compareTo(obj.getTitle());
        }
        return 0;
    }
}

