/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.ui.db.PickListIFace;
import edu.ku.brc.af.ui.db.PickListItemIFace;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.PickListItem;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="picklist")
@Table(appliesTo="picklist", indexes={@Index(name="PickListNameIDX", columnNames={"Name"})})
public class PickList
extends DataModelObjBase
implements PickListIFace,
Serializable,
Comparable<PickList> {
    protected Integer pickListId;
    protected String name;
    protected Byte type;
    protected String tableName;
    protected String fieldName;
    protected String filterFieldName;
    protected String filterValue;
    protected String formatter;
    protected Boolean readOnly;
    protected Integer sizeLimit;
    protected Boolean isSystem;
    protected Byte sortType;
    protected Set<PickListItem> pickListItems;
    protected Collection collection;
    protected Set<PickListItemIFace> items = null;

    public PickList() {
    }

    public PickList(String name) {
        this.name = name;
    }

    public PickList(Integer pickListId) {
        this.pickListId = pickListId;
    }

    @Override
    public void initialize() {
        super.init();
        this.pickListId = null;
        this.name = null;
        this.type = 0;
        this.tableName = null;
        this.fieldName = null;
        this.formatter = null;
        this.readOnly = false;
        this.sizeLimit = 50;
        this.isSystem = false;
        this.filterFieldName = null;
        this.filterValue = null;
        this.sortType = 1;
        this.collection = AppContextMgr.getInstance() == null || !AppContextMgr.getInstance().hasContext() ? null : AppContextMgr.getInstance().getClassObject(Collection.class);
        this.pickListItems = new HashSet<PickListItem>();
    }

    @Id
    @GeneratedValue
    @Column(name="PickListID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getPickListId() {
        return this.pickListId;
    }

    public void setPickListId(Integer pickListId) {
        this.pickListId = pickListId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.pickListId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return PickList.class;
    }

    @Override
    @Transient
    public boolean isChangeNotifier() {
        return false;
    }

    @Override
    @Column(name="Name", unique=false, nullable=false, insertable=true, updatable=true, length=64)
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Column(name="ReadOnly", unique=false, nullable=false, insertable=true, updatable=true)
    public Boolean getReadOnly() {
        return this.readOnly == null ? false : this.readOnly;
    }

    @Override
    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    @Column(name="SizeLimit", unique=false, nullable=true, insertable=true, updatable=true, length=10)
    public Integer getSizeLimit() {
        return this.sizeLimit;
    }

    @Override
    public void setSizeLimit(Integer sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    @Override
    @Column(name="FieldName", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    @Column(name="TableName", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    @Column(name="Formatter", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getFormatter() {
        return this.formatter;
    }

    @Override
    public void setFormatter(String formatter) {
        this.formatter = formatter;
    }

    @Override
    @Column(name="Type", unique=false, nullable=false, insertable=true, updatable=true)
    public Byte getType() {
        return this.type;
    }

    @Override
    public void setType(Byte type) {
        this.type = type;
    }

    @Override
    @Transient
    public boolean isSystem() {
        return this.isSystem == null ? false : this.isSystem;
    }

    @Override
    @Column(name="FilterFieldName", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getFilterFieldName() {
        return this.filterFieldName;
    }

    @Override
    public void setFilterFieldName(String filterFieldName) {
        this.filterFieldName = filterFieldName;
    }

    @Override
    @Column(name="FilterValue", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getFilterValue() {
        return this.filterValue;
    }

    @Override
    public void setFilterValue(String filterValue) {
        this.filterValue = filterValue;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, mappedBy="pickList")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<PickListItem> getPickListItems() {
        return this.pickListItems;
    }

    @Column(name="IsSystem", unique=false, nullable=false, updatable=true, insertable=true)
    public Boolean getIsSystem() {
        return this.isSystem;
    }

    public void setIsSystem(Boolean isSystem) {
        this.isSystem = isSystem;
    }

    @Column(name="SortType", unique=false, nullable=true, insertable=true, updatable=true)
    public Byte getSortType() {
        return this.sortType;
    }

    public void setSortType(Byte sortType) {
        this.sortType = sortType;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="CollectionID", unique=false, nullable=false, insertable=true, updatable=true)
    public Collection getCollection() {
        return this.collection;
    }

    public void setCollection(Collection collection) {
        this.collection = collection;
    }

    public void setPickListItems(Set<PickListItem> items) {
        this.pickListItems = items;
    }

    @Override
    @Transient
    public int getNumItems() {
        return this.pickListItems.size();
    }

    @Override
    public void removeItem(PickListItemIFace item) {
        if (this.items != null) {
            this.items.remove(item);
        }
        this.pickListItems.remove(item);
    }

    @Override
    @Transient
    public Set<PickListItemIFace> getItems() {
        if (this.items == null) {
            this.items = new HashSet<PickListItemIFace>();
            for (PickListItem rsi : this.pickListItems) {
                this.items.add(rsi);
            }
        }
        return this.items;
    }

    public void setItems(Set<PickListItemIFace> items) {
        this.items = items;
    }

    public PickListItemIFace addItem(String title, String value, Integer ordinal) {
        if (this.items == null) {
            this.items = new HashSet<PickListItemIFace>();
        }
        PickListItem pli = new PickListItem(title, value, new Timestamp(System.currentTimeMillis()));
        pli.setOrdinal(ordinal);
        this.items.add(pli);
        this.pickListItems.add(pli);
        pli.setPickList(this);
        return pli;
    }

    @Override
    public PickListItemIFace addItem(String title, String value) {
        return this.addItem(title, value, null);
    }

    @Override
    public PickListItemIFace addItem(String title, Object value) {
        if (this.items == null) {
            this.items = new HashSet<PickListItemIFace>();
        }
        PickListItem pli = new PickListItem(title, value, new Timestamp(System.currentTimeMillis()));
        this.items.add(pli);
        this.pickListItems.add(pli);
        pli.setPickList(this);
        return pli;
    }

    @Override
    public PickListItemIFace addItem(PickListItemIFace item) {
        if (this.items == null) {
            this.items = new HashSet<PickListItemIFace>();
        }
        this.items.add(item);
        this.pickListItems.add((PickListItem)item);
        return item;
    }

    @Override
    public void reorder() {
        if (this.sortType.equals((byte)2)) {
            int order = 0;
            for (PickListItemIFace item : this.getItems()) {
                item.setOrdinal(order++);
            }
        }
    }

    @Override
    @Transient
    public int getTableId() {
        return PickList.getClassTableId();
    }

    public static int getClassTableId() {
        return 500;
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        return StringUtils.isNotEmpty((String)this.name) ? this.name : super.getIdentityTitle();
    }

    @Override
    public int compareTo(PickList o) {
        return this.name != null && o != null && o.name != null ? this.name.toLowerCase().compareTo(o.name.toLowerCase()) : 0;
    }

    @Override
    public String toString() {
        return this.name;
    }
}

