/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.AccessionAuthorization;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.AttachmentOwnerIFace;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.PermitAttachment;
import java.io.Serializable;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="permit")
@Table(appliesTo="permit", indexes={@Index(name="PermitNumberIDX", columnNames={"PermitNumber"}), @Index(name="IssuedDateIDX", columnNames={"IssuedDate"})})
public class Permit
extends DataModelObjBase
implements AttachmentOwnerIFace<PermitAttachment>,
Serializable {
    protected Integer permitId;
    protected String permitNumber;
    protected String type;
    protected Calendar issuedDate;
    protected Calendar startDate;
    protected Calendar endDate;
    protected Calendar renewalDate;
    protected String remarks;
    protected String text1;
    protected String text2;
    protected Float number1;
    protected Float number2;
    protected Boolean yesNo1;
    protected Boolean yesNo2;
    protected Set<AccessionAuthorization> accessionAuthorizations;
    protected Agent issuedTo;
    protected Agent issuedBy;
    protected Set<PermitAttachment> permitAttachments;

    public Permit() {
    }

    public Permit(Integer permitId) {
        this.permitId = permitId;
    }

    @Override
    public void initialize() {
        super.init();
        this.permitId = null;
        this.permitNumber = null;
        this.type = null;
        this.issuedDate = null;
        this.startDate = null;
        this.endDate = null;
        this.renewalDate = null;
        this.remarks = null;
        this.text1 = null;
        this.text2 = null;
        this.number1 = null;
        this.number2 = null;
        this.yesNo1 = null;
        this.yesNo2 = null;
        this.accessionAuthorizations = new HashSet<AccessionAuthorization>();
        this.issuedTo = null;
        this.issuedBy = null;
        this.permitAttachments = new HashSet<PermitAttachment>();
    }

    @Id
    @GeneratedValue
    @Column(name="PermitID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getPermitId() {
        return this.permitId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.permitId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return Permit.class;
    }

    public void setPermitId(Integer permitId) {
        this.permitId = permitId;
    }

    @Column(name="PermitNumber", unique=false, nullable=false, insertable=true, updatable=true, length=50)
    public String getPermitNumber() {
        return this.permitNumber;
    }

    public void setPermitNumber(String permitNumber) {
        this.permitNumber = permitNumber;
    }

    @Column(name="Type", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="IssuedDate", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getIssuedDate() {
        return this.issuedDate;
    }

    public void setIssuedDate(Calendar issuedDate) {
        this.issuedDate = issuedDate;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="StartDate", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Calendar startDate) {
        this.startDate = startDate;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="EndDate", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Calendar endDate) {
        this.endDate = endDate;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="RenewalDate", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getRenewalDate() {
        return this.renewalDate;
    }

    public void setRenewalDate(Calendar renewalDate) {
        this.renewalDate = renewalDate;
    }

    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Column(name="Text1", length=300, unique=false, nullable=true, insertable=true, updatable=true)
    public String getText1() {
        return this.text1;
    }

    public void setText1(String text1) {
        this.text1 = text1;
    }

    @Column(name="Text2", length=300, unique=false, nullable=true, insertable=true, updatable=true)
    public String getText2() {
        return this.text2;
    }

    public void setText2(String text2) {
        this.text2 = text2;
    }

    @Column(name="Number1", unique=false, nullable=true, insertable=true, updatable=true, length=24)
    public Float getNumber1() {
        return this.number1;
    }

    public void setNumber1(Float number1) {
        this.number1 = number1;
    }

    @Column(name="Number2", unique=false, nullable=true, insertable=true, updatable=true, length=24)
    public Float getNumber2() {
        return this.number2;
    }

    public void setNumber2(Float number2) {
        this.number2 = number2;
    }

    @Column(name="YesNo1", unique=false, nullable=true, updatable=true, insertable=true)
    public Boolean getYesNo1() {
        return this.yesNo1;
    }

    public void setYesNo1(Boolean yesNo1) {
        this.yesNo1 = yesNo1;
    }

    @Column(name="YesNo2", unique=false, nullable=true, updatable=true, insertable=true)
    public Boolean getYesNo2() {
        return this.yesNo2;
    }

    public void setYesNo2(Boolean yesNo2) {
        this.yesNo2 = yesNo2;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="permit")
    @Cascade(value={CascadeType.SAVE_UPDATE, CascadeType.MERGE, CascadeType.LOCK})
    public Set<AccessionAuthorization> getAccessionAuthorizations() {
        return this.accessionAuthorizations;
    }

    public void setAccessionAuthorizations(Set<AccessionAuthorization> accessionAuthorizations) {
        this.accessionAuthorizations = accessionAuthorizations;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="IssuedToID", unique=false, nullable=true, insertable=true, updatable=true)
    public Agent getIssuedTo() {
        return this.issuedTo;
    }

    public void setIssuedTo(Agent issuedTo) {
        this.issuedTo = issuedTo;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="IssuedByID", unique=false, nullable=true, insertable=true, updatable=true)
    public Agent getIssuedBy() {
        return this.issuedBy;
    }

    public void setIssuedBy(Agent issuedBy) {
        this.issuedBy = issuedBy;
    }

    @OneToMany(mappedBy="permit")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    @OrderBy(value="ordinal ASC")
    public Set<PermitAttachment> getPermitAttachments() {
        return this.permitAttachments;
    }

    public void setPermitAttachments(Set<PermitAttachment> permitAttachments) {
        this.permitAttachments = permitAttachments;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return AccessionAuthorization.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        Vector<Object> ids = BasicSQLUtils.querySingleCol("SELECT AccessionAuthorizationID FROM accessionauthorization WHERE PermitID = " + this.permitId);
        if (ids.size() == 1) {
            return (Integer)ids.get(0);
        }
        return null;
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        return this.permitNumber != null ? this.permitNumber : super.getIdentityTitle();
    }

    @Override
    @Transient
    public int getTableId() {
        return Permit.getClassTableId();
    }

    public static int getClassTableId() {
        return 6;
    }

    @Override
    @Transient
    public Set<PermitAttachment> getAttachmentReferences() {
        return this.permitAttachments;
    }
}

