/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.CollectionMember;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.GeologicTimePeriod;
import edu.ku.brc.specify.datamodel.LithoStrat;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="paleocontext")
@Table(appliesTo="paleocontext", indexes={@Index(name="PaleoCxtColMemIDX", columnNames={"CollectionMemberID"})})
public class PaleoContext
extends CollectionMember
implements Cloneable {
    protected Integer paleoContextId;
    protected Float topDistance;
    protected Float bottomDistance;
    protected String distanceUnits;
    protected String direction;
    protected String positionState;
    protected String remarks;
    protected String text1;
    protected String text2;
    protected Boolean yesNo1;
    protected Boolean yesNo2;
    protected Set<CollectionObject> collectionObjects;
    protected LithoStrat lithoStrat;
    protected GeologicTimePeriod bioStrat;
    protected GeologicTimePeriod chronosStrat;
    protected GeologicTimePeriod chronosStratEnd;

    @Id
    @GeneratedValue
    @Column(name="PaleoContextID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getPaleoContextId() {
        return this.paleoContextId;
    }

    public void setPaleoContextId(Integer paleoContextId) {
        this.paleoContextId = paleoContextId;
    }

    @Override
    public void initialize() {
        super.init();
        this.paleoContextId = null;
        this.topDistance = null;
        this.bottomDistance = null;
        this.distanceUnits = null;
        this.direction = null;
        this.positionState = null;
        this.remarks = null;
        this.text1 = null;
        this.text2 = null;
        this.yesNo1 = null;
        this.yesNo2 = null;
        this.collectionObjects = new HashSet<CollectionObject>();
        this.lithoStrat = null;
        this.bioStrat = null;
        this.chronosStrat = null;
        this.chronosStratEnd = null;
    }

    @Column(name="Direction", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    @Column(name="DistanceUnits", unique=false, nullable=true, insertable=true, updatable=true, length=16)
    public String getDistanceUnits() {
        return this.distanceUnits;
    }

    public void setDistanceUnits(String distanceUnits) {
        this.distanceUnits = distanceUnits;
    }

    @Column(name="TopDistance", unique=false, nullable=true, insertable=true, updatable=true)
    public Float getTopDistance() {
        return this.topDistance;
    }

    public void setTopDistance(Float topDistance) {
        this.topDistance = topDistance;
    }

    @Column(name="BottomDistance", unique=false, nullable=true, insertable=true, updatable=true)
    public Float getBottomDistance() {
        return this.bottomDistance;
    }

    public void setBottomDistance(Float bottomDistance) {
        this.bottomDistance = bottomDistance;
    }

    @Column(name="PositionState", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getPositionState() {
        return this.positionState;
    }

    public void setPositionState(String positionState) {
        this.positionState = positionState;
    }

    public void setCollectionObjects(Set<CollectionObject> collectionObjects) {
        this.collectionObjects = collectionObjects;
    }

    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Column(name="Text1", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getText1() {
        return this.text1;
    }

    public void setText1(String text1) {
        this.text1 = text1;
    }

    @Column(name="Text2", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getText2() {
        return this.text2;
    }

    public void setText2(String text2) {
        this.text2 = text2;
    }

    @Column(name="YesNo1", unique=false, nullable=true, insertable=true, updatable=true)
    public Boolean getYesNo1() {
        return this.yesNo1;
    }

    public void setYesNo1(Boolean yesNo1) {
        this.yesNo1 = yesNo1;
    }

    @Column(name="YesNo2", unique=false, nullable=true, insertable=true, updatable=true)
    public Boolean getYesNo2() {
        return this.yesNo2;
    }

    public void setYesNo2(Boolean yesNo2) {
        this.yesNo2 = yesNo2;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="paleoContext")
    public Set<CollectionObject> getCollectionObjects() {
        return this.collectionObjects;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="BioStratID", unique=false, nullable=true, insertable=true, updatable=true)
    public GeologicTimePeriod getBioStrat() {
        return this.bioStrat;
    }

    public void setBioStrat(GeologicTimePeriod bioStrat) {
        this.bioStrat = bioStrat;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="ChronosStratID", unique=false, nullable=true, insertable=true, updatable=true)
    public GeologicTimePeriod getChronosStrat() {
        return this.chronosStrat;
    }

    public void setChronosStrat(GeologicTimePeriod chronosStrat) {
        this.chronosStrat = chronosStrat;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="ChronosStratEndID", unique=false, nullable=true, insertable=true, updatable=true)
    public GeologicTimePeriod getChronosStratEnd() {
        return this.chronosStratEnd;
    }

    public void setChronosStratEnd(GeologicTimePeriod chronosStratEnd) {
        this.chronosStratEnd = chronosStratEnd;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="LithoStratID", unique=false, nullable=true, insertable=true, updatable=true)
    public LithoStrat getLithoStrat() {
        return this.lithoStrat;
    }

    public void setLithoStrat(LithoStrat lithoStrat) {
        this.lithoStrat = lithoStrat;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return PaleoContext.class;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.paleoContextId;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return CollectionObject.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        Vector<Object> ids = BasicSQLUtils.querySingleCol("SELECT CollectionObjectID FROM collectionobject WHERE PaleoContextID = " + this.paleoContextId);
        if (ids.size() == 1) {
            return (Integer)ids.get(0);
        }
        return null;
    }

    @Override
    @Transient
    public int getTableId() {
        return PaleoContext.getClassTableId();
    }

    public static int getClassTableId() {
        return 32;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PaleoContext pc = (PaleoContext)super.clone();
        pc.paleoContextId = null;
        pc.collectionObjects = new HashSet<CollectionObject>();
        return pc;
    }
}

