/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.ui.db.PickListDBAdapterIFace;
import edu.ku.brc.af.ui.db.PickListItemIFace;
import edu.ku.brc.af.ui.forms.validation.ValComboBoxFromQuery;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.services.mapping.LocalityMapper;
import edu.ku.brc.specify.datamodel.AttachmentOwnerIFace;
import edu.ku.brc.specify.datamodel.CollectingEvent;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.DisciplineMember;
import edu.ku.brc.specify.datamodel.GeoCoordDetail;
import edu.ku.brc.specify.datamodel.Geography;
import edu.ku.brc.specify.datamodel.LatLonPolygon;
import edu.ku.brc.specify.datamodel.LocalityAttachment;
import edu.ku.brc.specify.datamodel.LocalityCitation;
import edu.ku.brc.specify.datamodel.LocalityDetail;
import edu.ku.brc.specify.datamodel.LocalityNameAlias;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.dbsupport.TypeCode;
import edu.ku.brc.specify.dbsupport.TypeCodeItem;
import edu.ku.brc.ui.UIRegistry;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Transient;
import org.hibernate.LazyInitializationException;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="locality")
@Table(appliesTo="locality", indexes={@Index(name="localityNameIDX", columnNames={"LocalityName"}), @Index(name="LocalityDisciplineIDX", columnNames={"DisciplineID"}), @Index(name="NamedPlaceIDX", columnNames={"NamedPlace"}), @Index(name="RelationToNamedPlaceIDX", columnNames={"RelationToNamedPlace"})})
public class Locality
extends DisciplineMember
implements AttachmentOwnerIFace<LocalityAttachment>,
Serializable,
LocalityMapper.MapLocationIFace,
Cloneable {
    protected Integer localityId;
    protected String namedPlace;
    protected String shortName;
    protected String relationToNamedPlace;
    protected String localityName;
    protected String verbatimElevation;
    protected String originalElevationUnit;
    protected Double minElevation;
    protected Double maxElevation;
    protected String elevationMethod;
    protected Double elevationAccuracy;
    protected Integer originalLatLongUnit;
    protected String latLongType;
    protected BigDecimal latitude1;
    protected BigDecimal longitude1;
    protected BigDecimal latitude2;
    protected BigDecimal longitude2;
    protected String latLongMethod;
    protected Double latLongAccuracy;
    protected String gml;
    protected String datum;
    protected String remarks;
    protected String lat1text;
    protected String lat2text;
    protected String long1text;
    protected String long2text;
    protected Byte visibility;
    protected SpecifyUser visibilitySetBy;
    protected String guid;
    protected String text1;
    protected String text2;
    protected Byte sgrStatus;
    protected Byte srcLatLongUnit;
    protected Geography geography;
    protected Set<LocalityCitation> localityCitations;
    protected Set<LocalityAttachment> localityAttachments;
    protected Set<LocalityNameAlias> localityNameAliass;
    protected Set<LocalityDetail> localityDetails;
    protected Set<GeoCoordDetail> geoCoordDetails;
    protected Set<LatLonPolygon> latLonpolygons;

    public Locality() {
    }

    public Locality(Integer localityId) {
        this.localityId = localityId;
    }

    @Override
    public void initialize() {
        super.init();
        this.localityId = null;
        this.shortName = null;
        this.namedPlace = null;
        this.relationToNamedPlace = null;
        this.localityName = null;
        this.verbatimElevation = null;
        this.originalElevationUnit = null;
        this.minElevation = null;
        this.maxElevation = null;
        this.elevationMethod = null;
        this.elevationAccuracy = null;
        this.originalLatLongUnit = null;
        this.latLongType = null;
        this.latitude1 = null;
        this.longitude1 = null;
        this.latitude2 = null;
        this.longitude2 = null;
        this.latLongMethod = null;
        this.latLongAccuracy = null;
        this.datum = null;
        this.remarks = null;
        this.sgrStatus = null;
        this.lat1text = null;
        this.lat2text = null;
        this.long1text = null;
        this.long2text = null;
        this.visibility = null;
        this.guid = null;
        this.text1 = null;
        this.text2 = null;
        this.srcLatLongUnit = 0;
        this.geography = null;
        this.localityCitations = new HashSet<LocalityCitation>();
        this.localityNameAliass = new HashSet<LocalityNameAlias>();
        this.localityAttachments = new HashSet<LocalityAttachment>();
        this.localityDetails = new HashSet<LocalityDetail>();
        this.geoCoordDetails = new HashSet<GeoCoordDetail>();
        this.latLonpolygons = new HashSet<LatLonPolygon>();
    }

    @Id
    @GeneratedValue
    @Column(name="LocalityID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getLocalityId() {
        return this.localityId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.localityId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return Locality.class;
    }

    public void setLocalityId(Integer localityId) {
        this.localityId = localityId;
    }

    @Column(name="NamedPlace", unique=false, nullable=true, insertable=true, updatable=true)
    public String getNamedPlace() {
        return this.namedPlace;
    }

    public void setNamedPlace(String namedPlace) {
        this.namedPlace = namedPlace;
    }

    @Column(name="ShortName", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    @Column(name="RelationToNamedPlace", unique=false, nullable=true, insertable=true, updatable=true, length=120)
    public String getRelationToNamedPlace() {
        return this.relationToNamedPlace;
    }

    public void setRelationToNamedPlace(String relationToNamedPlace) {
        this.relationToNamedPlace = relationToNamedPlace;
    }

    @Column(name="SGRStatus", unique=false, nullable=true, insertable=true, updatable=true)
    public Byte getSgrStatus() {
        return this.sgrStatus;
    }

    public void setSgrStatus(Byte sgrStatus) {
        this.sgrStatus = sgrStatus;
    }

    @Column(name="LocalityName", unique=false, nullable=false, insertable=true, updatable=true)
    public String getLocalityName() {
        return this.localityName;
    }

    public void setLocalityName(String localityName) {
        this.localityName = localityName;
    }

    @Column(name="VerbatimElevation", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getVerbatimElevation() {
        return this.verbatimElevation;
    }

    public void setVerbatimElevation(String verbatimElevation) {
        this.verbatimElevation = verbatimElevation;
    }

    @Column(name="OriginalElevationUnit", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getOriginalElevationUnit() {
        return this.originalElevationUnit;
    }

    public void setOriginalElevationUnit(String originalElevationUnit) {
        this.originalElevationUnit = originalElevationUnit;
    }

    @Column(name="MinElevation", unique=false, nullable=true, insertable=true, updatable=true)
    public Double getMinElevation() {
        return this.minElevation;
    }

    public void setMinElevation(Double minElevation) {
        this.minElevation = minElevation;
    }

    @Column(name="MaxElevation", unique=false, nullable=true, insertable=true, updatable=true)
    public Double getMaxElevation() {
        return this.maxElevation;
    }

    public void setMaxElevation(Double maxElevation) {
        this.maxElevation = maxElevation;
    }

    @Column(name="ElevationMethod", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getElevationMethod() {
        return this.elevationMethod;
    }

    public void setElevationMethod(String elevationMethod) {
        this.elevationMethod = elevationMethod;
    }

    @Column(name="ElevationAccuracy", unique=false, nullable=true, insertable=true, updatable=true)
    public Double getElevationAccuracy() {
        return this.elevationAccuracy;
    }

    public void setElevationAccuracy(Double elevationAccuracy) {
        this.elevationAccuracy = elevationAccuracy;
    }

    @Column(name="OriginalLatLongUnit", unique=false, nullable=true, insertable=true, updatable=true)
    public Integer getOriginalLatLongUnit() {
        return this.originalLatLongUnit == null ? 0 : this.originalLatLongUnit;
    }

    @Transient
    public boolean isOriginalLatLongUnitEmpty() {
        return this.originalLatLongUnit == null;
    }

    public void setOriginalLatLongUnit(Integer originalLatLongUnit) {
        this.originalLatLongUnit = originalLatLongUnit;
    }

    @Column(name="LatLongType", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getLatLongType() {
        return this.latLongType;
    }

    public void setLatLongType(String latLongType) {
        this.latLongType = latLongType;
    }

    @Column(name="Latitude1", unique=false, nullable=true, insertable=true, updatable=true, precision=12, scale=10)
    public BigDecimal getLatitude1() {
        return this.latitude1;
    }

    public void setLatitude1(BigDecimal latitude1) {
        this.latitude1 = latitude1;
    }

    @Column(name="Longitude1", unique=false, nullable=true, insertable=true, updatable=true, precision=13, scale=10)
    public BigDecimal getLongitude1() {
        return this.longitude1;
    }

    public void setLongitude1(BigDecimal longitude1) {
        this.longitude1 = longitude1;
    }

    @Column(name="Latitude2", unique=false, nullable=true, insertable=true, updatable=true, precision=12, scale=10)
    public BigDecimal getLatitude2() {
        return this.latitude2;
    }

    public void setLatitude2(BigDecimal latitude2) {
        this.latitude2 = latitude2;
    }

    @Column(name="Longitude2", unique=false, nullable=true, insertable=true, updatable=true, precision=13, scale=10)
    public BigDecimal getLongitude2() {
        return this.longitude2;
    }

    public void setLongitude2(BigDecimal longitude2) {
        this.longitude2 = longitude2;
    }

    @Column(name="LatLongMethod", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getLatLongMethod() {
        return this.latLongMethod;
    }

    public void setLatLongMethod(String latLongMethod) {
        this.latLongMethod = latLongMethod;
    }

    @Column(name="LatLongAccuracy", unique=false, nullable=true, insertable=true, updatable=true)
    public Double getLatLongAccuracy() {
        return this.latLongAccuracy;
    }

    public void setLatLongAccuracy(Double latLongAccuracy) {
        this.latLongAccuracy = latLongAccuracy;
    }

    @Lob
    @Column(name="GML")
    public String getGml() {
        return this.gml;
    }

    public void setGml(String gml) {
        this.gml = gml;
    }

    @Column(name="Datum", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getDatum() {
        return this.datum;
    }

    public void setDatum(String datum) {
        this.datum = datum;
    }

    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Column(name="Lat1Text", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getLat1text() {
        return this.lat1text;
    }

    public void setLat1text(String lat1text) {
        this.lat1text = lat1text;
    }

    @Column(name="Lat2Text", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getLat2text() {
        return this.lat2text;
    }

    public void setLat2text(String lat2text) {
        this.lat2text = lat2text;
    }

    @Column(name="Long1Text", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getLong1text() {
        return this.long1text;
    }

    public void setLong1text(String long1text) {
        this.long1text = long1text;
    }

    @Column(name="Long2Text", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getLong2text() {
        return this.long2text;
    }

    public void setLong2text(String long2text) {
        this.long2text = long2text;
    }

    @Column(name="GUID", unique=false, nullable=true, insertable=true, updatable=true, length=128)
    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    @Column(name="SrcLatLongUnit", unique=false, nullable=false, insertable=true, updatable=true)
    public Byte getSrcLatLongUnit() {
        return this.srcLatLongUnit;
    }

    public void setSrcLatLongUnit(Byte srcLatLongUnit) {
        this.srcLatLongUnit = srcLatLongUnit;
    }

    @Column(name="Text1", unique=false, nullable=true, insertable=true, updatable=true, length=300)
    public String getText1() {
        return this.text1;
    }

    public void setText1(String text1) {
        this.text1 = text1;
    }

    @Column(name="Text2", unique=false, nullable=true, insertable=true, updatable=true, length=300)
    public String getText2() {
        return this.text2;
    }

    public void setText2(String text2) {
        this.text2 = text2;
    }

    @Column(name="Visibility", unique=false, nullable=true, insertable=true, updatable=true)
    public Byte getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Byte visibility) {
        this.visibility = visibility;
    }

    @Override
    @Transient
    public boolean isRestrictable() {
        return true;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="VisibilitySetByID", unique=false, nullable=true, insertable=true, updatable=true)
    public SpecifyUser getVisibilitySetBy() {
        return this.visibilitySetBy;
    }

    public void setVisibilitySetBy(SpecifyUser visibilitySetBy) {
        this.visibilitySetBy = visibilitySetBy;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="GeographyID", unique=false, nullable=true, insertable=true, updatable=true)
    public Geography getGeography() {
        return this.geography;
    }

    public void setGeography(Geography geography) {
        this.geography = geography;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="locality")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<LocalityCitation> getLocalityCitations() {
        return this.localityCitations;
    }

    public void setLocalityCitations(Set<LocalityCitation> localityCitations) {
        this.localityCitations = localityCitations;
    }

    @OneToMany(mappedBy="locality")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @OrderBy(value="ordinal ASC")
    public Set<LocalityAttachment> getLocalityAttachments() {
        return this.localityAttachments;
    }

    public void setLocalityAttachments(Set<LocalityAttachment> localityAttachments) {
        this.localityAttachments = localityAttachments;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="locality")
    public Set<LocalityNameAlias> getLocalityNameAliass() {
        return this.localityNameAliass;
    }

    public void setLocalityNameAliass(Set<LocalityNameAlias> localityNameAliass) {
        this.localityNameAliass = localityNameAliass;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return Discipline.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.discipline != null ? this.discipline.getId() : null;
    }

    @Transient
    public List<CollectingEvent> getCollectingEvents() {
        return this.getCollectingEvents(true);
    }

    @Transient
    public List<CollectingEvent> getCollectingEvents(boolean doLoadColObjs) {
        if (this.getId() != null) {
            DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
            try {
                if (session != null) {
                    List<CollectingEvent> ces = session.getDataList("FROM CollectingEvent WHERE localityId = " + this.getId());
                    ces.size();
                    if (doLoadColObjs) {
                        for (CollectingEvent ce : ces) {
                            ce.getCollectionObjects().size();
                        }
                    }
                    List<CollectingEvent> list = ces;
                    return list;
                }
            }
            finally {
                session.close();
            }
        }
        return null;
    }

    @Override
    public void forceLoad() {
        if (this.localityDetails != null) {
            this.localityDetails.size();
        }
        if (this.geoCoordDetails != null) {
            this.geoCoordDetails.size();
        }
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="locality")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<LocalityDetail> getLocalityDetails() {
        return this.localityDetails;
    }

    public void setLocalityDetails(Set<LocalityDetail> localityDetails) {
        this.localityDetails = localityDetails;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="locality")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<GeoCoordDetail> getGeoCoordDetails() {
        return this.geoCoordDetails;
    }

    public void setGeoCoordDetails(Set<GeoCoordDetail> geoCoordDetails) {
        this.geoCoordDetails = geoCoordDetails;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="locality")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<LatLonPolygon> getLatLonpolygons() {
        return this.latLonpolygons;
    }

    public void setLatLonpolygons(Set<LatLonPolygon> latLonpolygons) {
        this.latLonpolygons = latLonpolygons;
    }

    @Override
    @Transient
    public int getTableId() {
        return Locality.getClassTableId();
    }

    public static int getClassTableId() {
        return 2;
    }

    private Locality doClone(Locality newLocality) throws CloneNotSupportedException {
        newLocality.localityDetails = new HashSet<LocalityDetail>();
        for (LocalityDetail localityDetail : this.localityDetails) {
            LocalityDetail ld = (LocalityDetail)localityDetail.clone();
            newLocality.localityDetails.add(ld);
            ld.setLocality(newLocality);
        }
        newLocality.geoCoordDetails = new HashSet<GeoCoordDetail>();
        for (GeoCoordDetail geoCoordDetail : this.geoCoordDetails) {
            GeoCoordDetail gcd = (GeoCoordDetail)geoCoordDetail.clone();
            newLocality.geoCoordDetails.add(gcd);
            gcd.setLocality(newLocality);
        }
        newLocality.localityCitations = new HashSet<LocalityCitation>();
        for (LocalityCitation localityCitation : this.localityCitations) {
            LocalityCitation lc = (LocalityCitation)localityCitation.clone();
            newLocality.localityCitations.add(lc);
            lc.setLocality(newLocality);
        }
        newLocality.localityNameAliass = new HashSet<LocalityNameAlias>();
        for (LocalityNameAlias localityNameAlias : this.localityNameAliass) {
            LocalityNameAlias lna = (LocalityNameAlias)localityNameAlias.clone();
            newLocality.localityNameAliass.add(lna);
            lna.setLocality(newLocality);
        }
        newLocality.localityAttachments = new HashSet<LocalityAttachment>();
        newLocality.latLonpolygons = new HashSet<LatLonPolygon>();
        for (LatLonPolygon latLonPolygon : this.latLonpolygons) {
            LatLonPolygon llp = (LatLonPolygon)latLonPolygon.clone();
            newLocality.latLonpolygons.add(llp);
            llp.setLocality(newLocality);
        }
        return newLocality;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Locality l = (Locality)super.clone();
        l.localityId = null;
        try {
            try {
                l = this.doClone(l);
            }
            catch (LazyInitializationException hex) {
                DataProviderSessionIFace session = null;
                try {
                    try {
                        session = DataProviderFactory.getInstance().createSession();
                        session.attach(this);
                        l = this.doClone(l);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(ValComboBoxFromQuery.class, ex);
                        if (session != null) {
                            session.close();
                        }
                    }
                }
                finally {
                    if (session != null) {
                        session.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ValComboBoxFromQuery.class, ex);
        }
        return l;
    }

    @Override
    @Transient
    public Double getLat1() {
        return this.latitude1 != null ? Double.valueOf(this.latitude1.doubleValue()) : null;
    }

    @Override
    @Transient
    public Double getLat2() {
        return this.latitude2 != null ? Double.valueOf(this.latitude2.doubleValue()) : null;
    }

    @Override
    @Transient
    public Double getLong1() {
        return this.longitude1 != null ? Double.valueOf(this.longitude1.doubleValue()) : null;
    }

    @Override
    @Transient
    public Double getLong2() {
        return this.longitude2 != null ? Double.valueOf(this.longitude2.doubleValue()) : null;
    }

    @Override
    @Transient
    public Set<LocalityAttachment> getAttachmentReferences() {
        return this.localityAttachments;
    }

    @Transient
    private GeoCoordDetail getGeoCoordDetail() {
        return this.geoCoordDetails == null || this.geoCoordDetails.size() == 0 ? null : this.geoCoordDetails.iterator().next();
    }

    @Transient
    public String getErrorPolygon() {
        GeoCoordDetail gcd = this.getGeoCoordDetail();
        if (gcd != null) {
            return gcd.getErrorPolygon();
        }
        return null;
    }

    @Transient
    public BigDecimal getErrorEstimate() {
        GeoCoordDetail gcd = this.getGeoCoordDetail();
        if (gcd != null) {
            return gcd.getMaxUncertaintyEst();
        }
        return null;
    }

    private GeoCoordDetail createGeoCoordDetail() {
        GeoCoordDetail gcd = new GeoCoordDetail();
        gcd.initialize();
        gcd.setLocality(this);
        if (this.geoCoordDetails == null) {
            this.geoCoordDetails = new HashSet<GeoCoordDetail>();
        }
        this.geoCoordDetails.add(gcd);
        return gcd;
    }

    public void setErrorPolygon(String errorPolygon) {
        GeoCoordDetail gcd = this.getGeoCoordDetail();
        if (gcd == null) {
            gcd = this.createGeoCoordDetail();
        }
        gcd.setErrorPolygon(errorPolygon);
    }

    public void setErrorEstimate(BigDecimal errEst) {
        GeoCoordDetail gcd = this.getGeoCoordDetail();
        if (gcd == null) {
            gcd = this.createGeoCoordDetail();
        }
        gcd.setMaxUncertaintyEst(errEst);
    }

    @Transient
    public static List<PickListDBAdapterIFace> getSpSystemTypeCodes() {
        Vector<PickListDBAdapterIFace> result = new Vector<PickListDBAdapterIFace>(1);
        Vector<PickListItemIFace> lltypes = new Vector<PickListItemIFace>(3);
        lltypes.add(new TypeCodeItem(UIRegistry.getResourceString("Locality.LL_TYPE_POINT"), "Point"));
        lltypes.add(new TypeCodeItem(UIRegistry.getResourceString("Locality.LL_TYPE_LINE"), "Line"));
        lltypes.add(new TypeCodeItem(UIRegistry.getResourceString("Locality.LL_TYPE_RECTANGLE"), "Rectangle"));
        result.add(new TypeCode(lltypes, "latLongType"));
        return result;
    }

    @Transient
    public static String[] getSpSystemTypeCodeFlds() {
        String[] result = new String[]{"latLongType"};
        return result;
    }
}

