/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.DisciplineMember;
import edu.ku.brc.specify.datamodel.Loan;
import edu.ku.brc.specify.datamodel.LoanReturnPreparation;
import edu.ku.brc.specify.datamodel.Preparation;
import edu.ku.brc.specify.datamodel.PreparationHolderIFace;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="loanpreparation")
@Table(appliesTo="loanpreparation", indexes={@Index(name="LoanPrepDspMemIDX", columnNames={"DisciplineID"})})
public class LoanPreparation
extends DisciplineMember
implements Serializable,
PreparationHolderIFace,
Comparable<LoanPreparation> {
    protected Integer loanPreparationId;
    protected Integer quantity;
    protected String descriptionOfMaterial;
    protected String outComments;
    protected String inComments;
    protected String receivedComments;
    protected Integer quantityResolved;
    protected Integer quantityReturned;
    protected Boolean isResolved;
    protected Preparation preparation;
    protected Loan loan;
    protected Set<LoanReturnPreparation> loanReturnPreparations;

    public LoanPreparation() {
    }

    public LoanPreparation(Integer loanPreparationId) {
        this.loanPreparationId = loanPreparationId;
    }

    @Override
    public void initialize() {
        super.init();
        this.loanPreparationId = null;
        this.quantity = null;
        this.descriptionOfMaterial = null;
        this.outComments = null;
        this.inComments = null;
        this.receivedComments = null;
        this.quantityResolved = null;
        this.quantityReturned = null;
        this.isResolved = false;
        this.preparation = null;
        this.loan = null;
        this.loanReturnPreparations = new HashSet<LoanReturnPreparation>();
    }

    @Override
    public void forceLoad() {
        super.forceLoad();
        for (LoanReturnPreparation lrp : this.getLoanReturnPreparations()) {
            lrp.forceLoad();
        }
    }

    @Id
    @GeneratedValue
    @Column(name="LoanPreparationID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getLoanPreparationId() {
        return this.loanPreparationId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.loanPreparationId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return LoanPreparation.class;
    }

    public void setLoanPreparationId(Integer loanPreparationId) {
        this.loanPreparationId = loanPreparationId;
    }

    @Override
    @Column(name="Quantity", unique=false, nullable=true, insertable=true, updatable=true)
    public Integer getQuantity() {
        return this.quantity == null ? 0 : this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    @Column(name="DescriptionOfMaterial", unique=false, nullable=true, insertable=true, updatable=true)
    public String getDescriptionOfMaterial() {
        return this.descriptionOfMaterial;
    }

    public void setDescriptionOfMaterial(String descriptionOfMaterial) {
        this.descriptionOfMaterial = descriptionOfMaterial;
    }

    @Lob
    @Column(name="OutComments", unique=false, nullable=true, insertable=true, updatable=true, length=1024)
    public String getOutComments() {
        return this.outComments;
    }

    public void setOutComments(String outComments) {
        this.outComments = outComments;
    }

    @Lob
    @Column(name="InComments", unique=false, nullable=true, insertable=true, updatable=true, length=1024)
    public String getInComments() {
        return this.inComments;
    }

    public void setInComments(String inComments) {
        this.inComments = inComments;
    }

    @Lob
    @Column(name="ReceivedComments", unique=false, nullable=true, insertable=true, updatable=true, length=1024)
    public String getReceivedComments() {
        return this.receivedComments;
    }

    public void setReceivedComments(String receivedComments) {
        this.receivedComments = receivedComments;
    }

    @Column(name="QuantityResolved", unique=false, nullable=true, insertable=true, updatable=true)
    public Integer getQuantityResolved() {
        return this.quantityResolved == null ? 0 : this.quantityResolved;
    }

    public void setQuantityResolved(Integer quantityResolved) {
        this.quantityResolved = quantityResolved;
    }

    @Override
    @Column(name="QuantityReturned", unique=false, nullable=true, insertable=true, updatable=true)
    public Integer getQuantityReturned() {
        return this.quantityReturned == null ? 0 : this.quantityReturned;
    }

    public void setQuantityReturned(Integer quantityReturned) {
        this.quantityReturned = quantityReturned;
    }

    @Column(name="IsResolved", unique=false, nullable=false, insertable=true, updatable=true)
    public Boolean getIsResolved() {
        return this.isResolved == null ? false : this.isResolved;
    }

    public void setIsResolved(Boolean isResolved) {
        this.isResolved = isResolved;
    }

    @Override
    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="PreparationID", unique=false, nullable=true, insertable=true, updatable=true)
    public Preparation getPreparation() {
        return this.preparation;
    }

    public void setPreparation(Preparation preparation) {
        this.preparation = preparation;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="LoanID", unique=false, nullable=false, insertable=true, updatable=true)
    public Loan getLoan() {
        return this.loan;
    }

    public void setLoan(Loan loan) {
        this.loan = loan;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="loanPreparation")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<LoanReturnPreparation> getLoanReturnPreparations() {
        return this.loanReturnPreparations;
    }

    public void setLoanReturnPreparations(Set<LoanReturnPreparation> loanReturnPreparations) {
        this.loanReturnPreparations = loanReturnPreparations;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return Loan.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.loan != null ? this.loan.getId() : null;
    }

    @Override
    @Transient
    public int getTableId() {
        return LoanPreparation.getClassTableId();
    }

    public static int getClassTableId() {
        return 54;
    }

    @Override
    public int compareTo(LoanPreparation obj) {
        if (this.preparation != null && obj.getPreparation() != null) {
            CollectionObject co1 = this.preparation.getCollectionObject();
            CollectionObject co2 = obj.getPreparation().getCollectionObject();
            if (co1 != null && co2 != null && co1.getCatalogNumber() != null && co2.getCatalogNumber() != null) {
                return co1.getCatalogNumber().compareTo(co2.getCatalogNumber());
            }
        }
        return this.timestampCreated != null && obj != null && obj.timestampCreated != null ? this.timestampCreated.compareTo(obj.timestampCreated) : 0;
    }
}

