/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.Attachment;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.Loan;
import edu.ku.brc.specify.datamodel.ObjectAttachmentIFace;
import edu.ku.brc.util.Orderable;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Proxy;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@Table(name="loanattachment")
public class LoanAttachment
extends DataModelObjBase
implements ObjectAttachmentIFace<Loan>,
Orderable,
Serializable,
Comparable<LoanAttachment> {
    protected Integer loanAttachmentId;
    protected Loan loan;
    protected Attachment attachment;
    protected Integer ordinal;
    protected String remarks;

    public LoanAttachment() {
    }

    public LoanAttachment(Integer id) {
        this.loanAttachmentId = id;
    }

    @Override
    public void initialize() {
        super.init();
        this.loanAttachmentId = null;
        this.loan = null;
        this.attachment = new Attachment();
        this.attachment.initialize();
        this.ordinal = null;
    }

    @Override
    public void forceLoad() {
        this.attachment.getId();
        this.loan.getId();
    }

    @Id
    @GeneratedValue
    @Column(name="LoanAttachmentID")
    public Integer getLoanAttachmentId() {
        return this.loanAttachmentId;
    }

    public void setLoanAttachmentId(Integer loanAttachmentId) {
        this.loanAttachmentId = loanAttachmentId;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="LoanID", nullable=false)
    public Loan getLoan() {
        return this.loan;
    }

    public void setLoan(Loan loan) {
        this.loan = loan;
    }

    @Override
    @ManyToOne(cascade={}, fetch=FetchType.EAGER)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="AttachmentID", nullable=false)
    @OrderBy(value="ordinal ASC")
    public Attachment getAttachment() {
        return this.attachment;
    }

    @Override
    public void setAttachment(Attachment attachment) {
        this.attachment = attachment;
    }

    @Override
    @Column(name="Ordinal")
    public Integer getOrdinal() {
        return this.ordinal;
    }

    @Override
    public void setOrdinal(Integer ordinal) {
        this.ordinal = ordinal;
    }

    @Override
    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    @Override
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Override
    @Transient
    public int getOrderIndex() {
        return this.ordinal != null ? this.ordinal : 0;
    }

    @Override
    public void setOrderIndex(int ordinal) {
        this.ordinal = ordinal;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return LoanAttachment.class;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.loanAttachmentId;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return Loan.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.loan != null ? this.loan.getId() : null;
    }

    @Override
    @Transient
    public int getTableId() {
        return LoanAttachment.getClassTableId();
    }

    public static int getClassTableId() {
        return 114;
    }

    @Override
    @Transient
    public Loan getObject() {
        return this.getLoan();
    }

    @Override
    public void setObject(Loan object) {
        this.setLoan(object);
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        return Attachment.getIdentityTitle(this);
    }

    @Override
    public String toString() {
        String aString = this.attachment != null ? this.attachment.getIdentityTitle() : "NULL Attachment";
        String oString = this.getObject() != null ? this.getObject().getIdentityTitle() : "NULL Object Reference";
        return String.valueOf(aString) + " : " + oString;
    }

    @Override
    public int compareTo(LoanAttachment obj) {
        if (this.ordinal != null && obj != null && obj.ordinal != null) {
            return this.ordinal.compareTo(obj.ordinal);
        }
        return 0;
    }
}

