/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.DisciplineMember;
import edu.ku.brc.specify.datamodel.Loan;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="loanagent", uniqueConstraints={@UniqueConstraint(columnNames={"Role", "LoanID", "AgentID"})})
@Table(appliesTo="loanagent", indexes={@Index(name="LoanAgDspMemIDX", columnNames={"DisciplineID"})})
public class LoanAgent
extends DisciplineMember
implements Serializable {
    protected Integer loanAgentId;
    protected String role;
    protected String remarks;
    protected Loan loan;
    protected Agent agent;

    public LoanAgent() {
    }

    public LoanAgent(Integer loanAgentId) {
        this.loanAgentId = loanAgentId;
    }

    @Override
    public void initialize() {
        super.init();
        this.loanAgentId = null;
        this.role = null;
        this.remarks = null;
        this.loan = null;
        this.agent = null;
    }

    @Override
    public void forceLoad() {
        this.agent.getId();
        this.loan.getId();
    }

    @Id
    @GeneratedValue
    @Column(name="LoanAgentID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getLoanAgentId() {
        return this.loanAgentId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.loanAgentId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return LoanAgent.class;
    }

    public void setLoanAgentId(Integer loanAgentId) {
        this.loanAgentId = loanAgentId;
    }

    @Column(name="Role", unique=false, nullable=false, insertable=true, updatable=true, length=50)
    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="LoanID", unique=false, nullable=false, insertable=true, updatable=true)
    public Loan getLoan() {
        return this.loan;
    }

    public void setLoan(Loan loan) {
        this.loan = loan;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="AgentID", unique=false, nullable=false, insertable=true, updatable=true)
    public Agent getAgent() {
        return this.agent;
    }

    public void setAgent(Agent agent) {
        this.agent = agent;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return Loan.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.loan != null ? this.loan.getId() : null;
    }

    @Override
    @Transient
    public int getTableId() {
        return LoanAgent.getClassTableId();
    }

    public static int getClassTableId() {
        return 53;
    }
}

