/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.AddressOfRecord;
import edu.ku.brc.specify.datamodel.AttachmentOwnerIFace;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.DisciplineMember;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.datamodel.LoanAgent;
import edu.ku.brc.specify.datamodel.LoanAttachment;
import edu.ku.brc.specify.datamodel.LoanPreparation;
import edu.ku.brc.specify.datamodel.PreparationHolderIFace;
import edu.ku.brc.specify.datamodel.PreparationsProviderIFace;
import edu.ku.brc.specify.datamodel.Shipment;
import java.io.Serializable;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="loan")
@Table(appliesTo="loan", indexes={@Index(name="LoanNumberIDX", columnNames={"LoanNumber"}), @Index(name="LoanDateIDX", columnNames={"LoanDate"}), @Index(name="CurrentDueDateIDX", columnNames={"CurrentDueDate"})})
public class Loan
extends DisciplineMember
implements AttachmentOwnerIFace<LoanAttachment>,
PreparationsProviderIFace,
Serializable {
    public static final Boolean CLOSED = true;
    public static final Boolean OPEN = false;
    protected Integer loanId;
    protected String loanNumber;
    protected Calendar loanDate;
    protected Calendar currentDueDate;
    protected Calendar originalDueDate;
    protected Calendar dateClosed;
    protected String receivedComments;
    protected String specialConditions;
    protected Boolean isFinancialResponsibility;
    protected String purposeOfLoan;
    protected Calendar overdueNotiSentDate;
    protected Calendar dateReceived;
    protected String srcGeography;
    protected String srcTaxonomy;
    protected String remarks;
    protected String text1;
    protected String text2;
    protected Float number1;
    protected Float number2;
    protected Boolean isClosed;
    protected Boolean yesNo1;
    protected Boolean yesNo2;
    protected AddressOfRecord addressOfRecord;
    protected Set<LoanAgent> loanAgents;
    protected Set<LoanPreparation> loanPreparations;
    protected Set<Shipment> shipments;
    protected Set<LoanAttachment> loanAttachments;
    protected Division division;

    public Loan() {
    }

    public Loan(Integer loanId) {
        this.loanId = loanId;
    }

    @Override
    public void initialize() {
        super.init();
        this.loanId = null;
        this.loanNumber = null;
        this.loanDate = null;
        this.currentDueDate = null;
        this.originalDueDate = null;
        this.dateClosed = null;
        this.receivedComments = null;
        this.specialConditions = null;
        this.isFinancialResponsibility = null;
        this.purposeOfLoan = null;
        this.overdueNotiSentDate = null;
        this.dateReceived = null;
        this.srcGeography = null;
        this.srcTaxonomy = null;
        this.remarks = null;
        this.text1 = null;
        this.text2 = null;
        this.number1 = null;
        this.number2 = null;
        this.isClosed = OPEN;
        this.yesNo1 = null;
        this.yesNo2 = null;
        this.loanAgents = new HashSet<LoanAgent>();
        this.loanPreparations = new HashSet<LoanPreparation>();
        this.shipments = new HashSet<Shipment>();
        this.loanAttachments = new HashSet<LoanAttachment>();
        this.division = null;
        this.addressOfRecord = null;
    }

    @Override
    public void forceLoad() {
        super.forceLoad();
        for (LoanPreparation lp : this.loanPreparations) {
            lp.forceLoad();
        }
        for (Shipment shipment : this.shipments) {
            shipment.forceLoad();
        }
        for (LoanAgent loanAgent : this.loanAgents) {
            loanAgent.forceLoad();
        }
        for (LoanAttachment loanAtt : this.loanAttachments) {
            loanAtt.forceLoad();
        }
    }

    @Id
    @GeneratedValue
    @Column(name="LoanID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getLoanId() {
        return this.loanId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.loanId;
    }

    public void setLoanId(Integer loanId) {
        this.loanId = loanId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return Loan.class;
    }

    @Column(name="LoanNumber", unique=false, nullable=false, insertable=true, updatable=true, length=50)
    public String getLoanNumber() {
        return this.loanNumber;
    }

    public void setLoanNumber(String loanNumber) {
        this.loanNumber = loanNumber;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="LoanDate", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getLoanDate() {
        return this.loanDate;
    }

    public void setLoanDate(Calendar loanDate) {
        this.loanDate = loanDate;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="CurrentDueDate", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getCurrentDueDate() {
        return this.currentDueDate;
    }

    public void setCurrentDueDate(Calendar currentDueDate) {
        this.currentDueDate = currentDueDate;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="OriginalDueDate", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getOriginalDueDate() {
        return this.originalDueDate;
    }

    public void setOriginalDueDate(Calendar originalDueDate) {
        this.originalDueDate = originalDueDate;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DateClosed", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getDateClosed() {
        return this.dateClosed;
    }

    public void setDateClosed(Calendar dateClosed) {
        this.dateClosed = dateClosed;
    }

    @Column(name="SrcGeography", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getSrcGeography() {
        return this.srcGeography;
    }

    public void setSrcGeography(String srcGeography) {
        this.srcGeography = srcGeography;
    }

    @Column(name="SrcTaxonomy", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getSrcTaxonomy() {
        return this.srcTaxonomy;
    }

    public void setSrcTaxonomy(String srcTaxonomy) {
        this.srcTaxonomy = srcTaxonomy;
    }

    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Column(name="Text1", length=300, unique=false, nullable=true, insertable=true, updatable=true)
    public String getText1() {
        return this.text1;
    }

    public void setText1(String text1) {
        this.text1 = text1;
    }

    @Column(name="Text2", length=300, unique=false, nullable=true, insertable=true, updatable=true)
    public String getText2() {
        return this.text2;
    }

    public void setText2(String text2) {
        this.text2 = text2;
    }

    @Column(name="Number1", unique=false, nullable=true, insertable=true, updatable=true, length=24)
    public Float getNumber1() {
        return this.number1;
    }

    public void setNumber1(Float number1) {
        this.number1 = number1;
    }

    @Column(name="Number2", unique=false, nullable=true, insertable=true, updatable=true, length=24)
    public Float getNumber2() {
        return this.number2;
    }

    public void setNumber2(Float number2) {
        this.number2 = number2;
    }

    @Column(name="IsClosed", unique=false, nullable=true, updatable=true, insertable=true)
    public Boolean getIsClosed() {
        return this.isClosed != null ? this.isClosed : false;
    }

    public void setIsClosed(Boolean isClosed) {
        this.isClosed = isClosed;
    }

    @Column(name="YesNo1", unique=false, nullable=true, updatable=true, insertable=true)
    public Boolean getYesNo1() {
        return this.yesNo1;
    }

    public void setYesNo1(Boolean yesNo1) {
        this.yesNo1 = yesNo1;
    }

    @Column(name="YesNo2", unique=false, nullable=true, updatable=true, insertable=true)
    public Boolean getYesNo2() {
        return this.yesNo2;
    }

    public void setYesNo2(Boolean yesNo2) {
        this.yesNo2 = yesNo2;
    }

    @Column(name="ReceivedComments", unique=false, nullable=true, insertable=true, updatable=true, length=255)
    public String getReceivedComments() {
        return this.receivedComments;
    }

    public void setReceivedComments(String receivedComments) {
        this.receivedComments = receivedComments;
    }

    @Lob
    @Column(name="SpecialConditions", unique=false, nullable=true, insertable=true, updatable=true, length=2048)
    public String getSpecialConditions() {
        return this.specialConditions;
    }

    public void setSpecialConditions(String specialConditions) {
        this.specialConditions = specialConditions;
    }

    @Column(name="IsFinancialResponsibility", unique=false, nullable=true, insertable=true, updatable=true)
    public Boolean getIsFinancialResponsibility() {
        return this.isFinancialResponsibility;
    }

    public void setIsFinancialResponsibility(Boolean isFinancialResponsibility) {
        this.isFinancialResponsibility = isFinancialResponsibility;
    }

    @Column(name="PurposeOfLoan", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getPurposeOfLoan() {
        return this.purposeOfLoan;
    }

    public void setPurposeOfLoan(String purposeOfLoan) {
        this.purposeOfLoan = purposeOfLoan;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="OverdueNotiSetDate", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getOverdueNotiSentDate() {
        return this.overdueNotiSentDate;
    }

    public void setOverdueNotiSentDate(Calendar overdueNotiSentDate) {
        this.overdueNotiSentDate = overdueNotiSentDate;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DateReceived", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getDateReceived() {
        return this.dateReceived;
    }

    public void setDateReceived(Calendar dateReceived) {
        this.dateReceived = dateReceived;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="DivisionID", unique=false, nullable=true, insertable=true, updatable=true)
    public Division getDivision() {
        return this.division;
    }

    public void setDivision(Division division) {
        this.division = division;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="AddressOfRecordID", unique=false, nullable=true, insertable=true, updatable=true)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public AddressOfRecord getAddressOfRecord() {
        return this.addressOfRecord;
    }

    public void setAddressOfRecord(AddressOfRecord addressOfRecord) {
        this.addressOfRecord = addressOfRecord;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="loan")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<LoanAgent> getLoanAgents() {
        return this.loanAgents;
    }

    public void setLoanAgents(Set<LoanAgent> loanAgents) {
        this.loanAgents = loanAgents;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="loan")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<LoanPreparation> getLoanPreparations() {
        return this.loanPreparations;
    }

    public void setLoanPreparations(Set<LoanPreparation> loanPreparations) {
        this.loanPreparations = loanPreparations;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="loan")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<Shipment> getShipments() {
        return this.shipments;
    }

    public void setShipments(Set<Shipment> shipments) {
        this.shipments = shipments;
    }

    @OneToMany(mappedBy="loan")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    @OrderBy(value="ordinal ASC")
    public Set<LoanAttachment> getLoanAttachments() {
        return this.loanAttachments;
    }

    public void setLoanAttachments(Set<LoanAttachment> loanAttachments) {
        this.loanAttachments = loanAttachments;
    }

    @Override
    @Transient
    public Set<PreparationHolderIFace> getPreparations() {
        HashSet<PreparationHolderIFace> set = new HashSet<PreparationHolderIFace>();
        for (LoanPreparation gp : this.loanPreparations) {
            set.add(gp);
        }
        return set;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return Discipline.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.discipline != null ? this.discipline.getId() : null;
    }

    @Override
    @Transient
    public int getTableId() {
        return Loan.getClassTableId();
    }

    public static int getClassTableId() {
        return 52;
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        return this.loanNumber != null ? this.loanNumber : super.getIdentityTitle();
    }

    @Override
    @Transient
    public Set<LoanAttachment> getAttachmentReferences() {
        return this.loanAttachments;
    }
}

