/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.LithoStrat;
import edu.ku.brc.specify.datamodel.LithoStratTreeDef;
import edu.ku.brc.specify.datamodel.TreeDefItemIface;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Proxy;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@Table(name="lithostrattreedefitem")
public class LithoStratTreeDefItem
extends DataModelObjBase
implements Serializable,
TreeDefItemIface<LithoStrat, LithoStratTreeDef, LithoStratTreeDefItem> {
    protected Integer lithoStratTreeDefItemId;
    protected String name;
    protected String title;
    protected String remarks;
    protected Integer rankId;
    protected Boolean isEnforced;
    protected Boolean isInFullName;
    protected String textBefore;
    protected String textAfter;
    protected String fullNameSeparator;
    protected LithoStratTreeDef treeDef;
    protected LithoStratTreeDefItem parent;
    protected Set<LithoStrat> treeEntries;
    protected Set<LithoStratTreeDefItem> children;

    public LithoStratTreeDefItem() {
    }

    public LithoStratTreeDefItem(Integer lithoStratTreeDefItemId) {
        this.lithoStratTreeDefItemId = lithoStratTreeDefItemId;
    }

    @Override
    public void initialize() {
        super.init();
        this.lithoStratTreeDefItemId = null;
        this.name = null;
        this.title = null;
        this.remarks = null;
        this.rankId = null;
        this.isEnforced = null;
        this.isInFullName = null;
        this.textBefore = null;
        this.textAfter = null;
        this.fullNameSeparator = ", ";
        this.treeDef = null;
        this.treeEntries = new HashSet<LithoStrat>();
        this.parent = null;
        this.children = new HashSet<LithoStratTreeDefItem>();
    }

    @Id
    @GeneratedValue
    @Column(name="LithoStratTreeDefItemID", unique=false, nullable=false, insertable=true, updatable=true, length=10)
    public Integer getLithoStratTreeDefItemId() {
        return this.lithoStratTreeDefItemId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.lithoStratTreeDefItemId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return LithoStratTreeDefItem.class;
    }

    public void setLithoStratTreeDefItemId(Integer lithoStratTreeDefItemId) {
        this.lithoStratTreeDefItemId = lithoStratTreeDefItemId;
    }

    @Override
    @Column(name="Name", nullable=false, length=64)
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Column(name="Title", nullable=true, length=64)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    @Transient
    public String getDisplayText() {
        return this.title != null ? this.title : this.name;
    }

    @Override
    public void setDisplayText(String text) {
        this.setTitle(text);
    }

    @Override
    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    @Override
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Override
    @Column(name="RankID", nullable=false)
    public Integer getRankId() {
        return this.rankId;
    }

    @Override
    public void setRankId(Integer rankId) {
        this.rankId = rankId;
    }

    @Override
    @Column(name="IsEnforced", unique=false, nullable=true, insertable=true, updatable=true)
    public Boolean getIsEnforced() {
        return this.isEnforced;
    }

    @Override
    public void setIsEnforced(Boolean isEnforced) {
        this.isEnforced = isEnforced;
    }

    @Override
    @Column(name="IsInFullName", unique=false, nullable=true, insertable=true, updatable=true)
    public Boolean getIsInFullName() {
        return this.isInFullName;
    }

    @Override
    public void setIsInFullName(Boolean isInFullName) {
        this.isInFullName = isInFullName;
    }

    @Override
    @Column(name="TextAfter", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getTextAfter() {
        return this.textAfter;
    }

    @Override
    public void setTextAfter(String textAfter) {
        this.textAfter = textAfter;
    }

    @Override
    @Column(name="TextBefore", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getTextBefore() {
        return this.textBefore;
    }

    @Override
    public void setTextBefore(String textBefore) {
        this.textBefore = textBefore;
    }

    @Override
    @Column(name="FullNameSeparator", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getFullNameSeparator() {
        return this.fullNameSeparator;
    }

    @Override
    public void setFullNameSeparator(String fullNameSeparator) {
        this.fullNameSeparator = fullNameSeparator;
    }

    @Override
    @ManyToOne(cascade={}, fetch=FetchType.EAGER)
    @JoinColumn(name="LithoStratTreeDefID", unique=false, nullable=false, insertable=true, updatable=true)
    public LithoStratTreeDef getTreeDef() {
        return this.treeDef;
    }

    @Override
    public void setTreeDef(LithoStratTreeDef treeDef) {
        this.treeDef = treeDef;
    }

    @Override
    @ManyToOne(cascade={}, fetch=FetchType.EAGER)
    @JoinColumn(name="ParentItemID", unique=false, nullable=true, insertable=true, updatable=true)
    public LithoStratTreeDefItem getParent() {
        return this.parent;
    }

    @Override
    public void setParent(LithoStratTreeDefItem parent) {
        this.parent = parent;
    }

    @Override
    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="definitionItem")
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE})
    public Set<LithoStrat> getTreeEntries() {
        return this.treeEntries;
    }

    @Override
    public void setTreeEntries(Set<LithoStrat> treeEntries) {
        this.treeEntries = treeEntries;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, mappedBy="parent")
    public Set<LithoStratTreeDefItem> getChildren() {
        return this.children;
    }

    public void setChildren(Set<LithoStratTreeDefItem> children) {
        this.children = children;
    }

    @Override
    @Transient
    public Integer getTreeDefItemId() {
        return this.getLithoStratTreeDefItemId();
    }

    @Override
    public void setTreeDefItemId(Integer id) {
        this.setLithoStratTreeDefItemId(id);
    }

    @Override
    public void setChild(LithoStratTreeDefItem child) {
        if (!this.children.isEmpty()) {
            LithoStratTreeDefItem currentChild = this.children.iterator().next();
            currentChild.setParent((LithoStratTreeDefItem)null);
        }
        this.children.clear();
        if (child != null) {
            this.children.add(child);
        }
    }

    @Override
    @Transient
    public LithoStratTreeDefItem getChild() {
        if (this.children.isEmpty()) {
            return null;
        }
        return this.children.iterator().next();
    }

    public void addTreeEntry(LithoStrat entry) {
        this.treeEntries.add(entry);
        entry.setDefinitionItem(this);
    }

    public void removeTreeEntry(LithoStrat entry) {
        this.treeEntries.remove(entry);
        entry.setDefinitionItem((LithoStratTreeDefItem)null);
    }

    public void removeChild(LithoStratTreeDefItem child) {
        this.children.remove(child);
        child.setParent((LithoStratTreeDefItem)null);
    }

    @Override
    public boolean canBeDeleted() {
        return this.treeEntries.isEmpty();
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return LithoStratTreeDef.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.parent != null ? this.parent.getId() : null;
    }

    @Override
    @Transient
    public int getTableId() {
        return LithoStratTreeDefItem.getClassTableId();
    }

    public static int getClassTableId() {
        return 48;
    }

    @Override
    public boolean hasTreeEntries() {
        if (this.getId() == null) {
            return false;
        }
        String sql = "select distinct LithoStratTreeDefItemID from lithostrat where LithoStratTreeDefItemID = " + this.getId();
        return BasicSQLUtils.getNumRecords(sql) > 0;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LithoStratTreeDefItem) {
            LithoStratTreeDefItem item = (LithoStratTreeDefItem)obj;
            if (item.lithoStratTreeDefItemId != null) {
                return item.lithoStratTreeDefItemId.equals(this.lithoStratTreeDefItemId);
            }
            return super.equals(obj);
        }
        return false;
    }
}

