/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.BaseTreeDef;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.LithoStrat;
import edu.ku.brc.specify.datamodel.LithoStratTreeDefItem;
import edu.ku.brc.specify.datamodel.TreeDefItemStandardEntry;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Proxy;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@Table(name="lithostrattreedef")
public class LithoStratTreeDef
extends BaseTreeDef<LithoStrat, LithoStratTreeDef, LithoStratTreeDefItem>
implements Serializable {
    protected Integer lithoStratTreeDefId;
    protected String name;
    protected String remarks;
    protected Integer fullNameDirection;
    protected Set<Discipline> disciplines;
    protected Set<LithoStrat> treeEntries;
    protected Set<LithoStratTreeDefItem> treeDefItems;

    public LithoStratTreeDef() {
    }

    public LithoStratTreeDef(Integer geologicTimePeriodTreeDefId) {
        this.lithoStratTreeDefId = geologicTimePeriodTreeDefId;
    }

    @Override
    public void initialize() {
        super.init();
        this.lithoStratTreeDefId = null;
        this.name = null;
        this.remarks = null;
        this.fullNameDirection = null;
        this.disciplines = new HashSet<Discipline>();
        this.treeEntries = new HashSet<LithoStrat>();
        this.treeDefItems = new HashSet<LithoStratTreeDefItem>();
    }

    @Id
    @GeneratedValue
    @Column(name="LithoStratTreeDefID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getLithoStratTreeDefId() {
        return this.lithoStratTreeDefId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.lithoStratTreeDefId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return LithoStratTreeDef.class;
    }

    public void setLithoStratTreeDefId(Integer geologicTimePeriodTreeDefId) {
        this.lithoStratTreeDefId = geologicTimePeriodTreeDefId;
    }

    @Override
    @Column(name="Name", nullable=false, length=64)
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    @Override
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Override
    @Column(name="FullNameDirection", unique=false, nullable=true, insertable=true, updatable=true)
    public Integer getFullNameDirection() {
        return this.fullNameDirection;
    }

    @Override
    public void setFullNameDirection(Integer fullNameDirection) {
        this.fullNameDirection = fullNameDirection;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="lithoStratTreeDef")
    public Set<Discipline> getDisciplines() {
        return this.disciplines;
    }

    public void setDisciplines(Set<Discipline> disciplines) {
        this.disciplines = disciplines;
    }

    public void addDiscipline(Discipline ct) {
        this.disciplines.add(ct);
        ct.setLithoStratTreeDef(this);
    }

    public void removeDiscipline(Discipline ct) {
        this.disciplines.remove(ct);
        ct.setLithoStratTreeDef(null);
    }

    @Override
    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="definition")
    @Cascade(value={CascadeType.SAVE_UPDATE, CascadeType.LOCK, CascadeType.MERGE})
    public Set<LithoStrat> getTreeEntries() {
        return this.treeEntries;
    }

    @Override
    public void setTreeEntries(Set<LithoStrat> treeEntries) {
        this.treeEntries = treeEntries;
    }

    @Override
    @OneToMany(cascade={}, fetch=FetchType.EAGER, mappedBy="treeDef")
    @Cascade(value={CascadeType.SAVE_UPDATE, CascadeType.LOCK})
    public Set<LithoStratTreeDefItem> getTreeDefItems() {
        return this.treeDefItems;
    }

    @Override
    public void setTreeDefItems(Set<LithoStratTreeDefItem> treeDefItems) {
        this.treeDefItems = treeDefItems;
    }

    @Override
    @Transient
    public Integer getTreeDefId() {
        return this.getLithoStratTreeDefId();
    }

    @Override
    public void setTreeDefId(Integer id) {
        this.setLithoStratTreeDefId(id);
    }

    public void addTreeEntry(LithoStrat taxon) {
        this.treeEntries.add(taxon);
        taxon.setDefinition(this);
    }

    public void removeTreeEntry(LithoStrat taxon) {
        this.treeEntries.remove(taxon);
        taxon.setDefinition((LithoStratTreeDef)null);
    }

    public void addTreeDefItem(LithoStratTreeDefItem item) {
        this.treeDefItems.add(item);
        item.setTreeDef(this);
    }

    public void removeTreeDefItem(LithoStratTreeDefItem item) {
        this.treeDefItems.remove(item);
        item.setTreeDef((LithoStratTreeDef)null);
    }

    @Override
    @Transient
    public Class<LithoStrat> getNodeClass() {
        return LithoStrat.class;
    }

    @Override
    public LithoStratTreeDefItem getDefItemByRank(Integer rank) {
        for (LithoStratTreeDefItem item : this.treeDefItems) {
            if (!item.getRankId().equals(rank)) continue;
            return item;
        }
        return null;
    }

    public boolean canChildBeReparentedToNode(LithoStrat child, LithoStrat newParent) {
        if (newParent.getRankId() >= child.getRankId()) {
            return false;
        }
        Integer nextEnforcedRank = this.getRankOfNextHighestEnforcedLevel(child);
        if (nextEnforcedRank == null) {
            return true;
        }
        return nextEnforcedRank <= newParent.getRankId();
    }

    public Integer getRankOfNextHighestEnforcedLevel(LithoStrat node) {
        LithoStratTreeDefItem defItem = node.getDefinitionItem();
        while (defItem.getParent() != null) {
            if ((defItem = defItem.getParent()).getIsEnforced() == null || !defItem.getIsEnforced().booleanValue()) continue;
            return defItem.getRankId();
        }
        return null;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return Discipline.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        Vector<Object> ids = BasicSQLUtils.querySingleCol("SELECT DisciplineID FROM discipline WHERE LithoStratTreeDefID = " + this.lithoStratTreeDefId);
        if (ids.size() == 1) {
            return (Integer)ids.get(0);
        }
        return null;
    }

    @Override
    @Transient
    public int getSynonymizedLevel() {
        return 1;
    }

    @Override
    @Transient
    public int getTableId() {
        return LithoStratTreeDef.getClassTableId();
    }

    public static int getClassTableId() {
        return 47;
    }

    @Override
    public String toString() {
        return this.getIdentityTitle();
    }

    @Override
    @Transient
    public List<TreeDefItemStandardEntry> getStandardLevels() {
        LinkedList<TreeDefItemStandardEntry> result = new LinkedList<TreeDefItemStandardEntry>();
        result.add(new TreeDefItemStandardEntry("LithoStratTreeDef.SuperGroup", 100));
        result.add(new TreeDefItemStandardEntry("LithoStratTreeDef.Group", 200));
        result.add(new TreeDefItemStandardEntry("LithoStratTreeDef.Formation", 300));
        result.add(new TreeDefItemStandardEntry("LithoStratTreeDef.Member", 400));
        result.add(new TreeDefItemStandardEntry("LithoStratTreeDef.Bed", 500));
        return result;
    }
}

