/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.LithoStratTreeDef;
import edu.ku.brc.specify.datamodel.LithoStratTreeDefItem;
import edu.ku.brc.specify.datamodel.PaleoContext;
import edu.ku.brc.specify.datamodel.Treeable;
import edu.ku.brc.specify.treeutils.TreeOrderSiblingComparator;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="lithostrat")
@Table(appliesTo="lithostrat", indexes={@Index(name="LithoNameIDX", columnNames={"Name"}), @Index(name="LithoFullNameIDX", columnNames={"FullName"}), @Index(name="LithoGuidIDX", columnNames={"GUID"})})
public class LithoStrat
extends DataModelObjBase
implements Serializable,
Treeable<LithoStrat, LithoStratTreeDef, LithoStratTreeDefItem> {
    protected static final Logger log = Logger.getLogger(LithoStrat.class);
    protected Integer lithoStratId;
    protected Integer rankId;
    protected String name;
    protected String fullName;
    protected String remarks;
    protected String guid;
    protected String text1;
    protected String text2;
    protected Double number1;
    protected Double number2;
    protected Boolean yesNo1;
    protected Boolean yesNo2;
    protected Integer nodeNumber;
    protected Integer highestChildNodeNumber;
    protected LithoStratTreeDef definition;
    protected LithoStratTreeDefItem definitionItem;
    protected LithoStrat parent;
    protected Set<LithoStrat> children;
    protected Set<PaleoContext> paleoContexts;
    protected Boolean isAccepted;
    protected LithoStrat acceptedLithoStrat;
    protected Set<LithoStrat> acceptedChildren;

    public LithoStrat() {
    }

    public LithoStrat(Integer lithoStratId) {
        this.lithoStratId = lithoStratId;
    }

    @Override
    public void initialize() {
        super.init();
        this.lithoStratId = null;
        this.rankId = null;
        this.name = null;
        this.fullName = null;
        this.remarks = null;
        this.guid = null;
        this.text1 = null;
        this.text2 = null;
        this.number1 = null;
        this.number2 = null;
        this.yesNo1 = null;
        this.yesNo2 = null;
        this.nodeNumber = null;
        this.highestChildNodeNumber = null;
        this.definition = null;
        this.definitionItem = null;
        this.parent = null;
        this.children = new HashSet<LithoStrat>();
        this.paleoContexts = new HashSet<PaleoContext>();
        this.isAccepted = true;
        this.acceptedLithoStrat = null;
        this.acceptedChildren = new HashSet<LithoStrat>();
    }

    @Id
    @GeneratedValue
    @Column(name="LithoStratID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getLithoStratId() {
        return this.lithoStratId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.lithoStratId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return LithoStrat.class;
    }

    public void setLithoStratId(Integer lithoStratId) {
        this.lithoStratId = lithoStratId;
    }

    @Override
    @Column(name="RankID", nullable=false)
    public Integer getRankId() {
        return this.rankId;
    }

    @Override
    public void setRankId(Integer rankId) {
        this.rankId = rankId;
    }

    @Override
    @Column(name="Name", nullable=false, length=64)
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Column(name="FullName", length=255)
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @Column(name="GUID", unique=false, nullable=true, insertable=true, updatable=true, length=128)
    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    @Column(name="Text1", unique=false, nullable=true, insertable=true, updatable=true, length=300)
    public String getText1() {
        return this.text1;
    }

    public void setText1(String text1) {
        this.text1 = text1;
    }

    @Column(name="Text2", unique=false, nullable=true, insertable=true, updatable=true, length=300)
    public String getText2() {
        return this.text2;
    }

    public void setText2(String text2) {
        this.text2 = text2;
    }

    @Column(name="Number1", unique=false, nullable=true, insertable=true, updatable=true)
    public Double getNumber1() {
        return this.number1;
    }

    public void setNumber1(Double number1) {
        this.number1 = number1;
    }

    @Column(name="Number2", unique=false, nullable=true, insertable=true, updatable=true)
    public Double getNumber2() {
        return this.number2;
    }

    public void setNumber2(Double number2) {
        this.number2 = number2;
    }

    @Column(name="YesNo1", unique=false, nullable=true, insertable=true, updatable=true)
    public Boolean getYesNo1() {
        return this.yesNo1;
    }

    public void setYesNo1(Boolean yesNo1) {
        this.yesNo1 = yesNo1;
    }

    @Column(name="YesNo2", unique=false, nullable=true, insertable=true, updatable=true)
    public Boolean getYesNo2() {
        return this.yesNo2;
    }

    public void setYesNo2(Boolean yesNo2) {
        this.yesNo2 = yesNo2;
    }

    @Override
    @Column(name="NodeNumber", unique=false, nullable=true, insertable=true, updatable=true)
    public Integer getNodeNumber() {
        return this.nodeNumber;
    }

    @Override
    public void setNodeNumber(Integer nodeNumber) {
        this.nodeNumber = nodeNumber;
    }

    @Override
    @Column(name="HighestChildNodeNumber", unique=false, nullable=true, insertable=true, updatable=true)
    public Integer getHighestChildNodeNumber() {
        return this.highestChildNodeNumber;
    }

    @Override
    public void setHighestChildNodeNumber(Integer highestChildNodeNumber) {
        this.highestChildNodeNumber = highestChildNodeNumber;
    }

    @Override
    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    @Override
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Override
    @Column(name="IsAccepted", unique=false, nullable=true, insertable=true, updatable=true)
    public Boolean getIsAccepted() {
        return this.isAccepted;
    }

    @Override
    public void setIsAccepted(Boolean accepted) {
        this.isAccepted = accepted;
    }

    @Override
    @OneToMany(fetch=FetchType.EAGER, mappedBy="acceptedLithoStrat")
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.LOCK})
    public Set<LithoStrat> getAcceptedChildren() {
        return this.acceptedChildren;
    }

    @Override
    public void setAcceptedChildren(Set<LithoStrat> acceptedChildren) {
        this.acceptedChildren = acceptedChildren;
    }

    @ManyToOne(cascade={}, fetch=FetchType.EAGER)
    @JoinColumn(name="AcceptedID")
    public LithoStrat getAcceptedLithoStrat() {
        return this.acceptedLithoStrat;
    }

    public void setAcceptedLithoStrat(LithoStrat acceptedLithoStrat) {
        this.acceptedLithoStrat = acceptedLithoStrat;
    }

    @Override
    @Transient
    public LithoStrat getAcceptedParent() {
        return this.getAcceptedLithoStrat();
    }

    @Override
    public void setAcceptedParent(LithoStrat acceptedParent) {
        this.setAcceptedLithoStrat(acceptedParent);
    }

    @Override
    @ManyToOne(cascade={}, fetch=FetchType.EAGER)
    @JoinColumn(name="LithoStratTreeDefID", unique=false, nullable=false, insertable=true, updatable=true)
    public LithoStratTreeDef getDefinition() {
        return this.definition;
    }

    @Override
    public void setDefinition(LithoStratTreeDef definition) {
        this.definition = definition;
    }

    @Override
    @ManyToOne(cascade={}, fetch=FetchType.EAGER)
    @JoinColumn(name="LithoStratTreeDefItemID", unique=false, nullable=false, insertable=true, updatable=true)
    public LithoStratTreeDefItem getDefinitionItem() {
        return this.definitionItem;
    }

    @Override
    public void setDefinitionItem(LithoStratTreeDefItem definitionItem) {
        this.definitionItem = definitionItem;
        if (definitionItem != null && definitionItem.getRankId() != null) {
            this.rankId = this.definitionItem.getRankId();
        }
    }

    @Override
    @ManyToOne(cascade={}, fetch=FetchType.EAGER)
    @JoinColumn(name="ParentID", unique=false, nullable=true, insertable=true, updatable=true)
    public LithoStrat getParent() {
        return this.parent;
    }

    @Override
    public void setParent(LithoStrat parent) {
        this.parent = parent;
    }

    @Override
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="parent")
    public Set<LithoStrat> getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(Set<LithoStrat> children) {
        this.children = children;
    }

    @OneToMany(mappedBy="lithoStrat")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public Set<PaleoContext> getPaleoContexts() {
        return this.paleoContexts;
    }

    public void setPaleoContexts(Set<PaleoContext> paleoContexts) {
        this.paleoContexts = paleoContexts;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return LithoStrat.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.parent != null ? this.parent.getId() : null;
    }

    @Override
    @Transient
    public Integer getTreeId() {
        return this.getLithoStratId();
    }

    @Override
    public void setTreeId(Integer id) {
        this.setLithoStratId(id);
    }

    @Override
    public void addChild(LithoStrat child) {
        LithoStrat oldParent = child.getParent();
        if (oldParent != null) {
            oldParent.removeChild(child);
        }
        this.children.add(child);
        child.setParent(this);
    }

    @Override
    public void removeChild(LithoStrat child) {
        this.children.remove(child);
        child.setParent((LithoStrat)null);
    }

    @Override
    public String toString() {
        return this.fullName != null ? this.fullName : super.toString();
    }

    @Override
    @Transient
    public int getFullNameDirection() {
        return this.definition.getFullNameDirection();
    }

    @Override
    @Transient
    public String getFullNameSeparator() {
        return this.definitionItem.getFullNameSeparator();
    }

    public String fixFullName() {
        Vector<LithoStrat> parts = new Vector<LithoStrat>();
        parts.add(this);
        LithoStrat node = this.getParent();
        while (node != null) {
            Boolean include = node.getDefinitionItem().getIsInFullName();
            if (include != null && include.booleanValue()) {
                parts.add(node);
            }
            node = node.getParent();
        }
        int direction = this.getFullNameDirection();
        StringBuilder fullNameBuilder = new StringBuilder(parts.size() * 10);
        switch (direction) {
            case 1: {
                int j = parts.size() - 1;
                while (j > -1) {
                    LithoStrat part = (LithoStrat)parts.get(j);
                    String before = part.getDefinitionItem().getTextBefore();
                    String after = part.getDefinitionItem().getTextAfter();
                    if (before != null) {
                        fullNameBuilder.append(part.getDefinitionItem().getTextBefore());
                    }
                    fullNameBuilder.append(part.getName());
                    if (after != null) {
                        fullNameBuilder.append(part.getDefinitionItem().getTextAfter());
                    }
                    if (j != parts.size() - 1) {
                        fullNameBuilder.append(((LithoStrat)parts.get(j)).getFullNameSeparator());
                    }
                    --j;
                }
                break;
            }
            case -1: {
                int j = 0;
                while (j < parts.size()) {
                    LithoStrat part = (LithoStrat)parts.get(j);
                    String before = part.getDefinitionItem().getTextBefore();
                    String after = part.getDefinitionItem().getTextAfter();
                    if (before != null) {
                        fullNameBuilder.append(part.getDefinitionItem().getTextBefore());
                    }
                    fullNameBuilder.append(part.getName());
                    if (after != null) {
                        fullNameBuilder.append(part.getDefinitionItem().getTextAfter());
                    }
                    if (j != parts.size() - 1) {
                        fullNameBuilder.append(((LithoStrat)parts.get(j)).getFullNameSeparator());
                    }
                    ++j;
                }
                break;
            }
            default: {
                log.error((Object)"Invalid tree walk direction (for creating fullname field) found in tree definition");
                return null;
            }
        }
        return fullNameBuilder.toString().trim();
    }

    @Override
    @Transient
    public int getDescendantCount() {
        int totalDescendants = 0;
        for (LithoStrat child : this.getChildren()) {
            totalDescendants += 1 + child.getDescendantCount();
        }
        return totalDescendants;
    }

    @Override
    public boolean childrenAllowed() {
        return this.definitionItem != null && this.definitionItem.getChild() != null;
    }

    @Override
    @Transient
    public List<LithoStrat> getAllDescendants() {
        Vector<LithoStrat> descendants = new Vector<LithoStrat>();
        for (LithoStrat child : this.getChildren()) {
            descendants.add(child);
            descendants.addAll(child.getAllDescendants());
        }
        return descendants;
    }

    @Override
    @Transient
    public List<LithoStrat> getAllAncestors() {
        Vector<LithoStrat> ancestors = new Vector<LithoStrat>();
        LithoStrat parentNode = this.parent;
        while (parentNode != null) {
            ancestors.add(0, parentNode);
            parentNode = parentNode.getParent();
        }
        return ancestors;
    }

    @Override
    public boolean isDescendantOf(LithoStrat node) {
        if (node == null) {
            throw new NullPointerException();
        }
        LithoStrat i = this.getParent();
        while (i != null) {
            if (i.getId() == this.getId()) {
                return true;
            }
            i = i.getParent();
        }
        return false;
    }

    @Override
    @Transient
    public Comparator<? super LithoStrat> getComparator() {
        return new TreeOrderSiblingComparator();
    }

    @Override
    @Transient
    public int getTableId() {
        return LithoStrat.getClassTableId();
    }

    public static int getClassTableId() {
        return 100;
    }
}

