/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.LatLonPolygonPnt;
import edu.ku.brc.specify.datamodel.Locality;
import edu.ku.brc.specify.datamodel.SpVisualQuery;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="latlonpolygon")
@Table(appliesTo="latlonpolygon")
public class LatLonPolygon
extends DataModelObjBase
implements Cloneable {
    protected Integer latLonPolygonId;
    protected String name;
    protected Boolean isPolyline;
    protected String description;
    protected Set<LatLonPolygonPnt> points;
    protected SpVisualQuery visualQuery;
    protected Locality locality;

    @Override
    public void initialize() {
        super.init();
        this.latLonPolygonId = null;
        this.name = null;
        this.isPolyline = false;
        this.description = null;
        this.points = new HashSet<LatLonPolygonPnt>();
    }

    @Id
    @GeneratedValue
    @Column(name="LatLonPolygonID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getLatLonPolygonId() {
        return this.latLonPolygonId;
    }

    @Column(name="Name", unique=false, nullable=false, insertable=true, updatable=true, length=64)
    public String getName() {
        return this.name;
    }

    @Column(name="IsPolyline", unique=false, nullable=false, insertable=true, updatable=true)
    public Boolean getIsPolyline() {
        return this.isPolyline;
    }

    @Lob
    @Column(name="Description", length=4096)
    public String getDescription() {
        return this.description;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="latLonPolygon")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<LatLonPolygonPnt> getPoints() {
        return this.points;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="SpVisualQueryID", unique=false, nullable=true, insertable=true, updatable=true)
    public SpVisualQuery getVisualQuery() {
        return this.visualQuery;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="LocalityID", unique=false, nullable=true, insertable=true, updatable=true)
    public Locality getLocality() {
        return this.locality;
    }

    public void setLatLonPolygonId(Integer latLonPolygonId) {
        this.latLonPolygonId = latLonPolygonId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setPoints(Set<LatLonPolygonPnt> points) {
        this.points = points;
    }

    public void setVisualQuery(SpVisualQuery visualQuery) {
        this.visualQuery = visualQuery;
    }

    public void setIsPolyline(Boolean isPolyline) {
        this.isPolyline = isPolyline;
    }

    public void setLocality(Locality locality) {
        this.locality = locality;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        LatLonPolygon obj = (LatLonPolygon)super.clone();
        obj.init();
        obj.latLonPolygonId = null;
        obj.points = new HashSet<LatLonPolygonPnt>();
        for (LatLonPolygonPnt pnt : this.points) {
            LatLonPolygonPnt llpp = (LatLonPolygonPnt)pnt.clone();
            obj.points.add(llpp);
            llpp.setLatLonPolygon(obj);
        }
        return obj;
    }

    @Override
    @Transient
    public Integer getParentId() {
        if (this.visualQuery != null) {
            return this.visualQuery.getId();
        }
        if (this.locality != null) {
            return this.locality.getId();
        }
        return null;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return LatLonPolygon.class;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.latLonPolygonId;
    }

    @Override
    @Transient
    public int getTableId() {
        return LatLonPolygon.getClassTableId();
    }

    public static int getClassTableId() {
        return 136;
    }
}

