/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.ReferenceWork;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="journal")
@Table(appliesTo="journal", indexes={@Index(name="JournalNameIDX", columnNames={"JournalName"}), @Index(name="JournalGUIDIDX", columnNames={"GUID"})})
public class Journal
extends DataModelObjBase
implements Serializable {
    protected Integer journalId;
    protected String journalName;
    protected String journalAbbreviation;
    protected String issn;
    protected String text1;
    protected String guid;
    protected String remarks;
    protected Set<ReferenceWork> referenceWorks;

    public Journal() {
    }

    public Journal(Integer journalId) {
        this.journalId = journalId;
    }

    @Override
    public void initialize() {
        super.init();
        this.journalId = null;
        this.journalName = null;
        this.journalAbbreviation = null;
        this.guid = null;
        this.issn = null;
        this.text1 = null;
        this.remarks = null;
        this.referenceWorks = new HashSet<ReferenceWork>();
    }

    @Id
    @GeneratedValue
    @Column(name="JournalID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getJournalId() {
        return this.journalId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.journalId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return Journal.class;
    }

    public void setJournalId(Integer journalId) {
        this.journalId = journalId;
    }

    @Column(name="JournalName", unique=false, nullable=true, insertable=true, updatable=true)
    public String getJournalName() {
        return this.journalName;
    }

    public void setJournalName(String journalName) {
        this.journalName = journalName;
    }

    @Column(name="JournalAbbreviation", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getJournalAbbreviation() {
        return this.journalAbbreviation;
    }

    public void setJournalAbbreviation(String journalAbbreviation) {
        this.journalAbbreviation = journalAbbreviation;
    }

    @Column(name="GUID", unique=false, nullable=true, insertable=true, updatable=true, length=128)
    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    @Column(name="ISSN", unique=false, nullable=true, insertable=true, updatable=true, length=16)
    public String getIssn() {
        return this.issn;
    }

    public void setIssn(String issn) {
        this.issn = issn;
    }

    @Column(name="Text1", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getText1() {
        return this.text1;
    }

    public void setText1(String text1) {
        this.text1 = text1;
    }

    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="journal")
    @Cascade(value={CascadeType.SAVE_UPDATE, CascadeType.MERGE, CascadeType.LOCK})
    public Set<ReferenceWork> getReferenceWorks() {
        return this.referenceWorks;
    }

    public void setReferenceWorks(Set<ReferenceWork> referenceWorks) {
        this.referenceWorks = referenceWorks;
    }

    @Override
    @Transient
    public int getTableId() {
        return Journal.getClassTableId();
    }

    public static int getClassTableId() {
        return 51;
    }
}

