/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.Address;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Table;

@Entity
@javax.persistence.Table(name="institutionnetwork")
@Table(appliesTo="institutionnetwork", indexes={@Index(name="InstNetworkNameIDX", columnNames={"Name"})})
public class InstitutionNetwork
extends DataModelObjBase
implements Serializable {
    protected Integer institutionNetworkId;
    protected String name;
    protected String altName;
    protected String code;
    protected String uri;
    protected String iconURI;
    protected String ipr;
    protected String copyright;
    protected String termsOfUse;
    protected String disclaimer;
    protected String remarks;
    protected String description;
    protected String license;
    protected Address address;
    protected Set<Agent> contacts;
    protected Set<Collection> collections;

    public InstitutionNetwork() {
    }

    public InstitutionNetwork(Integer institutionNetworkId) {
        this.institutionNetworkId = institutionNetworkId;
    }

    @Override
    public void initialize() {
        super.init();
        this.institutionNetworkId = null;
        this.name = null;
        this.altName = null;
        this.code = null;
        this.uri = null;
        this.iconURI = null;
        this.ipr = null;
        this.copyright = null;
        this.termsOfUse = null;
        this.disclaimer = null;
        this.remarks = null;
        this.description = null;
        this.license = null;
        this.address = null;
        this.contacts = new HashSet<Agent>();
        this.collections = new HashSet<Collection>();
    }

    @Id
    @GeneratedValue
    @Column(name="InstitutionNetworkID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getInstitutionNetworkId() {
        return this.institutionNetworkId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.institutionNetworkId;
    }

    @Column(name="Code", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getCode() {
        return this.code;
    }

    @Lob
    @Column(name="Copyright", unique=false, nullable=true, insertable=true, updatable=true, length=8192)
    public String getCopyright() {
        return this.copyright;
    }

    @Lob
    @Column(name="Disclaimer", unique=false, nullable=true, insertable=true, updatable=true, length=8192)
    public String getDisclaimer() {
        return this.disclaimer;
    }

    @Column(name="IconURI", unique=false, nullable=true, insertable=true, updatable=true, length=255)
    public String getIconURI() {
        return this.iconURI;
    }

    @Lob
    @Column(name="Ipr", unique=false, nullable=true, insertable=true, updatable=true, length=8192)
    public String getIpr() {
        return this.ipr;
    }

    @Lob
    @Column(name="License", unique=false, nullable=true, insertable=true, updatable=true, length=2048)
    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    @Column(name="Name", unique=false, nullable=true, insertable=true, updatable=true, length=255)
    public String getName() {
        return this.name;
    }

    @Lob
    @Column(name="Remarks", unique=false, nullable=true, insertable=true, updatable=true, length=8192)
    public String getRemarks() {
        return this.remarks;
    }

    @Lob
    @Column(name="Description", length=8192)
    public String getDescription() {
        return this.description;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="instTechContact")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<Agent> getContacts() {
        return this.contacts;
    }

    @Lob
    @Column(name="TermsOfUse", unique=false, nullable=true, insertable=true, updatable=true, length=8192)
    public String getTermsOfUse() {
        return this.termsOfUse;
    }

    @Column(name="AltName", unique=false, nullable=true, insertable=true, updatable=true, length=128)
    public String getAltName() {
        return this.altName;
    }

    @Column(name="Uri", unique=false, nullable=true, insertable=true, updatable=true, length=255)
    public String getUri() {
        return this.uri;
    }

    @Column(name="Code", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public void setCode(String code) {
        this.code = code;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public void setDisclaimer(String disclaimer) {
        this.disclaimer = disclaimer;
    }

    public void setIconURI(String iconURI) {
        this.iconURI = iconURI;
    }

    public void setInstitutionNetworkId(Integer institutionNetworkId) {
        this.institutionNetworkId = institutionNetworkId;
    }

    public void setIpr(String ipr) {
        this.ipr = ipr;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setContacts(Set<Agent> contacts) {
        this.contacts = contacts;
    }

    public void setTermsOfUse(String termsOfUse) {
        this.termsOfUse = termsOfUse;
    }

    public void setAltName(String altName) {
        this.altName = altName;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="AddressID", unique=false, nullable=true, insertable=true, updatable=true)
    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="institutionNetwork")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<Collection> getCollections() {
        return this.collections;
    }

    public void setCollections(Set<Collection> collections) {
        this.collections = collections;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return InstitutionNetwork.class;
    }

    @Override
    @Transient
    public int getTableId() {
        return InstitutionNetwork.getClassTableId();
    }

    public static int getClassTableId() {
        return 94;
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        return StringUtils.isNotEmpty((String)this.name) ? this.name : super.getIdentityTitle();
    }

    @Override
    public String toString() {
        return this.getIdentityTitle();
    }
}

