/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.Address;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.datamodel.StorageTreeDef;
import edu.ku.brc.specify.datamodel.UserGroupScope;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Table;

@Entity
@javax.persistence.Table(name="institution")
@Table(appliesTo="institution", indexes={@Index(name="InstNameIDX", columnNames={"Name"})})
public class Institution
extends UserGroupScope
implements Serializable {
    public static final byte MIN_PASSWORD_LEN = 8;
    protected Integer institutionId;
    protected String name;
    protected String altName;
    protected String code;
    protected String uri;
    protected String lsidAuthority;
    protected String iconURI;
    protected String ipr;
    protected String copyright;
    protected String termsOfUse;
    protected String disclaimer;
    protected String remarks;
    protected String description;
    protected String license;
    protected Boolean isServerBased;
    protected String regNumber;
    protected Boolean isAnonymous;
    protected Boolean hasBeenAsked;
    protected Boolean isSecurityOn;
    protected Boolean isAccessionsGlobal;
    protected Boolean isSingleGeographyTree;
    protected Boolean isSharingLocalities;
    protected Boolean isReleaseManagedGlobally;
    protected String currentManagedRelVersion;
    protected String currentManagedSchemaVersion;
    protected Byte minimumPwdLength;
    protected Address address;
    protected Set<Agent> technicalContacts;
    protected Set<Agent> contentContacts;
    protected Set<Division> divisions;
    protected StorageTreeDef storageTreeDef;

    public Institution() {
    }

    public Institution(Integer institutionId) {
        super(institutionId);
    }

    @Override
    public void initialize() {
        super.init();
        this.institutionId = null;
        this.name = null;
        this.altName = null;
        this.code = null;
        this.uri = null;
        this.lsidAuthority = null;
        this.iconURI = null;
        this.ipr = null;
        this.copyright = null;
        this.termsOfUse = null;
        this.disclaimer = null;
        this.remarks = null;
        this.description = null;
        this.license = null;
        this.address = null;
        this.isServerBased = false;
        this.isAnonymous = null;
        this.hasBeenAsked = null;
        this.regNumber = null;
        this.isSecurityOn = true;
        this.isAccessionsGlobal = true;
        this.isSingleGeographyTree = false;
        this.isSharingLocalities = false;
        this.isReleaseManagedGlobally = false;
        this.currentManagedRelVersion = null;
        this.currentManagedSchemaVersion = null;
        this.minimumPwdLength = 8;
        this.technicalContacts = new HashSet<Agent>();
        this.contentContacts = new HashSet<Agent>();
        this.divisions = new HashSet<Division>();
        this.storageTreeDef = null;
    }

    public Integer getInstitutionId() {
        return this.getUserGroupScopeId();
    }

    @Override
    @Transient
    public Integer getId() {
        return this.getUserGroupScopeId();
    }

    @Column(name="Code", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getCode() {
        return this.code;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="instContentContact")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<Agent> getContentContacts() {
        return this.contentContacts;
    }

    @Lob
    @Column(name="Copyright", unique=false, nullable=true, insertable=true, updatable=true, length=8192)
    public String getCopyright() {
        return this.copyright;
    }

    @Lob
    @Column(name="Disclaimer", unique=false, nullable=true, insertable=true, updatable=true, length=8192)
    public String getDisclaimer() {
        return this.disclaimer;
    }

    @Column(name="IconURI", unique=false, nullable=true, insertable=true, updatable=true, length=255)
    public String getIconURI() {
        return this.iconURI;
    }

    @Lob
    @Column(name="Ipr", unique=false, nullable=true, insertable=true, updatable=true, length=8192)
    public String getIpr() {
        return this.ipr;
    }

    @Lob
    @Column(name="License", unique=false, nullable=true, insertable=true, updatable=true, length=2048)
    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    @Column(name="Name", unique=false, nullable=true, insertable=true, updatable=true, length=255)
    public String getName() {
        return this.name;
    }

    @Lob
    @Column(name="Remarks", unique=false, nullable=true, insertable=true, updatable=true, length=8192)
    public String getRemarks() {
        return this.remarks;
    }

    @Lob
    @Column(name="Description", length=8192)
    public String getDescription() {
        return this.description;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="instTechContact")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<Agent> getTechnicalContacts() {
        return this.technicalContacts;
    }

    @Lob
    @Column(name="TermsOfUse", unique=false, nullable=true, insertable=true, updatable=true, length=8192)
    public String getTermsOfUse() {
        return this.termsOfUse;
    }

    @Column(name="AltName", unique=false, nullable=true, insertable=true, updatable=true, length=128)
    public String getAltName() {
        return this.altName;
    }

    @Column(name="Uri", unique=false, nullable=true, insertable=true, updatable=true, length=255)
    public String getUri() {
        return this.uri;
    }

    @Column(name="LsidAuthority", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getLsidAuthority() {
        return this.lsidAuthority;
    }

    @Column(name="Code", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public void setCode(String code) {
        this.code = code;
    }

    @Column(name="IsServerBased", unique=false, nullable=false, insertable=true, updatable=true)
    public Boolean getIsServerBased() {
        return this.isServerBased;
    }

    @Column(name="IsAnonymous", unique=false, nullable=true, insertable=true, updatable=true)
    public Boolean getIsAnonymous() {
        return this.isAnonymous == null ? false : this.isAnonymous;
    }

    @Transient
    public boolean isSendStatsAnonymous() {
        return this.getIsAnonymous();
    }

    @Column(name="HasBeenAsked", unique=false, nullable=true, insertable=true, updatable=true)
    public Boolean getHasBeenAsked() {
        return this.hasBeenAsked == null ? false : this.hasBeenAsked;
    }

    @Column(name="RegNumber", unique=false, nullable=true, insertable=true, updatable=true, length=24)
    public String getRegNumber() {
        return this.regNumber;
    }

    @Column(name="IsSecurityOn", unique=false, nullable=false, insertable=true, updatable=true)
    public Boolean getIsSecurityOn() {
        return this.isSecurityOn;
    }

    @Column(name="IsAccessionsGlobal", unique=false, nullable=false, insertable=true, updatable=true)
    public Boolean getIsAccessionsGlobal() {
        return this.isAccessionsGlobal;
    }

    @Column(name="IsSingleGeographyTree", unique=false, nullable=false, insertable=true, updatable=true)
    public Boolean getIsSingleGeographyTree() {
        return this.isSingleGeographyTree;
    }

    @Column(name="IsSharingLocalities", unique=false, nullable=false, insertable=true, updatable=true)
    public Boolean getIsSharingLocalities() {
        return this.isSharingLocalities;
    }

    @Column(name="IsReleaseManagedGlobally", unique=false, nullable=true, insertable=true, updatable=true)
    public Boolean getIsReleaseManagedGlobally() {
        return this.isReleaseManagedGlobally == null ? false : this.isReleaseManagedGlobally;
    }

    @Column(name="CurrentManagedRelVersion", unique=false, nullable=true, insertable=true, updatable=true, length=8)
    public String getCurrentManagedRelVersion() {
        return this.currentManagedRelVersion;
    }

    @Column(name="CurrentManagedSchemaVersion", unique=false, nullable=true, insertable=true, updatable=true, length=8)
    public String getCurrentManagedSchemaVersion() {
        return this.currentManagedSchemaVersion;
    }

    @Column(name="MinimumPwdLength", unique=false, nullable=true, insertable=true, updatable=true)
    public Byte getMinimumPwdLength() {
        return this.minimumPwdLength == null ? (byte)0 : this.minimumPwdLength;
    }

    public void setContentContacts(Set<Agent> contentContacts) {
        this.contentContacts = contentContacts;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public void setDisclaimer(String disclaimer) {
        this.disclaimer = disclaimer;
    }

    public void setIconURI(String iconURI) {
        this.iconURI = iconURI;
    }

    public void setInstitutionId(Integer institutionId) {
        this.setUserGroupScopeId(institutionId);
    }

    public void setIpr(String ipr) {
        this.ipr = ipr;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setTechnicalContacts(Set<Agent> technicalContacts) {
        this.technicalContacts = technicalContacts;
    }

    public void setTermsOfUse(String termsOfUse) {
        this.termsOfUse = termsOfUse;
    }

    public void setAltName(String altName) {
        this.altName = altName;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setLsidAuthority(String lsidAuthority) {
        this.lsidAuthority = lsidAuthority;
    }

    public void setIsServerBased(Boolean isServerBased) {
        this.isServerBased = isServerBased;
    }

    public void setIsAnonymous(Boolean isAnonymous) {
        this.isAnonymous = isAnonymous;
    }

    public void setHasBeenAsked(Boolean hasBeenAsked) {
        this.hasBeenAsked = hasBeenAsked;
    }

    public void setRegNumber(String regNumber) {
        this.regNumber = regNumber;
    }

    public void setIsSecurityOn(Boolean isSecurityOn) {
        this.isSecurityOn = isSecurityOn;
    }

    public void setIsAccessionsGlobal(Boolean isAccessionsGlobal) {
        this.isAccessionsGlobal = isAccessionsGlobal;
    }

    public void setIsSingleGeographyTree(Boolean isSingleGeographyTree) {
        this.isSingleGeographyTree = isSingleGeographyTree;
    }

    public void setIsSharingLocalities(Boolean isSharingLocalities) {
        this.isSharingLocalities = isSharingLocalities;
    }

    public void setIsReleaseManagedGlobally(Boolean isReleaseManagedGlobally) {
        this.isReleaseManagedGlobally = isReleaseManagedGlobally;
    }

    public void setCurrentManagedRelVersion(String currentManagedRelVersion) {
        this.currentManagedRelVersion = currentManagedRelVersion;
    }

    public void setCurrentManagedSchemaVersion(String currentManagedSchemaVersion) {
        this.currentManagedSchemaVersion = currentManagedSchemaVersion;
    }

    public void setMinimumPwdLength(Byte minimumPwdLength) {
        this.minimumPwdLength = minimumPwdLength;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="AddressID", unique=false, nullable=true, insertable=true, updatable=true)
    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="institution")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<Division> getDivisions() {
        return this.divisions;
    }

    public void setDivisions(Set<Division> divisions) {
        this.divisions = divisions;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="StorageTreeDefID")
    public StorageTreeDef getStorageTreeDef() {
        return this.storageTreeDef;
    }

    public void setStorageTreeDef(StorageTreeDef storageTreeDef) {
        this.storageTreeDef = storageTreeDef;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return Institution.class;
    }

    @Override
    @Transient
    public int getTableId() {
        return Institution.getClassTableId();
    }

    public static int getClassTableId() {
        return 94;
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        return StringUtils.isNotEmpty((String)this.name) ? this.name : super.getIdentityTitle();
    }

    @Override
    public String toString() {
        return this.getIdentityTitle();
    }
}

