/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.CollectionMember;
import edu.ku.brc.specify.datamodel.RecordSet;
import java.io.Serializable;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="inforequest")
@Table(appliesTo="inforequest", indexes={@Index(name="IRColMemIDX", columnNames={"CollectionMemberID"})})
public class InfoRequest
extends CollectionMember
implements Serializable {
    protected Integer infoRequestID;
    protected String infoReqNumber;
    protected String firstName;
    protected String lastName;
    protected String institution;
    protected String email;
    protected Calendar requestDate;
    protected Calendar replyDate;
    protected String remarks;
    protected Set<RecordSet> recordSets;
    protected Agent agent;

    public InfoRequest() {
    }

    public InfoRequest(Integer infoRequestID) {
        this.infoRequestID = infoRequestID;
    }

    @Override
    public void initialize() {
        super.init();
        this.infoRequestID = null;
        this.infoReqNumber = null;
        this.firstName = null;
        this.lastName = null;
        this.institution = null;
        this.email = null;
        this.requestDate = null;
        this.replyDate = null;
        this.remarks = null;
        this.recordSets = new HashSet<RecordSet>();
        this.agent = null;
    }

    @Id
    @GeneratedValue
    @Column(name="InfoRequestID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getInfoRequestID() {
        return this.infoRequestID;
    }

    public void setInfoRequestID(Integer infoRequestID) {
        this.infoRequestID = infoRequestID;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.infoRequestID;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return InfoRequest.class;
    }

    @Column(name="Firstname", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Column(name="Lastname", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Column(name="Institution", unique=false, nullable=true, insertable=true, updatable=true, length=127)
    public String getInstitution() {
        return this.institution;
    }

    public void setInstitution(String institution) {
        this.institution = institution;
    }

    @Column(name="Email", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="RequestDate", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getRequestDate() {
        return this.requestDate;
    }

    public void setRequestDate(Calendar requestDate) {
        this.requestDate = requestDate;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="ReplyDate", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getReplyDate() {
        return this.replyDate;
    }

    public void setReplyDate(Calendar replyDate) {
        this.replyDate = replyDate;
    }

    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, mappedBy="infoRequest")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<RecordSet> getRecordSets() {
        return this.recordSets;
    }

    public void setRecordSets(Set<RecordSet> recordSets) {
        this.recordSets = recordSets;
    }

    @Column(name="InfoReqNumber", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getInfoReqNumber() {
        return this.infoReqNumber;
    }

    public void setInfoReqNumber(String infoReqNumber) {
        this.infoReqNumber = infoReqNumber;
    }

    @ManyToOne(cascade={}, fetch=FetchType.EAGER)
    @JoinColumn(name="AgentID", unique=false, nullable=true, insertable=true, updatable=true)
    public Agent getAgent() {
        return this.agent;
    }

    public void setAgent(Agent agent) {
        this.agent = agent;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return Collection.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.collectionMemberId != null ? this.collectionMemberId : null;
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        return this.infoReqNumber != null ? this.infoReqNumber : super.getIdentityTitle();
    }

    @Override
    @Transient
    public int getTableId() {
        return InfoRequest.getClassTableId();
    }

    public static int getClassTableId() {
        return 50;
    }
}

