/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.util.Orderable;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Proxy;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@Table(name="groupperson", uniqueConstraints={@UniqueConstraint(columnNames={"OrderNumber", "GroupID"})})
public class GroupPerson
extends DataModelObjBase
implements Serializable,
Orderable,
Comparable<GroupPerson>,
Cloneable {
    protected Integer groupPersonId;
    protected Short orderNumber;
    protected String remarks;
    protected Agent group;
    protected Agent member;
    protected Division division;

    public GroupPerson() {
    }

    public GroupPerson(Integer groupPersonId) {
        this.groupPersonId = groupPersonId;
    }

    @Override
    public void initialize() {
        super.init();
        this.groupPersonId = null;
        this.orderNumber = null;
        this.remarks = null;
        this.group = null;
        this.member = null;
        this.division = AppContextMgr.getInstance().hasContext() ? AppContextMgr.getInstance().getClassObject(Division.class) : null;
    }

    @Id
    @GeneratedValue
    @Column(name="GroupPersonID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getGroupPersonId() {
        return this.groupPersonId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.groupPersonId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return GroupPerson.class;
    }

    public void setGroupPersonId(Integer groupPersonId) {
        this.groupPersonId = groupPersonId;
    }

    @Column(name="OrderNumber", unique=false, nullable=false, insertable=true, updatable=true)
    public Short getOrderNumber() {
        return this.orderNumber;
    }

    public void setOrderNumber(Short orderNumber) {
        this.orderNumber = orderNumber;
    }

    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="GroupID", unique=false, nullable=false, insertable=true, updatable=true)
    public Agent getGroup() {
        return this.group;
    }

    public void setGroup(Agent agentByGroup) {
        this.group = agentByGroup;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="MemberID", unique=false, nullable=false, insertable=true, updatable=true)
    public Agent getMember() {
        return this.member;
    }

    public void setMember(Agent agentByMember) {
        this.member = agentByMember;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="DivisionID", unique=false, nullable=false, insertable=true, updatable=true)
    public Division getDivision() {
        return this.division;
    }

    public void setDivision(Division division) {
        this.division = division;
    }

    @Override
    @Transient
    public int getTableId() {
        return GroupPerson.getClassTableId();
    }

    public static int getClassTableId() {
        return 49;
    }

    @Override
    @Transient
    public int getOrderIndex() {
        return this.orderNumber.shortValue();
    }

    @Override
    public void setOrderIndex(int order) {
        this.orderNumber = (short)order;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return Agent.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.member != null ? this.member.getId() : (this.group != null ? this.group.getId() : null);
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        String name = "";
        if (this.member != null) {
            name = this.member.getIdentityTitle();
        }
        if (StringUtils.isNotEmpty((String)name)) {
            return name;
        }
        return super.getIdentityTitle();
    }

    @Override
    public int compareTo(GroupPerson obj) {
        return this.orderNumber != null && obj != null && obj.orderNumber != null ? this.orderNumber.compareTo(obj.orderNumber) : 0;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        GroupPerson obj = (GroupPerson)super.clone();
        obj.init();
        obj.setGroupPersonId(null);
        return obj;
    }
}

