/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.AddressOfRecord;
import edu.ku.brc.specify.datamodel.DisciplineMember;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.datamodel.GiftAgent;
import edu.ku.brc.specify.datamodel.GiftAttachment;
import edu.ku.brc.specify.datamodel.GiftPreparation;
import edu.ku.brc.specify.datamodel.PreparationHolderIFace;
import edu.ku.brc.specify.datamodel.PreparationsProviderIFace;
import edu.ku.brc.specify.datamodel.Shipment;
import java.io.Serializable;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="gift")
@Table(appliesTo="gift", indexes={@Index(name="GiftNumberIDX", columnNames={"GiftNumber"}), @Index(name="GiftDateIDX", columnNames={"GiftDate"})})
public class Gift
extends DisciplineMember
implements Serializable,
PreparationsProviderIFace {
    protected Integer giftId;
    protected String giftNumber;
    protected Calendar giftDate;
    protected String receivedComments;
    protected String specialConditions;
    protected Boolean isFinancialResponsibility;
    protected String purposeOfGift;
    protected Calendar dateReceived;
    protected String srcGeography;
    protected String srcTaxonomy;
    protected String remarks;
    protected String text1;
    protected String text2;
    protected Float number1;
    protected Float number2;
    protected Boolean yesNo1;
    protected Boolean yesNo2;
    protected AddressOfRecord addressOfRecord;
    protected Set<GiftAgent> giftAgents;
    protected Set<GiftAttachment> giftAttachments;
    protected Set<GiftPreparation> giftPreparations;
    protected Set<Shipment> shipments;
    protected Division division;

    public Gift() {
    }

    public Gift(Integer giftId) {
        this.giftId = giftId;
    }

    @Override
    public void initialize() {
        super.init();
        this.giftId = null;
        this.giftNumber = null;
        this.giftDate = null;
        this.receivedComments = null;
        this.specialConditions = null;
        this.isFinancialResponsibility = null;
        this.purposeOfGift = null;
        this.dateReceived = null;
        this.srcGeography = null;
        this.srcTaxonomy = null;
        this.remarks = null;
        this.text1 = null;
        this.text2 = null;
        this.number1 = null;
        this.number2 = null;
        this.yesNo1 = null;
        this.yesNo2 = null;
        this.giftAgents = new HashSet<GiftAgent>();
        this.giftPreparations = new HashSet<GiftPreparation>();
        this.shipments = new HashSet<Shipment>();
        this.division = null;
        this.addressOfRecord = null;
        this.giftAttachments = null;
    }

    @Id
    @GeneratedValue
    @Column(name="GiftID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getGiftId() {
        return this.giftId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.giftId;
    }

    public void setGiftId(Integer giftId) {
        this.giftId = giftId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return Gift.class;
    }

    @Column(name="GiftNumber", unique=false, nullable=false, insertable=true, updatable=true, length=50)
    public String getGiftNumber() {
        return this.giftNumber;
    }

    public void setGiftNumber(String giftNumber) {
        this.giftNumber = giftNumber;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="GiftDate", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getGiftDate() {
        return this.giftDate;
    }

    public void setGiftDate(Calendar giftDate) {
        this.giftDate = giftDate;
    }

    @Column(name="SrcGeography", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getSrcGeography() {
        return this.srcGeography;
    }

    public void setSrcGeography(String srcGeography) {
        this.srcGeography = srcGeography;
    }

    @Column(name="SrcTaxonomy", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getSrcTaxonomy() {
        return this.srcTaxonomy;
    }

    public void setSrcTaxonomy(String srcTaxonomy) {
        this.srcTaxonomy = srcTaxonomy;
    }

    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Column(name="Text1", length=300, unique=false, nullable=true, insertable=true, updatable=true)
    public String getText1() {
        return this.text1;
    }

    public void setText1(String text1) {
        this.text1 = text1;
    }

    @Column(name="Text2", length=300, unique=false, nullable=true, insertable=true, updatable=true)
    public String getText2() {
        return this.text2;
    }

    public void setText2(String text2) {
        this.text2 = text2;
    }

    @Column(name="Number1", unique=false, nullable=true, insertable=true, updatable=true, length=24)
    public Float getNumber1() {
        return this.number1;
    }

    public void setNumber1(Float number1) {
        this.number1 = number1;
    }

    @Column(name="Number2", unique=false, nullable=true, insertable=true, updatable=true, length=24)
    public Float getNumber2() {
        return this.number2;
    }

    public void setNumber2(Float number2) {
        this.number2 = number2;
    }

    @Column(name="YesNo1", unique=false, nullable=true, updatable=true, insertable=true)
    public Boolean getYesNo1() {
        return this.yesNo1;
    }

    public void setYesNo1(Boolean yesNo1) {
        this.yesNo1 = yesNo1;
    }

    @Column(name="YesNo2", unique=false, nullable=true, updatable=true, insertable=true)
    public Boolean getYesNo2() {
        return this.yesNo2;
    }

    public void setYesNo2(Boolean yesNo2) {
        this.yesNo2 = yesNo2;
    }

    @Column(name="ReceivedComments", unique=false, nullable=true, insertable=true, updatable=true, length=255)
    public String getReceivedComments() {
        return this.receivedComments;
    }

    public void setReceivedComments(String receivedComments) {
        this.receivedComments = receivedComments;
    }

    @Lob
    @Column(name="SpecialConditions", unique=false, nullable=true, insertable=true, updatable=true, length=2048)
    public String getSpecialConditions() {
        return this.specialConditions;
    }

    public void setSpecialConditions(String specialConditions) {
        this.specialConditions = specialConditions;
    }

    @Column(name="IsFinancialResponsibility", unique=false, nullable=true, insertable=true, updatable=true)
    public Boolean getIsFinancialResponsibility() {
        return this.isFinancialResponsibility;
    }

    public void setIsFinancialResponsibility(Boolean isFinancialResponsibility) {
        this.isFinancialResponsibility = isFinancialResponsibility;
    }

    @Column(name="PurposeOfGift", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getPurposeOfGift() {
        return this.purposeOfGift;
    }

    public void setPurposeOfGift(String purposeOfGift) {
        this.purposeOfGift = purposeOfGift;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DateReceived", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getDateReceived() {
        return this.dateReceived;
    }

    public void setDateReceived(Calendar dateReceived) {
        this.dateReceived = dateReceived;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="DivisionID", unique=false, nullable=true, insertable=true, updatable=true)
    public Division getDivision() {
        return this.division;
    }

    public void setDivision(Division division) {
        this.division = division;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return Division.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.division != null ? this.division.getId() : null;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="AddressOfRecordID", unique=false, nullable=true, insertable=true, updatable=true)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public AddressOfRecord getAddressOfRecord() {
        return this.addressOfRecord;
    }

    public void setAddressOfRecord(AddressOfRecord addressOfRecord) {
        this.addressOfRecord = addressOfRecord;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="gift")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<GiftAgent> getGiftAgents() {
        return this.giftAgents;
    }

    public void setGiftAgents(Set<GiftAgent> giftAgents) {
        this.giftAgents = giftAgents;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="gift")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<GiftPreparation> getGiftPreparations() {
        return this.giftPreparations;
    }

    public void setGiftPreparations(Set<GiftPreparation> giftPreparations) {
        this.giftPreparations = giftPreparations;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="gift")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<Shipment> getShipments() {
        return this.shipments;
    }

    public void setShipments(Set<Shipment> shipments) {
        this.shipments = shipments;
    }

    @OneToMany(mappedBy="gift")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    @OrderBy(value="ordinal ASC")
    public Set<GiftAttachment> getGiftAttachments() {
        return this.giftAttachments;
    }

    public void setGiftAttachments(Set<GiftAttachment> giftAttachments) {
        this.giftAttachments = giftAttachments;
    }

    @Override
    @Transient
    public Set<PreparationHolderIFace> getPreparations() {
        HashSet<PreparationHolderIFace> set = new HashSet<PreparationHolderIFace>();
        for (GiftPreparation gp : this.giftPreparations) {
            set.add(gp);
        }
        return set;
    }

    @Override
    public void forceLoad() {
        this.getGiftAgents().size();
        this.getShipments().size();
        this.getGiftPreparations().size();
    }

    @Override
    @Transient
    public int getTableId() {
        return Gift.getClassTableId();
    }

    public static int getClassTableId() {
        return 131;
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        return this.giftNumber != null ? this.giftNumber : super.getIdentityTitle();
    }
}

