/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.BaseTreeDef;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.GeologicTimePeriod;
import edu.ku.brc.specify.datamodel.GeologicTimePeriodTreeDefItem;
import edu.ku.brc.specify.datamodel.TreeDefItemStandardEntry;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Proxy;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@Table(name="geologictimeperiodtreedef")
public class GeologicTimePeriodTreeDef
extends BaseTreeDef<GeologicTimePeriod, GeologicTimePeriodTreeDef, GeologicTimePeriodTreeDefItem>
implements Serializable {
    protected Integer geologicTimePeriodTreeDefId;
    protected String name;
    protected String remarks;
    protected Integer fullNameDirection;
    protected Set<Discipline> disciplines;
    protected Set<GeologicTimePeriod> treeEntries;
    protected Set<GeologicTimePeriodTreeDefItem> treeDefItems;

    public GeologicTimePeriodTreeDef() {
    }

    public GeologicTimePeriodTreeDef(Integer geologicTimePeriodTreeDefId) {
        this.geologicTimePeriodTreeDefId = geologicTimePeriodTreeDefId;
    }

    @Override
    public void initialize() {
        super.init();
        this.geologicTimePeriodTreeDefId = null;
        this.name = null;
        this.remarks = null;
        this.fullNameDirection = null;
        this.disciplines = new HashSet<Discipline>();
        this.treeEntries = new HashSet<GeologicTimePeriod>();
        this.treeDefItems = new HashSet<GeologicTimePeriodTreeDefItem>();
    }

    @Id
    @GeneratedValue
    @Column(name="GeologicTimePeriodTreeDefID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getGeologicTimePeriodTreeDefId() {
        return this.geologicTimePeriodTreeDefId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.geologicTimePeriodTreeDefId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return GeologicTimePeriodTreeDef.class;
    }

    public void setGeologicTimePeriodTreeDefId(Integer geologicTimePeriodTreeDefId) {
        this.geologicTimePeriodTreeDefId = geologicTimePeriodTreeDefId;
    }

    @Override
    @Column(name="Name", nullable=false, length=64)
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    @Override
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Override
    @Column(name="FullNameDirection", unique=false, nullable=true, insertable=true, updatable=true)
    public Integer getFullNameDirection() {
        return this.fullNameDirection;
    }

    @Override
    public void setFullNameDirection(Integer fullNameDirection) {
        this.fullNameDirection = fullNameDirection;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="geologicTimePeriodTreeDef")
    public Set<Discipline> getDisciplines() {
        return this.disciplines;
    }

    public void setDisciplines(Set<Discipline> disciplines) {
        this.disciplines = disciplines;
    }

    @Override
    @Transient
    public int getSynonymizedLevel() {
        return 1;
    }

    @Override
    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="definition")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<GeologicTimePeriod> getTreeEntries() {
        return this.treeEntries;
    }

    @Override
    public void setTreeEntries(Set<GeologicTimePeriod> treeEntries) {
        this.treeEntries = treeEntries;
    }

    @Override
    @OneToMany(cascade={}, fetch=FetchType.EAGER, mappedBy="treeDef")
    @Cascade(value={CascadeType.SAVE_UPDATE, CascadeType.LOCK})
    public Set<GeologicTimePeriodTreeDefItem> getTreeDefItems() {
        return this.treeDefItems;
    }

    @Override
    public void setTreeDefItems(Set<GeologicTimePeriodTreeDefItem> treeDefItems) {
        this.treeDefItems = treeDefItems;
    }

    @Override
    @Transient
    public Integer getTreeDefId() {
        return this.getGeologicTimePeriodTreeDefId();
    }

    @Override
    public void setTreeDefId(Integer id) {
        this.setGeologicTimePeriodTreeDefId(id);
    }

    public void addTreeEntry(GeologicTimePeriod taxon) {
        this.treeEntries.add(taxon);
        taxon.setDefinition(this);
    }

    public void removeTreeEntry(GeologicTimePeriod taxon) {
        this.treeEntries.remove(taxon);
        taxon.setDefinition((GeologicTimePeriodTreeDef)null);
    }

    public void addTreeDefItem(GeologicTimePeriodTreeDefItem item) {
        this.treeDefItems.add(item);
        item.setTreeDef(this);
    }

    public void removeTreeDefItem(GeologicTimePeriodTreeDefItem item) {
        this.treeDefItems.remove(item);
        item.setTreeDef((GeologicTimePeriodTreeDef)null);
    }

    @Override
    @Transient
    public Class<GeologicTimePeriod> getNodeClass() {
        return GeologicTimePeriod.class;
    }

    @Override
    public GeologicTimePeriodTreeDefItem getDefItemByRank(Integer rank) {
        for (GeologicTimePeriodTreeDefItem item : this.treeDefItems) {
            if (!item.getRankId().equals(rank)) continue;
            return item;
        }
        return null;
    }

    public boolean canChildBeReparentedToNode(GeologicTimePeriod child, GeologicTimePeriod newParent) {
        if (newParent.getRankId() >= child.getRankId()) {
            return false;
        }
        Integer nextEnforcedRank = this.getRankOfNextHighestEnforcedLevel(child);
        if (nextEnforcedRank == null) {
            return true;
        }
        return nextEnforcedRank <= newParent.getRankId();
    }

    public Integer getRankOfNextHighestEnforcedLevel(GeologicTimePeriod node) {
        GeologicTimePeriodTreeDefItem defItem = node.getDefinitionItem();
        while (defItem.getParent() != null) {
            if ((defItem = defItem.getParent()).getIsEnforced() == null || !defItem.getIsEnforced().booleanValue()) continue;
            return defItem.getRankId();
        }
        return null;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return Discipline.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        Vector<Object> ids = BasicSQLUtils.querySingleCol("SELECT DisciplineID FROM discipline WHERE GeologicTimePeriodTreeDefID = " + this.geologicTimePeriodTreeDefId);
        if (ids.size() == 1) {
            return (Integer)ids.get(0);
        }
        return null;
    }

    @Override
    @Transient
    public int getTableId() {
        return GeologicTimePeriodTreeDef.getClassTableId();
    }

    public static int getClassTableId() {
        return 47;
    }

    @Override
    public String toString() {
        return this.getIdentityTitle();
    }

    @Override
    @Transient
    public List<TreeDefItemStandardEntry> getStandardLevels() {
        LinkedList<TreeDefItemStandardEntry> result = new LinkedList<TreeDefItemStandardEntry>();
        result.add(new TreeDefItemStandardEntry("GeologicTimePeriodTreeDef.Era", 100));
        result.add(new TreeDefItemStandardEntry("GeologicTimePeriodTreeDef.Period", 200));
        result.add(new TreeDefItemStandardEntry("GeologicTimePeriodTreeDef.Epoch", 300));
        result.add(new TreeDefItemStandardEntry("GeologicTimePeriodTreeDef.Age", 400));
        return result;
    }
}

