/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.GeologicTimePeriodTreeDef;
import edu.ku.brc.specify.datamodel.GeologicTimePeriodTreeDefItem;
import edu.ku.brc.specify.datamodel.PaleoContext;
import edu.ku.brc.specify.datamodel.Treeable;
import edu.ku.brc.specify.treeutils.GeologicTimePeriodComparator;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="geologictimeperiod")
@Table(appliesTo="geologictimeperiod", indexes={@Index(name="GTPNameIDX", columnNames={"Name"}), @Index(name="GTPFullNameIDX", columnNames={"FullName"}), @Index(name="GTPGuidIDX", columnNames={"GUID"})})
public class GeologicTimePeriod
extends DataModelObjBase
implements Serializable,
Treeable<GeologicTimePeriod, GeologicTimePeriodTreeDef, GeologicTimePeriodTreeDefItem> {
    protected static final Logger log = Logger.getLogger(GeologicTimePeriod.class);
    protected Integer geologicTimePeriodId;
    protected Integer rankId;
    protected String name;
    protected String fullName;
    protected String remarks;
    protected String guid;
    protected Integer nodeNumber;
    protected Integer highestChildNodeNumber;
    protected String standard;
    protected Float startPeriod;
    protected Float startUncertainty;
    protected Float endPeriod;
    protected Float endUncertainty;
    protected String text1;
    protected String text2;
    protected Boolean isBioStrat;
    protected GeologicTimePeriodTreeDef definition;
    protected GeologicTimePeriodTreeDefItem definitionItem;
    protected GeologicTimePeriod parent;
    protected Set<GeologicTimePeriod> children;
    protected Set<PaleoContext> bioStratsPaleoContext;
    protected Set<PaleoContext> chronosStratsPaleoContext;
    protected Boolean isAccepted;
    protected GeologicTimePeriod acceptedGeologicTimePeriod;
    protected Set<GeologicTimePeriod> acceptedChildren;

    public GeologicTimePeriod() {
    }

    public GeologicTimePeriod(Integer geologicTimePeriodId) {
        this.geologicTimePeriodId = geologicTimePeriodId;
    }

    @Override
    public void initialize() {
        super.init();
        this.geologicTimePeriodId = null;
        this.rankId = null;
        this.name = null;
        this.fullName = null;
        this.remarks = null;
        this.guid = null;
        this.nodeNumber = null;
        this.highestChildNodeNumber = null;
        this.standard = null;
        this.startPeriod = null;
        this.startUncertainty = null;
        this.endPeriod = null;
        this.endUncertainty = null;
        this.definition = null;
        this.definitionItem = null;
        this.parent = null;
        this.isBioStrat = false;
        this.text1 = null;
        this.text2 = null;
        this.children = new HashSet<GeologicTimePeriod>();
        this.bioStratsPaleoContext = new HashSet<PaleoContext>();
        this.chronosStratsPaleoContext = new HashSet<PaleoContext>();
        this.isAccepted = true;
        this.acceptedGeologicTimePeriod = null;
        this.acceptedChildren = new HashSet<GeologicTimePeriod>();
    }

    @Id
    @GeneratedValue
    @Column(name="GeologicTimePeriodID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getGeologicTimePeriodId() {
        return this.geologicTimePeriodId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.geologicTimePeriodId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return GeologicTimePeriod.class;
    }

    public void setGeologicTimePeriodId(Integer geologicTimePeriodId) {
        this.geologicTimePeriodId = geologicTimePeriodId;
    }

    @Override
    @Column(name="RankID", nullable=false)
    public Integer getRankId() {
        return this.rankId;
    }

    @Override
    public void setRankId(Integer rankId) {
        this.rankId = rankId;
    }

    @Override
    @Column(name="Name", nullable=false, length=64)
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Column(name="FullName", length=255)
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @Override
    @Column(name="NodeNumber")
    public Integer getNodeNumber() {
        return this.nodeNumber;
    }

    @Override
    public void setNodeNumber(Integer nodeNumber) {
        this.nodeNumber = nodeNumber;
    }

    @Override
    @Column(name="HighestChildNodeNumber")
    public Integer getHighestChildNodeNumber() {
        return this.highestChildNodeNumber;
    }

    @Override
    public void setHighestChildNodeNumber(Integer highestChildNodeNumber) {
        this.highestChildNodeNumber = highestChildNodeNumber;
    }

    @Column(name="Standard", length=64)
    public String getStandard() {
        return this.standard;
    }

    public void setStandard(String standard) {
        this.standard = standard;
    }

    @Column(name="EndPeriod")
    public Float getEndPeriod() {
        return this.endPeriod;
    }

    public void setEndPeriod(Float end) {
        this.endPeriod = end;
    }

    @Column(name="EndUncertainty")
    public Float getEndUncertainty() {
        return this.endUncertainty;
    }

    public void setEndUncertainty(Float endUncertainty) {
        this.endUncertainty = endUncertainty;
    }

    @Column(name="StartPeriod")
    public Float getStartPeriod() {
        return this.startPeriod;
    }

    public void setStartPeriod(Float start) {
        this.startPeriod = start;
    }

    @Column(name="StartUncertainty")
    public Float getStartUncertainty() {
        return this.startUncertainty;
    }

    public void setStartUncertainty(Float startUncertainty) {
        this.startUncertainty = startUncertainty;
    }

    @Override
    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    @Override
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Column(name="GUID", length=128)
    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    @Column(name="Text1", length=128)
    public String getText1() {
        return this.text1;
    }

    public void setText1(String text1) {
        this.text1 = text1;
    }

    @Column(name="Text2", length=128)
    public String getText2() {
        return this.text2;
    }

    public void setText2(String text2) {
        this.text2 = text2;
    }

    @Override
    @Column(name="IsAccepted")
    public Boolean getIsAccepted() {
        return this.isAccepted;
    }

    @Override
    public void setIsAccepted(Boolean accepted) {
        this.isAccepted = accepted;
    }

    @Column(name="IsBioStrat")
    public Boolean getIsBioStrat() {
        return this.isBioStrat == null ? false : this.isBioStrat;
    }

    public void setIsBioStrat(Boolean isBioStrat) {
        this.isBioStrat = isBioStrat;
    }

    @Override
    @OneToMany(fetch=FetchType.EAGER, mappedBy="acceptedGeologicTimePeriod")
    @Cascade(value={CascadeType.SAVE_UPDATE, CascadeType.MERGE, CascadeType.LOCK})
    public Set<GeologicTimePeriod> getAcceptedChildren() {
        return this.acceptedChildren;
    }

    @Override
    public void setAcceptedChildren(Set<GeologicTimePeriod> acceptedChildren) {
        this.acceptedChildren = acceptedChildren;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="AcceptedID")
    public GeologicTimePeriod getAcceptedGeologicTimePeriod() {
        return this.acceptedGeologicTimePeriod;
    }

    public void setAcceptedGeologicTimePeriod(GeologicTimePeriod acceptedGeologicTimePeriod) {
        this.acceptedGeologicTimePeriod = acceptedGeologicTimePeriod;
    }

    @Override
    @Transient
    public GeologicTimePeriod getAcceptedParent() {
        return this.getAcceptedGeologicTimePeriod();
    }

    @Override
    public void setAcceptedParent(GeologicTimePeriod acceptedParent) {
        this.setAcceptedGeologicTimePeriod(acceptedParent);
    }

    @Override
    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="GeologicTimePeriodTreeDefID", nullable=false)
    public GeologicTimePeriodTreeDef getDefinition() {
        return this.definition;
    }

    @Override
    public void setDefinition(GeologicTimePeriodTreeDef definition) {
        this.definition = definition;
    }

    @Override
    @ManyToOne(cascade={}, fetch=FetchType.EAGER)
    @JoinColumn(name="GeologicTimePeriodTreeDefItemID", nullable=false)
    public GeologicTimePeriodTreeDefItem getDefinitionItem() {
        return this.definitionItem;
    }

    @Override
    public void setDefinitionItem(GeologicTimePeriodTreeDefItem definitionItem) {
        this.definitionItem = definitionItem;
        if (definitionItem != null && definitionItem.getRankId() != null) {
            this.rankId = this.definitionItem.getRankId();
        }
    }

    @Override
    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="ParentID")
    public GeologicTimePeriod getParent() {
        return this.parent;
    }

    @Override
    public void setParent(GeologicTimePeriod parent) {
        this.parent = parent;
    }

    @Override
    @OneToMany(mappedBy="parent")
    @Cascade(value={CascadeType.ALL})
    public Set<GeologicTimePeriod> getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(Set<GeologicTimePeriod> children) {
        this.children = children;
    }

    @OneToMany(mappedBy="bioStrat")
    @Cascade(value={CascadeType.ALL})
    public Set<PaleoContext> getBioStratsPaleoContext() {
        return this.bioStratsPaleoContext;
    }

    public void setBioStratsPaleoContext(Set<PaleoContext> bioStratsPaleoContext) {
        this.bioStratsPaleoContext = bioStratsPaleoContext;
    }

    @OneToMany(mappedBy="chronosStrat")
    @Cascade(value={CascadeType.ALL})
    public Set<PaleoContext> getChronosStratsPaleoContext() {
        return this.chronosStratsPaleoContext;
    }

    public void setChronosStratsPaleoContext(Set<PaleoContext> chronosStratsPaleoContext) {
        this.chronosStratsPaleoContext = chronosStratsPaleoContext;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return GeologicTimePeriod.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.parent != null ? this.parent.getId() : null;
    }

    @Override
    @Transient
    public Integer getTreeId() {
        return this.getGeologicTimePeriodId();
    }

    @Override
    public void setTreeId(Integer id) {
        this.setGeologicTimePeriodId(id);
    }

    @Override
    public void addChild(GeologicTimePeriod child) {
        GeologicTimePeriod oldParent = child.getParent();
        if (oldParent != null) {
            oldParent.removeChild(child);
        }
        this.children.add(child);
        child.setParent(this);
    }

    @Override
    public void removeChild(GeologicTimePeriod child) {
        this.children.remove(child);
        child.setParent((GeologicTimePeriod)null);
    }

    @Override
    public String toString() {
        return this.fullName != null ? this.fullName : super.toString();
    }

    @Override
    @Transient
    public int getFullNameDirection() {
        return this.definition.getFullNameDirection();
    }

    @Override
    @Transient
    public String getFullNameSeparator() {
        return this.definitionItem.getFullNameSeparator();
    }

    public String fixFullName() {
        Vector<GeologicTimePeriod> parts = new Vector<GeologicTimePeriod>();
        parts.add(this);
        GeologicTimePeriod node = this.getParent();
        while (node != null) {
            Boolean include = node.getDefinitionItem().getIsInFullName();
            if (include != null && include.booleanValue()) {
                parts.add(node);
            }
            node = node.getParent();
        }
        int direction = this.getFullNameDirection();
        StringBuilder fullNameBuilder = new StringBuilder(parts.size() * 10);
        switch (direction) {
            case 1: {
                int j = parts.size() - 1;
                while (j > -1) {
                    GeologicTimePeriod part = (GeologicTimePeriod)parts.get(j);
                    String before = part.getDefinitionItem().getTextBefore();
                    String after = part.getDefinitionItem().getTextAfter();
                    if (before != null) {
                        fullNameBuilder.append(part.getDefinitionItem().getTextBefore());
                    }
                    fullNameBuilder.append(part.getName());
                    if (after != null) {
                        fullNameBuilder.append(part.getDefinitionItem().getTextAfter());
                    }
                    if (j != parts.size() - 1) {
                        fullNameBuilder.append(((GeologicTimePeriod)parts.get(j)).getFullNameSeparator());
                    }
                    --j;
                }
                break;
            }
            case -1: {
                int j = 0;
                while (j < parts.size()) {
                    GeologicTimePeriod part = (GeologicTimePeriod)parts.get(j);
                    String before = part.getDefinitionItem().getTextBefore();
                    String after = part.getDefinitionItem().getTextAfter();
                    if (before != null) {
                        fullNameBuilder.append(part.getDefinitionItem().getTextBefore());
                    }
                    fullNameBuilder.append(part.getName());
                    if (after != null) {
                        fullNameBuilder.append(part.getDefinitionItem().getTextAfter());
                    }
                    if (j != parts.size() - 1) {
                        fullNameBuilder.append(((GeologicTimePeriod)parts.get(j)).getFullNameSeparator());
                    }
                    ++j;
                }
                break;
            }
            default: {
                log.error((Object)"Invalid tree walk direction (for creating fullname field) found in tree definition");
                return null;
            }
        }
        return fullNameBuilder.toString().trim();
    }

    @Override
    @Transient
    public int getDescendantCount() {
        int totalDescendants = 0;
        for (GeologicTimePeriod child : this.getChildren()) {
            totalDescendants += 1 + child.getDescendantCount();
        }
        return totalDescendants;
    }

    @Override
    public boolean childrenAllowed() {
        return this.definitionItem != null && this.definitionItem.getChild() != null;
    }

    @Override
    @Transient
    public List<GeologicTimePeriod> getAllDescendants() {
        Vector<GeologicTimePeriod> descendants = new Vector<GeologicTimePeriod>();
        for (GeologicTimePeriod child : this.getChildren()) {
            descendants.add(child);
            descendants.addAll(child.getAllDescendants());
        }
        return descendants;
    }

    @Override
    @Transient
    public List<GeologicTimePeriod> getAllAncestors() {
        Vector<GeologicTimePeriod> ancestors = new Vector<GeologicTimePeriod>();
        GeologicTimePeriod parentNode = this.parent;
        while (parentNode != null) {
            ancestors.add(0, parentNode);
            parentNode = parentNode.getParent();
        }
        return ancestors;
    }

    @Override
    public boolean isDescendantOf(GeologicTimePeriod node) {
        if (node == null) {
            throw new NullPointerException();
        }
        GeologicTimePeriod i = this.getParent();
        while (i != null) {
            if (i.getId() == this.getId()) {
                return true;
            }
            i = i.getParent();
        }
        return false;
    }

    @Override
    @Transient
    public Comparator<? super GeologicTimePeriod> getComparator() {
        return new GeologicTimePeriodComparator();
    }

    @Override
    @Transient
    public int getTableId() {
        return GeologicTimePeriod.getClassTableId();
    }

    public static int getClassTableId() {
        return 46;
    }
}

