/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.Geography;
import edu.ku.brc.specify.datamodel.GeographyTreeDef;
import edu.ku.brc.specify.datamodel.TreeDefItemIface;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Proxy;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@Table(name="geographytreedefitem")
public class GeographyTreeDefItem
extends DataModelObjBase
implements Serializable,
TreeDefItemIface<Geography, GeographyTreeDef, GeographyTreeDefItem> {
    protected Integer geographyTreeDefItemId;
    protected String name;
    protected String title;
    protected String remarks;
    protected Integer rankId;
    protected Boolean isEnforced;
    protected Boolean isInFullName;
    protected String textBefore;
    protected String textAfter;
    protected String fullNameSeparator;
    protected GeographyTreeDef treeDef;
    protected GeographyTreeDefItem parent;
    protected Set<Geography> treeEntries;
    protected Set<GeographyTreeDefItem> children;

    public GeographyTreeDefItem() {
    }

    public GeographyTreeDefItem(Integer geographyTreeDefItemId) {
        this.geographyTreeDefItemId = geographyTreeDefItemId;
    }

    @Override
    public void initialize() {
        super.init();
        this.geographyTreeDefItemId = null;
        this.name = null;
        this.title = null;
        this.remarks = null;
        this.rankId = null;
        this.isEnforced = null;
        this.isInFullName = null;
        this.textBefore = null;
        this.textAfter = null;
        this.fullNameSeparator = ", ";
        this.treeDef = null;
        this.treeEntries = new HashSet<Geography>();
        this.parent = null;
        this.children = new HashSet<GeographyTreeDefItem>();
    }

    @Id
    @GeneratedValue
    @Column(name="GeographyTreeDefItemID", unique=false, nullable=false, insertable=true, updatable=true, length=10)
    public Integer getGeographyTreeDefItemId() {
        return this.geographyTreeDefItemId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.geographyTreeDefItemId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return GeographyTreeDefItem.class;
    }

    public void setGeographyTreeDefItemId(Integer geographyTreeDefItemId) {
        this.geographyTreeDefItemId = geographyTreeDefItemId;
    }

    @Override
    @Column(name="Name", nullable=false, length=64)
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Column(name="Title", nullable=true, length=64)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    @Transient
    public String getDisplayText() {
        return this.title != null ? this.title : this.name;
    }

    @Override
    public void setDisplayText(String text) {
        this.setTitle(text);
    }

    @Override
    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    @Override
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Override
    @Column(name="RankID", nullable=false)
    public Integer getRankId() {
        return this.rankId;
    }

    @Override
    public void setRankId(Integer rankId) {
        this.rankId = rankId;
    }

    @Override
    @Column(name="IsEnforced", unique=false, nullable=true, insertable=true, updatable=true)
    public Boolean getIsEnforced() {
        return this.isEnforced;
    }

    @Override
    public void setIsEnforced(Boolean isEnforced) {
        this.isEnforced = isEnforced;
    }

    @Override
    @Column(name="IsInFullName", unique=false, nullable=true, insertable=true, updatable=true)
    public Boolean getIsInFullName() {
        return this.isInFullName;
    }

    @Override
    public void setIsInFullName(Boolean isInFullName) {
        this.isInFullName = isInFullName;
    }

    @Override
    @Column(name="TextAfter", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getTextAfter() {
        return this.textAfter;
    }

    @Override
    public void setTextAfter(String textAfter) {
        this.textAfter = textAfter;
    }

    @Override
    @Column(name="TextBefore", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getTextBefore() {
        return this.textBefore;
    }

    @Override
    public void setTextBefore(String textBefore) {
        this.textBefore = textBefore;
    }

    @Override
    @Column(name="FullNameSeparator", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getFullNameSeparator() {
        return this.fullNameSeparator;
    }

    @Override
    public void setFullNameSeparator(String fullNameSeparator) {
        this.fullNameSeparator = fullNameSeparator;
    }

    @Override
    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="GeographyTreeDefID", unique=false, nullable=false, insertable=true, updatable=true)
    public GeographyTreeDef getTreeDef() {
        return this.treeDef;
    }

    @Override
    public void setTreeDef(GeographyTreeDef treeDef) {
        this.treeDef = treeDef;
    }

    @Override
    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="ParentItemID", unique=false, nullable=true, insertable=true, updatable=true)
    public GeographyTreeDefItem getParent() {
        return this.parent;
    }

    @Override
    public void setParent(GeographyTreeDefItem parent) {
        this.parent = parent;
    }

    @Override
    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="definitionItem")
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.LOCK})
    public Set<Geography> getTreeEntries() {
        return this.treeEntries;
    }

    @Override
    public void setTreeEntries(Set<Geography> treeEntries) {
        this.treeEntries = treeEntries;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, mappedBy="parent")
    public Set<GeographyTreeDefItem> getChildren() {
        return this.children;
    }

    public void setChildren(Set<GeographyTreeDefItem> children) {
        this.children = children;
    }

    @Override
    @Transient
    public Integer getTreeDefItemId() {
        return this.getGeographyTreeDefItemId();
    }

    @Override
    public void setTreeDefItemId(Integer id) {
        this.setGeographyTreeDefItemId(id);
    }

    @Override
    public void setChild(GeographyTreeDefItem child) {
        if (!this.children.isEmpty()) {
            GeographyTreeDefItem currentChild = this.children.iterator().next();
            currentChild.setParent((GeographyTreeDefItem)null);
        }
        this.children.clear();
        if (child != null) {
            this.children.add(child);
        }
    }

    @Override
    @Transient
    public GeographyTreeDefItem getChild() {
        if (this.children.isEmpty()) {
            return null;
        }
        return this.children.iterator().next();
    }

    public void addTreeEntry(Geography entry) {
        this.treeEntries.add(entry);
        entry.setDefinitionItem(this);
    }

    public void removeTreeEntry(Geography entry) {
        this.treeEntries.remove(entry);
        entry.setDefinitionItem((GeographyTreeDefItem)null);
    }

    public void removeChild(GeographyTreeDefItem child) {
        this.children.remove(child);
        child.setParent((GeographyTreeDefItem)null);
    }

    @Override
    public boolean canBeDeleted() {
        return this.treeEntries.isEmpty();
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return GeographyTreeDef.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.parent != null ? this.parent.getId() : null;
    }

    @Override
    @Transient
    public int getTableId() {
        return GeographyTreeDefItem.getClassTableId();
    }

    public static int getClassTableId() {
        return 45;
    }

    @Override
    public boolean hasTreeEntries() {
        if (this.getId() == null) {
            return false;
        }
        String sql = "select distinct GeographyTreeDefItemID from geography where GeographyTreeDefItemID = " + this.getId();
        return BasicSQLUtils.getNumRecords(sql) > 0;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GeographyTreeDefItem) {
            GeographyTreeDefItem item = (GeographyTreeDefItem)obj;
            if (item.geographyTreeDefItemId != null) {
                return item.geographyTreeDefItemId.equals(this.geographyTreeDefItemId);
            }
            return super.equals(obj);
        }
        return false;
    }
}

