/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.BaseTreeDef;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Geography;
import edu.ku.brc.specify.datamodel.GeographyTreeDefItem;
import edu.ku.brc.specify.datamodel.TreeDefItemStandardEntry;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Proxy;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@Table(name="geographytreedef")
public class GeographyTreeDef
extends BaseTreeDef<Geography, GeographyTreeDef, GeographyTreeDefItem>
implements Serializable {
    protected Integer geographyTreeDefId;
    protected String name;
    protected String remarks;
    protected Integer fullNameDirection;
    protected Set<Discipline> disciplines;
    protected Set<Geography> treeEntries;
    protected Set<GeographyTreeDefItem> treeDefItems;

    public GeographyTreeDef() {
    }

    public GeographyTreeDef(Integer geographyTreeDefId) {
        this.geographyTreeDefId = geographyTreeDefId;
    }

    @Override
    public void initialize() {
        super.init();
        this.geographyTreeDefId = null;
        this.name = null;
        this.remarks = null;
        this.fullNameDirection = null;
        this.disciplines = new HashSet<Discipline>();
        this.treeEntries = new HashSet<Geography>();
        this.treeDefItems = new HashSet<GeographyTreeDefItem>();
    }

    @Id
    @GeneratedValue
    @Column(name="GeographyTreeDefID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getGeographyTreeDefId() {
        return this.geographyTreeDefId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.geographyTreeDefId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return GeographyTreeDef.class;
    }

    public void setGeographyTreeDefId(Integer geographyTreeDefId) {
        this.geographyTreeDefId = geographyTreeDefId;
    }

    @Override
    @Column(name="Name", nullable=false, length=64)
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    @Override
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Override
    @Column(name="FullNameDirection", unique=false, nullable=true, insertable=true, updatable=true)
    public Integer getFullNameDirection() {
        return this.fullNameDirection;
    }

    @Override
    public void setFullNameDirection(Integer fullNameDirection) {
        this.fullNameDirection = fullNameDirection;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="geographyTreeDef")
    public Set<Discipline> getDisciplines() {
        return this.disciplines;
    }

    public void setDisciplines(Set<Discipline> disciplines) {
        this.disciplines = disciplines;
    }

    public void addDiscipline(Discipline ct) {
        this.disciplines.add(ct);
        ct.setGeographyTreeDef(this);
    }

    public void removeDiscipline(Discipline ct) {
        this.disciplines.remove(ct);
        ct.setGeographyTreeDef(null);
    }

    @Override
    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="definition")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<Geography> getTreeEntries() {
        return this.treeEntries;
    }

    @Override
    public void setTreeEntries(Set<Geography> treeEntries) {
        this.treeEntries = treeEntries;
    }

    @Override
    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="treeDef")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<GeographyTreeDefItem> getTreeDefItems() {
        return this.treeDefItems;
    }

    @Override
    public void setTreeDefItems(Set<GeographyTreeDefItem> treeDefItems) {
        this.treeDefItems = treeDefItems;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return Discipline.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        Vector<Object> ids = BasicSQLUtils.querySingleCol("SELECT DisciplineID FROM discipline WHERE GeographyTreeDefID = " + this.geographyTreeDefId);
        if (ids.size() == 1) {
            return (Integer)ids.get(0);
        }
        return null;
    }

    @Override
    @Transient
    public Integer getTreeDefId() {
        return this.getGeographyTreeDefId();
    }

    @Override
    public void setTreeDefId(Integer id) {
        this.setGeographyTreeDefId(id);
    }

    public void addTreeEntry(Geography taxon) {
        this.treeEntries.add(taxon);
        taxon.setDefinition(this);
    }

    public void removeTreeEntry(Geography taxon) {
        this.treeEntries.remove(taxon);
        taxon.setDefinition((GeographyTreeDef)null);
    }

    public void addTreeDefItem(GeographyTreeDefItem item) {
        this.treeDefItems.add(item);
        item.setTreeDef(this);
    }

    public void removeTreeDefItem(GeographyTreeDefItem item) {
        this.treeDefItems.remove(item);
        item.setTreeDef((GeographyTreeDef)null);
    }

    @Override
    @Transient
    public Class<Geography> getNodeClass() {
        return Geography.class;
    }

    @Override
    public GeographyTreeDefItem getDefItemByRank(Integer rank) {
        for (GeographyTreeDefItem item : this.treeDefItems) {
            if (!item.getRankId().equals(rank)) continue;
            return item;
        }
        return null;
    }

    @Override
    @Transient
    public int getSynonymizedLevel() {
        return 1;
    }

    public static boolean isStdRequiredLevel(int levelRank) {
        return levelRank == 100 || levelRank == 200 || levelRank == 300 || levelRank == 400;
    }

    public boolean canChildBeReparentedToNode(Geography child, Geography newParent) {
        if (newParent.getRankId() >= child.getRankId()) {
            return false;
        }
        Integer nextEnforcedRank = this.getRankOfNextHighestEnforcedLevel(child);
        if (nextEnforcedRank == null) {
            return true;
        }
        return nextEnforcedRank <= newParent.getRankId();
    }

    public Integer getRankOfNextHighestEnforcedLevel(Geography node) {
        GeographyTreeDefItem defItem = node.getDefinitionItem();
        while (defItem.getParent() != null) {
            if ((defItem = defItem.getParent()).getIsEnforced() == null || !defItem.getIsEnforced().booleanValue()) continue;
            return defItem.getRankId();
        }
        return null;
    }

    @Override
    @Transient
    public int getTableId() {
        return GeographyTreeDef.getClassTableId();
    }

    public static int getClassTableId() {
        return 44;
    }

    @Override
    public String toString() {
        return this.getIdentityTitle();
    }

    @Override
    @Transient
    public int getRankIncrement() {
        return 100;
    }

    @Override
    @Transient
    public List<TreeDefItemStandardEntry> getStandardLevels() {
        LinkedList<TreeDefItemStandardEntry> result = new LinkedList<TreeDefItemStandardEntry>();
        result.add(new TreeDefItemStandardEntry("Continent", 100));
        result.add(new TreeDefItemStandardEntry("Country", 200));
        result.add(new TreeDefItemStandardEntry("State", 300));
        result.add(new TreeDefItemStandardEntry("County", 400));
        return result;
    }

    @Override
    @Transient
    public boolean isSynonymySupported() {
        return true;
    }
}

