/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.GeographyTreeDef;
import edu.ku.brc.specify.datamodel.GeographyTreeDefItem;
import edu.ku.brc.specify.datamodel.Locality;
import edu.ku.brc.specify.datamodel.Treeable;
import edu.ku.brc.specify.treeutils.TreeOrderSiblingComparator;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="geography")
@Table(appliesTo="geography", indexes={@Index(name="GeoNameIDX", columnNames={"Name"}), @Index(name="GeoFullNameIDX", columnNames={"FullName"})})
public class Geography
extends DataModelObjBase
implements Serializable,
Treeable<Geography, GeographyTreeDef, GeographyTreeDefItem> {
    protected static final Logger log = Logger.getLogger(Geography.class);
    protected Integer geographyId;
    protected String name;
    protected String remarks;
    protected String commonName;
    protected String fullName;
    protected String geographyCode;
    protected Integer rankId;
    protected Integer nodeNumber;
    protected Integer highestChildNodeNumber;
    protected String abbrev;
    protected BigDecimal centroidLat;
    protected BigDecimal centroidLon;
    protected String gml;
    protected String text1;
    protected String text2;
    protected Integer number1;
    protected Integer number2;
    protected Date timestampVersion;
    protected Boolean isCurrent;
    protected String guid;
    protected Set<Locality> localities;
    protected GeographyTreeDef definition;
    protected GeographyTreeDefItem definitionItem;
    protected Geography parent;
    protected Set<Geography> children;
    protected Boolean isAccepted;
    protected Geography acceptedGeography;
    protected Set<Geography> acceptedChildren;

    public Geography() {
    }

    public Geography(Integer geographyId) {
        this.geographyId = geographyId;
    }

    @Override
    public void initialize() {
        super.init();
        this.geographyId = null;
        this.name = null;
        this.fullName = null;
        this.remarks = null;
        this.commonName = null;
        this.geographyCode = null;
        this.rankId = null;
        this.nodeNumber = null;
        this.highestChildNodeNumber = null;
        this.isAccepted = true;
        this.abbrev = null;
        this.text1 = null;
        this.text2 = null;
        this.number1 = null;
        this.number2 = null;
        this.timestampVersion = null;
        this.isCurrent = null;
        this.guid = null;
        this.localities = new HashSet<Locality>();
        this.definition = null;
        this.definitionItem = null;
        this.parent = null;
        this.children = new HashSet<Geography>();
        this.isAccepted = true;
        this.acceptedGeography = null;
        this.acceptedChildren = new HashSet<Geography>();
    }

    @Id
    @GeneratedValue
    @Column(name="GeographyID")
    public Integer getGeographyId() {
        return this.geographyId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.geographyId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return Geography.class;
    }

    public void setGeographyId(Integer geographyId) {
        this.geographyId = geographyId;
    }

    @Override
    @Column(name="Name", nullable=false, length=64)
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    @Override
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Column(name="CommonName", length=128)
    public String getCommonName() {
        return this.commonName;
    }

    public void setCommonName(String commonName) {
        this.commonName = commonName;
    }

    @Override
    @Column(name="FullName", length=255)
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @Column(name="GeographyCode", length=8)
    public String getGeographyCode() {
        return this.geographyCode;
    }

    public void setGeographyCode(String geographyCode) {
        this.geographyCode = geographyCode;
    }

    @Override
    @Column(name="RankID", nullable=false)
    public Integer getRankId() {
        return this.rankId;
    }

    @Override
    public void setRankId(Integer rankId) {
        this.rankId = rankId;
    }

    @Override
    @Column(name="NodeNumber")
    public Integer getNodeNumber() {
        return this.nodeNumber;
    }

    @Override
    public void setNodeNumber(Integer nodeNumber) {
        this.nodeNumber = nodeNumber;
    }

    @Override
    @Column(name="HighestChildNodeNumber")
    public Integer getHighestChildNodeNumber() {
        return this.highestChildNodeNumber;
    }

    @Override
    public void setHighestChildNodeNumber(Integer highestChildNodeNumber) {
        this.highestChildNodeNumber = highestChildNodeNumber;
    }

    @Column(name="Abbrev", length=16)
    public String getAbbrev() {
        return this.abbrev;
    }

    public void setAbbrev(String abbrev) {
        this.abbrev = abbrev;
    }

    @Column(name="CentroidLat")
    public BigDecimal getCentroidLat() {
        return this.centroidLat;
    }

    public void setCentroidLat(BigDecimal centroidLat) {
        this.centroidLat = centroidLat;
    }

    @Column(name="CentroidLon")
    public BigDecimal getCentroidLon() {
        return this.centroidLon;
    }

    public void setCentroidLon(BigDecimal centroidLon) {
        this.centroidLon = centroidLon;
    }

    @Lob
    @Column(name="GML", length=4096)
    public String getGml() {
        return this.gml;
    }

    public void setGml(String gml) {
        this.gml = gml;
    }

    @Column(name="Text1", length=32)
    public String getText1() {
        return this.text1;
    }

    public void setText1(String text1) {
        this.text1 = text1;
    }

    @Column(name="Text2", length=32)
    public String getText2() {
        return this.text2;
    }

    public void setText2(String text2) {
        this.text2 = text2;
    }

    @Column(name="Number1")
    public Integer getNumber1() {
        return this.number1;
    }

    public void setNumber1(Integer number1) {
        this.number1 = number1;
    }

    @Column(name="Number2")
    public Integer getNumber2() {
        return this.number2;
    }

    public void setNumber2(Integer number2) {
        this.number2 = number2;
    }

    @Column(name="TimestampVersion")
    public Date getTimestampVersion() {
        return this.timestampVersion;
    }

    public void setTimestampVersion(Date timestampVersion) {
        this.timestampVersion = timestampVersion;
    }

    @Column(name="IsCurrent")
    public Boolean getIsCurrent() {
        return this.isCurrent;
    }

    public void setIsCurrent(Boolean isCurrent) {
        this.isCurrent = isCurrent;
    }

    @Override
    @Column(name="IsAccepted")
    public Boolean getIsAccepted() {
        return this.isAccepted;
    }

    @Override
    public void setIsAccepted(Boolean accepted) {
        this.isAccepted = accepted;
    }

    @Override
    @OneToMany(fetch=FetchType.EAGER, mappedBy="acceptedGeography")
    @Cascade(value={CascadeType.SAVE_UPDATE, CascadeType.MERGE, CascadeType.LOCK})
    public Set<Geography> getAcceptedChildren() {
        return this.acceptedChildren;
    }

    @Override
    public void setAcceptedChildren(Set<Geography> acceptedChildren) {
        this.acceptedChildren = acceptedChildren;
    }

    @Column(name="GUID", unique=false, nullable=true, insertable=true, updatable=true, length=128)
    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="AcceptedID")
    public Geography getAcceptedGeography() {
        return this.acceptedGeography;
    }

    public void setAcceptedGeography(Geography acceptedGeography) {
        this.acceptedGeography = acceptedGeography;
    }

    @Override
    @Transient
    public Geography getAcceptedParent() {
        return this.getAcceptedGeography();
    }

    @Override
    public void setAcceptedParent(Geography acceptedParent) {
        this.setAcceptedGeography(acceptedParent);
    }

    @OneToMany(mappedBy="geography")
    @Cascade(value={CascadeType.ALL})
    public Set<Locality> getLocalities() {
        return this.localities;
    }

    public void setLocalities(Set<Locality> localities) {
        this.localities = localities;
    }

    @Override
    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="GeographyTreeDefID", nullable=false)
    public GeographyTreeDef getDefinition() {
        return this.definition;
    }

    @Override
    public void setDefinition(GeographyTreeDef definition) {
        this.definition = definition;
    }

    @Override
    @ManyToOne(cascade={}, fetch=FetchType.EAGER)
    @JoinColumn(name="GeographyTreeDefItemID", nullable=false)
    public GeographyTreeDefItem getDefinitionItem() {
        return this.definitionItem;
    }

    @Override
    public void setDefinitionItem(GeographyTreeDefItem definitionItem) {
        this.definitionItem = definitionItem;
        if (definitionItem != null && definitionItem.getRankId() != null) {
            this.rankId = this.definitionItem.getRankId();
        }
    }

    @Override
    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="ParentID")
    public Geography getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Geography parent) {
        this.parent = parent;
    }

    @Override
    @OneToMany(mappedBy="parent")
    @Cascade(value={CascadeType.ALL})
    public Set<Geography> getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(Set<Geography> children) {
        this.children = children;
    }

    @Override
    @Transient
    public Integer getTreeId() {
        return this.getGeographyId();
    }

    @Override
    public void setTreeId(Integer id) {
        this.setGeographyId(id);
    }

    @Override
    public void addChild(Geography child) {
        Geography oldParent = child.getParent();
        if (oldParent != null) {
            oldParent.removeChild(child);
        }
        this.children.add(child);
        child.setParent(this);
    }

    @Override
    public void removeChild(Geography child) {
        this.children.remove(child);
        child.setParent((Geography)null);
    }

    public void addLocality(Locality loc) {
        this.localities.add(loc);
        loc.setGeography(this);
    }

    public void removeLocality(Locality loc) {
        this.localities.remove(loc);
        loc.setGeography(null);
    }

    @Override
    public String toString() {
        return this.fullName != null ? this.fullName : super.toString();
    }

    @Override
    @Transient
    public int getFullNameDirection() {
        Integer dir = this.definition.getFullNameDirection();
        if (dir == null || dir != 1) {
            dir = -1;
        }
        return dir;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return Geography.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.parent != null ? this.parent.getId() : null;
    }

    @Override
    @Transient
    public String getFullNameSeparator() {
        return this.definitionItem.getFullNameSeparator();
    }

    public String fixFullName() {
        Vector<Geography> parts = new Vector<Geography>();
        parts.add(this);
        Geography node = this.getParent();
        while (node != null) {
            Boolean include = node.getDefinitionItem().getIsInFullName();
            if (include != null && include.booleanValue()) {
                parts.add(node);
            }
            node = node.getParent();
        }
        int direction = this.getFullNameDirection();
        StringBuilder fullNameBuilder = new StringBuilder(parts.size() * 10);
        switch (direction) {
            case 1: {
                int j = parts.size() - 1;
                while (j > -1) {
                    Geography part = (Geography)parts.get(j);
                    String before = part.getDefinitionItem().getTextBefore();
                    String after = part.getDefinitionItem().getTextAfter();
                    if (before != null) {
                        fullNameBuilder.append(part.getDefinitionItem().getTextBefore());
                    }
                    fullNameBuilder.append(part.getName());
                    if (after != null) {
                        fullNameBuilder.append(part.getDefinitionItem().getTextAfter());
                    }
                    if (j != parts.size() - 1) {
                        fullNameBuilder.append(((Geography)parts.get(j)).getFullNameSeparator());
                    }
                    --j;
                }
                break;
            }
            case -1: {
                int j = 0;
                while (j < parts.size()) {
                    Geography part = (Geography)parts.get(j);
                    String before = part.getDefinitionItem().getTextBefore();
                    String after = part.getDefinitionItem().getTextAfter();
                    if (before != null) {
                        fullNameBuilder.append(part.getDefinitionItem().getTextBefore());
                    }
                    fullNameBuilder.append(part.getName());
                    if (after != null) {
                        fullNameBuilder.append(part.getDefinitionItem().getTextAfter());
                    }
                    if (j != parts.size() - 1) {
                        fullNameBuilder.append(((Geography)parts.get(j)).getFullNameSeparator());
                    }
                    ++j;
                }
                break;
            }
            default: {
                log.error((Object)"Invalid tree walk direction (for creating fullname field) found in tree definition");
                return null;
            }
        }
        return fullNameBuilder.toString().trim();
    }

    @Override
    @Transient
    public int getDescendantCount() {
        int totalDescendants = 0;
        for (Geography child : this.getChildren()) {
            totalDescendants += 1 + child.getDescendantCount();
        }
        return totalDescendants;
    }

    @Override
    public boolean childrenAllowed() {
        return this.definitionItem != null && this.definitionItem.getChild() != null;
    }

    @Override
    @Transient
    public List<Geography> getAllDescendants() {
        Vector<Geography> descendants = new Vector<Geography>();
        for (Geography child : this.getChildren()) {
            descendants.add(child);
            descendants.addAll(child.getAllDescendants());
        }
        return descendants;
    }

    @Override
    @Transient
    public List<Geography> getAllAncestors() {
        Vector<Geography> ancestors = new Vector<Geography>();
        Geography parentNode = this.parent;
        while (parentNode != null) {
            ancestors.add(0, parentNode);
            parentNode = parentNode.getParent();
        }
        return ancestors;
    }

    @Override
    public boolean isDescendantOf(Geography node) {
        if (node == null) {
            throw new NullPointerException();
        }
        Geography i = this.getParent();
        while (i != null) {
            if (i.getId() == this.getId()) {
                return true;
            }
            i = i.getParent();
        }
        return false;
    }

    @Override
    @Transient
    public Comparator<? super Geography> getComparator() {
        return new TreeOrderSiblingComparator();
    }

    @Override
    @Transient
    public int getTableId() {
        return Geography.getClassTableId();
    }

    public static int getClassTableId() {
        return 3;
    }
}

