/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.CollectingTrip;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.util.Orderable;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="fundingagent", uniqueConstraints={@UniqueConstraint(columnNames={"AgentID", "CollectingTripID"})})
@Table(appliesTo="fundingagent", indexes={@Index(name="COLTRIPDivIDX", columnNames={"DivisionID"})})
public class FundingAgent
extends DataModelObjBase
implements Serializable,
Orderable,
Comparable<FundingAgent>,
Cloneable {
    protected Integer fundingAgentId;
    protected Integer orderNumber;
    protected Boolean isPrimary;
    protected String type;
    protected String remarks;
    protected CollectingTrip collectingTrip;
    protected Agent agent;
    protected Division division;

    public FundingAgent() {
    }

    public FundingAgent(Integer fundingAgentId) {
        this.fundingAgentId = fundingAgentId;
    }

    @Override
    public void initialize() {
        super.init();
        this.fundingAgentId = null;
        this.orderNumber = null;
        this.isPrimary = true;
        this.type = null;
        this.remarks = null;
        this.collectingTrip = null;
        this.agent = null;
        this.division = AppContextMgr.getInstance() != null ? AppContextMgr.getInstance().getClassObject(Division.class) : null;
    }

    @Id
    @GeneratedValue
    @Column(name="FundingAgentID")
    public Integer getFundingAgentId() {
        return this.fundingAgentId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.fundingAgentId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return FundingAgent.class;
    }

    public void setFundingAgentId(Integer fundingAgentId) {
        this.fundingAgentId = fundingAgentId;
    }

    @Column(name="OrderNumber", nullable=false)
    public Integer getOrderNumber() {
        return this.orderNumber;
    }

    public void setOrderNumber(Integer orderNumber) {
        this.orderNumber = orderNumber;
    }

    @Column(name="IsPrimary", unique=false, nullable=false, insertable=true, updatable=true)
    public Boolean getIsPrimary() {
        return this.isPrimary;
    }

    public void setIsPrimary(Boolean isPrimary) {
        this.isPrimary = isPrimary;
    }

    @Column(name="Type", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="CollectingTripID", nullable=false)
    public CollectingTrip getCollectingTrip() {
        return this.collectingTrip;
    }

    public void setCollectingTrip(CollectingTrip collectingTrip) {
        this.collectingTrip = collectingTrip;
    }

    @ManyToOne(cascade={}, fetch=FetchType.EAGER)
    @JoinColumn(name="AgentID", nullable=false)
    public Agent getAgent() {
        return this.agent;
    }

    public void setAgent(Agent agent) {
        this.agent = agent;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="DivisionID", unique=false, nullable=true, insertable=true, updatable=true)
    public Division getDivision() {
        return this.division;
    }

    public void setDivision(Division division) {
        this.division = division;
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        String name = "";
        if (this.agent != null) {
            name = this.agent.getIdentityTitle();
        }
        if (StringUtils.isNotEmpty((String)name)) {
            return name;
        }
        return super.getIdentityTitle();
    }

    @Override
    @Transient
    public int getTableId() {
        return FundingAgent.getClassTableId();
    }

    public static int getClassTableId() {
        return 146;
    }

    @Override
    @Transient
    public int getOrderIndex() {
        return this.getOrderNumber();
    }

    @Override
    public void setOrderIndex(int order) {
        this.setOrderNumber(order);
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return CollectingTrip.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.collectingTrip != null ? this.collectingTrip.getId() : null;
    }

    @Override
    public int compareTo(FundingAgent obj) {
        return this.orderNumber != null && obj != null && obj.orderNumber != null ? this.orderNumber.compareTo(obj.orderNumber) : 0;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        FundingAgent obj = (FundingAgent)super.clone();
        obj.setFundingAgentId(null);
        return obj;
    }
}

