/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.AttachmentOwnerIFace;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.DisciplineMember;
import edu.ku.brc.specify.datamodel.FieldNotebookAttachment;
import edu.ku.brc.specify.datamodel.FieldNotebookPageSet;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="fieldnotebook")
@Table(appliesTo="fieldnotebook", indexes={@Index(name="FNBNameIDX", columnNames={"Name"}), @Index(name="FNBStartDateIDX", columnNames={"StartDate"}), @Index(name="FNBEndDateIDX", columnNames={"EndDate"})})
public class FieldNotebook
extends DisciplineMember
implements AttachmentOwnerIFace<FieldNotebookAttachment> {
    protected Integer fieldNotebookId;
    protected String name;
    protected Calendar startDate;
    protected Calendar endDate;
    protected String location;
    protected String description;
    protected Collection collection;
    protected Agent ownerAgent;
    protected Set<FieldNotebookPageSet> pageSets;
    protected Set<FieldNotebookAttachment> attachments;

    @Override
    public void initialize() {
        super.init();
        this.fieldNotebookId = null;
        this.name = null;
        this.startDate = null;
        this.endDate = null;
        this.location = null;
        this.description = null;
        this.collection = null;
        this.ownerAgent = null;
        this.pageSets = new HashSet<FieldNotebookPageSet>();
        this.attachments = new TreeSet<FieldNotebookAttachment>();
        this.collection = AppContextMgr.getInstance().getClassObject(Collection.class);
    }

    public void setFieldNotebookId(Integer fieldNotebookId) {
        this.fieldNotebookId = fieldNotebookId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStartDate(Calendar startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(Calendar endDate) {
        this.endDate = endDate;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setCollection(Collection collection) {
        this.collection = collection;
    }

    public void setOwnerAgent(Agent ownerAgent) {
        this.ownerAgent = ownerAgent;
    }

    public void setPageSets(Set<FieldNotebookPageSet> pageSets) {
        this.pageSets = pageSets;
    }

    @Id
    @GeneratedValue
    @Column(name="FieldNotebookID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getFieldNotebookId() {
        return this.fieldNotebookId;
    }

    @Column(name="Name", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getName() {
        return this.name;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="StartDate", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getStartDate() {
        return this.startDate;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="EndDate", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getEndDate() {
        return this.endDate;
    }

    @Lob
    @Column(name="Description", unique=false, nullable=true, insertable=true, updatable=true, length=2048)
    public String getDescription() {
        return this.description;
    }

    @Column(name="Storage", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getLocation() {
        return this.location;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="AgentID", unique=false, nullable=false, insertable=true, updatable=true)
    public Agent getOwnerAgent() {
        return this.ownerAgent;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="CollectionID", unique=false, nullable=false, insertable=true, updatable=true)
    public Collection getCollection() {
        return this.collection;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="fieldNotebook")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    @OrderBy(value="startDate ASC")
    public Set<FieldNotebookPageSet> getPageSets() {
        return this.pageSets;
    }

    @OneToMany(mappedBy="fieldNotebook")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    @OrderBy(value="ordinal ASC")
    public Set<FieldNotebookAttachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(Set<FieldNotebookAttachment> attachments) {
        this.attachments = attachments;
    }

    @Override
    @Transient
    public Set<FieldNotebookAttachment> getAttachmentReferences() {
        return this.attachments;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return Collection.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.collection != null ? this.collection.getId() : null;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.fieldNotebookId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return FieldNotebook.class;
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        return StringUtils.isNotEmpty((String)this.name) ? this.name : super.getIdentityTitle();
    }

    @Override
    @Transient
    public int getTableId() {
        return FieldNotebook.getClassTableId();
    }

    public static int getClassTableId() {
        return 83;
    }
}

