/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.AddressOfRecord;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.datamodel.ExchangeInPrep;
import java.io.Serializable;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="exchangein")
@Table(appliesTo="exchangein", indexes={@Index(name="ExchangeDateIDX", columnNames={"ExchangeDate"}), @Index(name="DescriptionOfMaterialIDX", columnNames={"DescriptionOfMaterial"})})
public class ExchangeIn
extends DataModelObjBase
implements Serializable {
    protected Integer exchangeInId;
    protected Calendar exchangeDate;
    protected Short quantityExchanged;
    protected String descriptionOfMaterial;
    protected String srcGeography;
    protected String srcTaxonomy;
    protected String remarks;
    protected String text1;
    protected String text2;
    protected Float number1;
    protected Float number2;
    protected Boolean yesNo1;
    protected Boolean yesNo2;
    protected AddressOfRecord addressOfRecord;
    protected Agent agentReceivedFrom;
    protected Agent agentCatalogedBy;
    protected Division division;
    protected Set<ExchangeInPrep> exchangeInPreps;

    public ExchangeIn() {
    }

    public ExchangeIn(Integer exchangeInId) {
        this.exchangeInId = exchangeInId;
    }

    @Override
    public void initialize() {
        super.init();
        this.exchangeInId = null;
        this.exchangeDate = null;
        this.quantityExchanged = null;
        this.descriptionOfMaterial = null;
        this.srcGeography = null;
        this.srcTaxonomy = null;
        this.remarks = null;
        this.text1 = null;
        this.text2 = null;
        this.number1 = null;
        this.number2 = null;
        this.yesNo1 = null;
        this.yesNo2 = null;
        this.agentReceivedFrom = null;
        this.agentCatalogedBy = null;
        this.addressOfRecord = null;
        this.division = null;
        this.exchangeInPreps = new HashSet<ExchangeInPrep>();
    }

    @Id
    @GeneratedValue
    @Column(name="ExchangeInID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getExchangeInId() {
        return this.exchangeInId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.exchangeInId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return ExchangeIn.class;
    }

    public void setExchangeInId(Integer exchangeInId) {
        this.exchangeInId = exchangeInId;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="ExchangeDate", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getExchangeDate() {
        return this.exchangeDate;
    }

    public void setExchangeDate(Calendar exchangeDate) {
        this.exchangeDate = exchangeDate;
    }

    @Column(name="QuantityExchanged", unique=false, nullable=true, insertable=true, updatable=true)
    public Short getQuantityExchanged() {
        return this.quantityExchanged;
    }

    public void setQuantityExchanged(Short quantityExchanged) {
        this.quantityExchanged = quantityExchanged;
    }

    @Column(name="DescriptionOfMaterial", unique=false, nullable=true, insertable=true, updatable=true, length=120)
    public String getDescriptionOfMaterial() {
        return this.descriptionOfMaterial;
    }

    public void setDescriptionOfMaterial(String descriptionOfMaterial) {
        this.descriptionOfMaterial = descriptionOfMaterial;
    }

    @Column(name="SrcGeography", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getSrcGeography() {
        return this.srcGeography;
    }

    public void setSrcGeography(String srcGeography) {
        this.srcGeography = srcGeography;
    }

    @Column(name="SrcTaxonomy", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getSrcTaxonomy() {
        return this.srcTaxonomy;
    }

    public void setSrcTaxonomy(String srcTaxonomy) {
        this.srcTaxonomy = srcTaxonomy;
    }

    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Column(name="Text1", length=300, unique=false, nullable=true, insertable=true, updatable=true)
    public String getText1() {
        return this.text1;
    }

    public void setText1(String text1) {
        this.text1 = text1;
    }

    @Column(name="Text2", length=300, unique=false, nullable=true, insertable=true, updatable=true)
    public String getText2() {
        return this.text2;
    }

    public void setText2(String text2) {
        this.text2 = text2;
    }

    @Column(name="Number1", unique=false, nullable=true, insertable=true, updatable=true, length=24)
    public Float getNumber1() {
        return this.number1;
    }

    public void setNumber1(Float number1) {
        this.number1 = number1;
    }

    @Column(name="Number2", unique=false, nullable=true, insertable=true, updatable=true, length=24)
    public Float getNumber2() {
        return this.number2;
    }

    public void setNumber2(Float number2) {
        this.number2 = number2;
    }

    @Column(name="YesNo1", unique=false, nullable=true, updatable=true, insertable=true)
    public Boolean getYesNo1() {
        return this.yesNo1;
    }

    public void setYesNo1(Boolean yesNo1) {
        this.yesNo1 = yesNo1;
    }

    @Column(name="YesNo2", unique=false, nullable=true, updatable=true, insertable=true)
    public Boolean getYesNo2() {
        return this.yesNo2;
    }

    public void setYesNo2(Boolean yesNo2) {
        this.yesNo2 = yesNo2;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="ReceivedFromOrganizationID", unique=false, nullable=false, insertable=true, updatable=true)
    public Agent getAgentReceivedFrom() {
        return this.agentReceivedFrom;
    }

    public void setAgentReceivedFrom(Agent agentReceivedFrom) {
        this.agentReceivedFrom = agentReceivedFrom;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="CatalogedByID", unique=false, nullable=false, insertable=true, updatable=true)
    public Agent getAgentCatalogedBy() {
        return this.agentCatalogedBy;
    }

    public void setAgentCatalogedBy(Agent agentCatalogedBy) {
        this.agentCatalogedBy = agentCatalogedBy;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="AddressOfRecordID", unique=false, nullable=true, insertable=true, updatable=true)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public AddressOfRecord getAddressOfRecord() {
        return this.addressOfRecord;
    }

    public void setAddressOfRecord(AddressOfRecord addressOfRecord) {
        this.addressOfRecord = addressOfRecord;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="exchangeIn")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<ExchangeInPrep> getExchangeInPreps() {
        return this.exchangeInPreps;
    }

    public void setExchangeInPreps(Set<ExchangeInPrep> exchangeInPreps) {
        this.exchangeInPreps = exchangeInPreps;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="DivisionID", unique=false, nullable=false, insertable=true, updatable=true)
    public Division getDivision() {
        return this.division;
    }

    public void setDivision(Division division) {
        this.division = division;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return Division.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.division != null ? this.division.getId() : null;
    }

    @Override
    @Transient
    public int getTableId() {
        return ExchangeIn.getClassTableId();
    }

    public static int getClassTableId() {
        return 39;
    }
}

