/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.Address;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.AutoNumberingScheme;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Institution;
import edu.ku.brc.specify.datamodel.UserGroupScope;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@Proxy(lazy=false)
@javax.persistence.Table(name="division")
@Table(appliesTo="division", indexes={@Index(name="DivisionNameIDX", columnNames={"Name"})})
public class Division
extends UserGroupScope
implements Serializable,
Comparable<Division> {
    protected String name;
    protected String altName;
    protected String abbrev;
    protected String uri;
    protected String iconURI;
    protected String discipline;
    protected String description;
    protected String remarks;
    protected String regNumber;
    protected Address address;
    protected Institution institution;
    protected Set<Discipline> disciplines;
    protected Set<Agent> members;
    protected Set<AutoNumberingScheme> numberingSchemes;
    protected static Division currentDivision = null;

    public Division() {
    }

    public Division(Integer divisionId) {
        super(divisionId);
    }

    @Override
    public void initialize() {
        super.init();
        this.name = null;
        this.altName = null;
        this.abbrev = null;
        this.uri = null;
        this.iconURI = null;
        this.discipline = null;
        this.description = null;
        this.remarks = null;
        this.regNumber = null;
        this.members = new HashSet<Agent>();
        this.numberingSchemes = new HashSet<AutoNumberingScheme>();
        this.institution = null;
        this.address = null;
        this.disciplines = new HashSet<Discipline>();
    }

    public Integer getDivisionId() {
        return this.getUserGroupScopeId();
    }

    @Override
    @Transient
    public Integer getId() {
        return this.getUserGroupScopeId();
    }

    @Column(name="Abbrev", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getAbbrev() {
        return this.abbrev;
    }

    @Column(name="IconURI", unique=false, nullable=true, insertable=true, updatable=true, length=255)
    public String getIconURI() {
        return this.iconURI;
    }

    @Column(name="DisciplineType", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getDiscipline() {
        return this.discipline;
    }

    @Column(name="Name", unique=false, nullable=true, insertable=true, updatable=true, length=255)
    public String getName() {
        return this.name;
    }

    @Lob
    @Column(name="Remarks", length=8192)
    public String getRemarks() {
        return this.remarks;
    }

    @Lob
    @Column(name="Description", length=8192)
    public String getDescription() {
        return this.description;
    }

    @Column(name="RegNumber", unique=false, nullable=true, insertable=true, updatable=true, length=24)
    public String getRegNumber() {
        return this.regNumber;
    }

    public void setRegNumber(String regNumber) {
        this.regNumber = regNumber;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="division")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<Agent> getMembers() {
        return this.members;
    }

    @ManyToMany(cascade={}, fetch=FetchType.LAZY)
    @JoinTable(name="autonumsch_div", joinColumns={@JoinColumn(name="DivisionID", unique=false, nullable=false, insertable=true, updatable=false)}, inverseJoinColumns={@JoinColumn(name="AutoNumberingSchemeID", unique=false, nullable=false, insertable=true, updatable=false)})
    public Set<AutoNumberingScheme> getNumberingSchemes() {
        return this.numberingSchemes;
    }

    public void setNumberingSchemes(Set<AutoNumberingScheme> numberingSchemes) {
        this.numberingSchemes = numberingSchemes;
    }

    @Column(name="AltName", unique=false, nullable=true, insertable=true, updatable=true, length=128)
    public String getAltName() {
        return this.altName;
    }

    @Column(name="Uri", unique=false, nullable=true, insertable=true, updatable=true, length=255)
    public String getUri() {
        return this.uri;
    }

    @Column(name="Abbrev", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public void setAbbrev(String abbrev) {
        this.abbrev = abbrev;
    }

    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="AddressID", unique=false, nullable=true, insertable=true, updatable=true)
    public Address getAddress() {
        return this.address;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="division")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<Discipline> getDisciplines() {
        return this.disciplines;
    }

    public void setIconURI(String iconURI) {
        this.iconURI = iconURI;
    }

    public void setDivisionId(Integer divisionId) {
        this.setUserGroupScopeId(divisionId);
    }

    public void setDiscipline(String discipline) {
        this.discipline = discipline;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMembers(Set<Agent> members) {
        this.members = members;
    }

    public void setTitle(String title) {
        this.altName = title;
    }

    public void setAltName(String altName) {
        this.altName = altName;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="InstitutionID", unique=false, nullable=false, insertable=true, updatable=true)
    public Institution getInstitution() {
        return this.institution;
    }

    public void setInstitution(Institution institution) {
        this.institution = institution;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return Institution.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.institution != null ? this.institution.getId() : null;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public void setDisciplines(Set<Discipline> disciplines) {
        this.disciplines = disciplines;
    }

    @Override
    public void forceLoad() {
        for (AutoNumberingScheme ans : this.numberingSchemes) {
            ans.getTableNumber();
        }
    }

    @Transient
    public List<String> getDisciplineList() {
        Vector<String> list = new Vector<String>();
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = DBConnection.getInstance().createConnection();
            stmt = conn.createStatement();
            String sql = "SELECT Title,Name FROM discipline where DivisionID = " + this.getId();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String dspTitle = rs.getString(1);
                if (StringUtils.isEmpty((String)dspTitle)) {
                    dspTitle = rs.getString(2);
                }
                list.add(dspTitle);
            }
            rs.close();
            Collections.sort(list);
            Vector<String> vector = list;
            return vector;
        }
        catch (SQLException ex) {
            UsageTracker.incrSQLUsageCount();
            ExceptionTracker.getInstance().capture(Division.class, ex);
            System.err.println("SQLException: " + ex.toString());
            System.err.println(ex.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(Division.class, ex);
                ex.printStackTrace();
            }
        }
        return list;
    }

    @Transient
    public AutoNumberingScheme getNumberingSchemesByType(Integer schemeType) {
        for (AutoNumberingScheme scheme : this.numberingSchemes) {
            if (!scheme.getTableNumber().equals(schemeType)) continue;
            return scheme;
        }
        return null;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return Division.class;
    }

    @Override
    @Transient
    public int getTableId() {
        return Division.getClassTableId();
    }

    public static int getClassTableId() {
        return 96;
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        return StringUtils.isNotEmpty((String)this.name) ? this.name : super.getIdentityTitle();
    }

    @Override
    public String toString() {
        return this.getIdentityTitle();
    }

    @Override
    public int compareTo(Division obj) {
        if (this.altName != null && obj != null && StringUtils.isNotEmpty((String)obj.altName)) {
            return this.altName.compareTo(obj.altName);
        }
        if (this.name != null && obj != null && StringUtils.isNotEmpty((String)obj.name)) {
            return this.name.compareTo(obj.name);
        }
        return this.timestampCreated != null && obj != null && obj.timestampCreated != null ? this.timestampCreated.compareTo(obj.timestampCreated) : 0;
    }
}

