/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.specify.config.DisciplineType;
import edu.ku.brc.specify.datamodel.AttributeDef;
import edu.ku.brc.specify.datamodel.AutoNumberingScheme;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.DataType;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.datamodel.GeographyTreeDef;
import edu.ku.brc.specify.datamodel.GeologicTimePeriodTreeDef;
import edu.ku.brc.specify.datamodel.LithoStratTreeDef;
import edu.ku.brc.specify.datamodel.SpExportSchema;
import edu.ku.brc.specify.datamodel.SpLocaleContainer;
import edu.ku.brc.specify.datamodel.TaxonTreeDef;
import edu.ku.brc.specify.datamodel.TreeDefIface;
import edu.ku.brc.specify.datamodel.UserGroupScope;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Table;

@Entity
@javax.persistence.Table(name="discipline")
@Table(appliesTo="discipline", indexes={@Index(name="DisciplineNameIDX", columnNames={"Name"})})
public class Discipline
extends UserGroupScope
implements Serializable,
Comparable<Discipline> {
    protected String type;
    protected String name;
    protected DataType dataType;
    protected String regNumber;
    protected Set<Collection> collections;
    protected Set<AttributeDef> attributeDefs;
    protected GeographyTreeDef geographyTreeDef;
    protected GeologicTimePeriodTreeDef geologicTimePeriodTreeDef;
    protected TaxonTreeDef taxonTreeDef;
    protected LithoStratTreeDef lithoStratTreeDef;
    protected Division division;
    protected Set<SpLocaleContainer> spLocaleContainers;
    protected Set<SpExportSchema> spExportSchemas;
    protected Set<AutoNumberingScheme> numberingSchemes;

    public Discipline() {
    }

    public Discipline(Integer disciplineId) {
        super(disciplineId);
    }

    public static boolean isCurrentDiscipline(DisciplineType.STD_DISCIPLINES disciplineArg) {
        Discipline current = AppContextMgr.getInstance().getClassObject(Discipline.class);
        if (current != null) {
            String disciplineName = current.getType();
            return StringUtils.isNotEmpty((String)disciplineName) && disciplineName.equals(disciplineArg.toString());
        }
        return false;
    }

    @Override
    public void initialize() {
        super.init();
        this.type = null;
        this.name = null;
        this.dataType = null;
        this.regNumber = null;
        this.collections = new HashSet<Collection>();
        this.attributeDefs = new HashSet<AttributeDef>();
        this.geographyTreeDef = null;
        this.geologicTimePeriodTreeDef = null;
        this.taxonTreeDef = null;
        this.lithoStratTreeDef = null;
        this.spLocaleContainers = new HashSet<SpLocaleContainer>();
        this.spExportSchemas = new HashSet<SpExportSchema>();
        this.numberingSchemes = new HashSet<AutoNumberingScheme>();
    }

    public Integer getDisciplineId() {
        return this.getUserGroupScopeId();
    }

    @Override
    @Transient
    public Integer getId() {
        return this.getUserGroupScopeId();
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return Discipline.class;
    }

    public void setDisciplineId(Integer disciplineId) {
        this.setUserGroupScopeId(disciplineId);
    }

    @Column(name="Name", length=64)
    public String getName() {
        return this.name;
    }

    public void setName(String title) {
        this.name = title;
    }

    @Column(name="Type", length=64)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="DataTypeID", nullable=false)
    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    @Column(name="RegNumber", unique=false, nullable=true, insertable=true, updatable=true, length=24)
    public String getRegNumber() {
        return this.regNumber;
    }

    public void setRegNumber(String regNumber) {
        this.regNumber = regNumber;
    }

    @OneToMany(mappedBy="discipline")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<Collection> getCollections() {
        return this.collections;
    }

    public void setCollections(Set<Collection> collections) {
        this.collections = collections;
    }

    @OneToMany(mappedBy="discipline")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<AttributeDef> getAttributeDefs() {
        return this.attributeDefs;
    }

    public void setAttributeDefs(Set<AttributeDef> attributeDefs) {
        this.attributeDefs = attributeDefs;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="GeographyTreeDefID", nullable=false)
    public GeographyTreeDef getGeographyTreeDef() {
        return this.geographyTreeDef;
    }

    public void setGeographyTreeDef(GeographyTreeDef geographyTreeDef) {
        this.geographyTreeDef = geographyTreeDef;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL})
    @JoinColumn(name="GeologicTimePeriodTreeDefID", nullable=false)
    public GeologicTimePeriodTreeDef getGeologicTimePeriodTreeDef() {
        return this.geologicTimePeriodTreeDef;
    }

    public void setGeologicTimePeriodTreeDef(GeologicTimePeriodTreeDef geologicTimePeriodTreeDef) {
        this.geologicTimePeriodTreeDef = geologicTimePeriodTreeDef;
    }

    @OneToOne
    @Cascade(value={CascadeType.ALL})
    @JoinColumn(name="TaxonTreeDefID")
    public TaxonTreeDef getTaxonTreeDef() {
        return this.taxonTreeDef;
    }

    public void setTaxonTreeDef(TaxonTreeDef taxonTreeDef) {
        this.taxonTreeDef = taxonTreeDef;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL})
    @JoinColumn(name="LithoStratTreeDefID")
    public LithoStratTreeDef getLithoStratTreeDef() {
        return this.lithoStratTreeDef;
    }

    public void setLithoStratTreeDef(LithoStratTreeDef lithoStratTreeDef) {
        this.lithoStratTreeDef = lithoStratTreeDef;
    }

    @OneToMany(mappedBy="discipline")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<SpLocaleContainer> getSpLocaleContainers() {
        return this.spLocaleContainers;
    }

    public void setSpLocaleContainers(Set<SpLocaleContainer> spLocaleContainers) {
        this.spLocaleContainers = spLocaleContainers;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="DivisionID", nullable=false)
    public Division getDivision() {
        return this.division;
    }

    @OneToMany(mappedBy="discipline")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<SpExportSchema> getSpExportSchemas() {
        return this.spExportSchemas;
    }

    public void setSpExportSchemas(Set<SpExportSchema> spExportSchemas) {
        this.spExportSchemas = spExportSchemas;
    }

    @ManyToMany(cascade={}, fetch=FetchType.LAZY)
    @JoinTable(name="autonumsch_dsp", joinColumns={@JoinColumn(name="DisciplineID", unique=false, nullable=false, insertable=true, updatable=false)}, inverseJoinColumns={@JoinColumn(name="AutoNumberingSchemeID", unique=false, nullable=false, insertable=true, updatable=false)})
    public Set<AutoNumberingScheme> getNumberingSchemes() {
        return this.numberingSchemes;
    }

    public void setNumberingSchemes(Set<AutoNumberingScheme> numberingSchemes) {
        this.numberingSchemes = numberingSchemes;
    }

    public void setDivision(Division division) {
        this.division = division;
    }

    @Override
    public void forceLoad() {
        for (AutoNumberingScheme ans : this.numberingSchemes) {
            ans.getTableNumber();
        }
    }

    @Override
    public String toString() {
        return StringUtils.isNotEmpty((String)this.name) ? this.name : this.type;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return Division.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.division != null ? this.division.getId() : null;
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        return this.toString();
    }

    @Override
    @Transient
    public int getTableId() {
        return Discipline.getClassTableId();
    }

    public static int getClassTableId() {
        return 26;
    }

    @Override
    public int compareTo(Discipline obj) {
        if (this.name != null && obj != null && StringUtils.isNotEmpty((String)obj.name)) {
            return this.name.compareTo(obj.name);
        }
        if (this.type != null && obj != null && StringUtils.isNotEmpty((String)obj.type)) {
            return this.type.compareTo(obj.type);
        }
        return this.timestampCreated != null && obj != null && obj.timestampCreated != null ? this.timestampCreated.compareTo(obj.timestampCreated) : 0;
    }

    @Transient
    public TreeDefIface<?, ?, ?> getTreeDef(String defName) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method getter = Discipline.class.getMethod("get" + defName, null);
        return (TreeDefIface)getter.invoke((Object)this, null);
    }
}

