/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.CollectionMember;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.DeterminationCitation;
import edu.ku.brc.specify.datamodel.Taxon;
import java.io.Serializable;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@javax.persistence.Table(name="determination")
@Proxy(lazy=false)
@Table(appliesTo="determination", indexes={@Index(name="DeterminedDateIDX", columnNames={"DeterminedDate"}), @Index(name="DetMemIDX", columnNames={"CollectionMemberID"}), @Index(name="AlterNameIDX", columnNames={"AlternateName"}), @Index(name="TypeStatusNameIDX", columnNames={"TypeStatusName"})})
public class Determination
extends CollectionMember
implements Serializable,
Comparable<Determination>,
Cloneable {
    protected Integer determinationId;
    protected Boolean isCurrent;
    protected String typeStatusName;
    protected Calendar determinedDate;
    protected Byte determinedDatePrecision;
    protected String qualifier;
    protected String subSpQualifier;
    protected String varQualifier;
    protected String addendum;
    protected String confidence;
    protected String method;
    protected String alternateName;
    protected String nameUsage;
    protected String featureOrBasis;
    protected String remarks;
    protected String text1;
    protected String text2;
    protected Float number1;
    protected Float number2;
    protected Boolean yesNo1;
    protected Boolean yesNo2;
    protected Taxon preferredTaxon;
    protected Taxon taxon;
    protected CollectionObject collectionObject;
    protected Set<DeterminationCitation> determinationCitations;
    protected Agent determiner;

    public Determination() {
    }

    public Determination(Integer determinationId) {
        this.determinationId = determinationId;
    }

    @Override
    public void initialize() {
        super.init();
        this.determinationId = null;
        this.isCurrent = false;
        this.typeStatusName = null;
        this.determinedDate = null;
        this.determinedDatePrecision = null;
        this.confidence = null;
        this.qualifier = null;
        this.subSpQualifier = null;
        this.varQualifier = null;
        this.addendum = null;
        this.alternateName = null;
        this.nameUsage = null;
        this.method = null;
        this.featureOrBasis = null;
        this.remarks = null;
        this.text1 = null;
        this.text2 = null;
        this.number1 = null;
        this.number2 = null;
        this.yesNo1 = null;
        this.yesNo2 = null;
        this.preferredTaxon = null;
        this.taxon = null;
        this.collectionObject = null;
        this.determinationCitations = new HashSet<DeterminationCitation>();
        this.determiner = null;
    }

    @Id
    @GeneratedValue
    @Column(name="DeterminationID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getDeterminationId() {
        return this.determinationId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.determinationId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return Determination.class;
    }

    public void setDeterminationId(Integer determinationId) {
        this.determinationId = determinationId;
    }

    @Column(name="IsCurrent", unique=false, nullable=false, updatable=true, insertable=true)
    public Boolean getIsCurrent() {
        return this.isCurrent != null ? this.isCurrent : false;
    }

    public void setIsCurrent(Boolean isCurrent) {
        this.isCurrent = isCurrent;
    }

    @Transient
    public boolean isCurrentDet() {
        return this.isCurrent == null ? false : this.isCurrent;
    }

    @Column(name="TypeStatusName", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getTypeStatusName() {
        return this.typeStatusName;
    }

    public void setTypeStatusName(String typeStatusName) {
        this.typeStatusName = typeStatusName;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DeterminedDate", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getDeterminedDate() {
        return this.determinedDate;
    }

    public void setDeterminedDate(Calendar determinedDate) {
        this.determinedDate = determinedDate;
    }

    @Column(name="DeterminedDatePrecision", unique=false, nullable=true, insertable=true, updatable=true)
    public Byte getDeterminedDatePrecision() {
        return this.determinedDatePrecision != null ? this.determinedDatePrecision : (byte)UIFieldFormatterIFace.PartialDateEnum.Full.ordinal();
    }

    public void setDeterminedDatePrecision(Byte determinedDatePrecision) {
        this.determinedDatePrecision = determinedDatePrecision;
    }

    @Column(name="Confidence", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getConfidence() {
        return this.confidence;
    }

    public void setConfidence(String confidence) {
        this.confidence = confidence;
    }

    @Column(name="Qualifier", unique=false, nullable=true, insertable=true, updatable=true, length=16)
    public String getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    @Column(name="SubSpQualifier", unique=false, nullable=true, insertable=true, updatable=true, length=16)
    public String getSubSpQualifier() {
        return this.subSpQualifier;
    }

    public void setSubSpQualifier(String subSpQualifier) {
        this.subSpQualifier = subSpQualifier;
    }

    @Column(name="VarQualifier", unique=false, nullable=true, insertable=true, updatable=true, length=16)
    public String getVarQualifier() {
        return this.varQualifier;
    }

    public void setVarQualifier(String varQualifier) {
        this.varQualifier = varQualifier;
    }

    @Column(name="Addendum", unique=false, nullable=true, insertable=true, updatable=true, length=16)
    public String getAddendum() {
        return this.addendum;
    }

    public void setAddendum(String addendum) {
        this.addendum = addendum;
    }

    @Column(name="AlternateName", unique=false, nullable=true, insertable=true, updatable=true, length=128)
    public String getAlternateName() {
        return this.alternateName;
    }

    public void setAlternateName(String alternateName) {
        this.alternateName = alternateName;
    }

    @Column(name="NameUsage", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getNameUsage() {
        return this.nameUsage;
    }

    public void setNameUsage(String nameUsage) {
        this.nameUsage = nameUsage;
    }

    @Column(name="Method", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    @Column(name="FeatureOrBasis", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getFeatureOrBasis() {
        return this.featureOrBasis;
    }

    public void setFeatureOrBasis(String featureOrBasis) {
        this.featureOrBasis = featureOrBasis;
    }

    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Column(name="Text1", length=300, unique=false, nullable=true, insertable=true, updatable=true)
    public String getText1() {
        return this.text1;
    }

    public void setText1(String text1) {
        this.text1 = text1;
    }

    @Column(name="Text2", length=300, unique=false, nullable=true, insertable=true, updatable=true)
    public String getText2() {
        return this.text2;
    }

    public void setText2(String text2) {
        this.text2 = text2;
    }

    @Column(name="Number1", unique=false, nullable=true, insertable=true, updatable=true, length=24)
    public Float getNumber1() {
        return this.number1;
    }

    public void setNumber1(Float number1) {
        this.number1 = number1;
    }

    @Column(name="Number2", unique=false, nullable=true, insertable=true, updatable=true, length=24)
    public Float getNumber2() {
        return this.number2;
    }

    public void setNumber2(Float number2) {
        this.number2 = number2;
    }

    @Column(name="YesNo1", unique=false, nullable=true, updatable=true, insertable=true)
    public Boolean getYesNo1() {
        return this.yesNo1;
    }

    public void setYesNo1(Boolean yesNo1) {
        this.yesNo1 = yesNo1;
    }

    @Column(name="YesNo2", unique=false, nullable=true, updatable=true, insertable=true)
    public Boolean getYesNo2() {
        return this.yesNo2;
    }

    public void setYesNo2(Boolean yesNo2) {
        this.yesNo2 = yesNo2;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="TaxonID", unique=false, nullable=true, insertable=true, updatable=true)
    public Taxon getTaxon() {
        return this.taxon;
    }

    public void setTaxon(Taxon taxon) {
        this.taxon = taxon;
        this.preferredTaxon = taxon == null || taxon.getIsAccepted() != false ? taxon : taxon.getAcceptedTaxon();
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="PreferredTaxonID", unique=false, nullable=true, insertable=true, updatable=true)
    public Taxon getPreferredTaxon() {
        return this.preferredTaxon;
    }

    public void setPreferredTaxon(Taxon preferredTaxon) {
        this.preferredTaxon = preferredTaxon;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="CollectionObjectID", unique=false, nullable=false, insertable=true, updatable=true)
    public CollectionObject getCollectionObject() {
        return this.collectionObject;
    }

    public void setCollectionObject(CollectionObject collectionObject) {
        this.collectionObject = collectionObject;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="determination")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<DeterminationCitation> getDeterminationCitations() {
        return this.determinationCitations;
    }

    public void setDeterminationCitations(Set<DeterminationCitation> determinationCitations) {
        this.determinationCitations = determinationCitations;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="DeterminerID", unique=false, nullable=true, insertable=true, updatable=true)
    public Agent getDeterminer() {
        return this.determiner;
    }

    public void setDeterminer(Agent determiner) {
        this.determiner = determiner;
    }

    public void addDeterminationCitations(DeterminationCitation determinationCitation) {
        this.determinationCitations.add(determinationCitation);
        determinationCitation.setDetermination(this);
    }

    public void removeDeterminationCitations(DeterminationCitation determinationCitation) {
        this.determinationCitations.remove(determinationCitation);
        determinationCitation.setDetermination(null);
    }

    @Override
    public void forceLoad() {
        this.determinationCitations.size();
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return CollectionObject.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.collectionObject != null ? this.collectionObject.getId() : null;
    }

    @Override
    @Transient
    public int getTableId() {
        return Determination.getClassTableId();
    }

    public static int getClassTableId() {
        return 9;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Determination obj = (Determination)super.clone();
        obj.determinationId = null;
        obj.collectionObject = null;
        obj.determinationCitations = new HashSet<DeterminationCitation>();
        for (DeterminationCitation dc : this.determinationCitations) {
            DeterminationCitation newDC = (DeterminationCitation)dc.clone();
            newDC.setDetermination(obj);
            obj.determinationCitations.add(newDC);
        }
        return obj;
    }

    @Override
    public int compareTo(Determination obj) {
        boolean result;
        boolean bl = result = this.isCurrentDet() != obj.isCurrentDet();
        if (result) {
            return this.isCurrentDet() ? -1 : 1;
        }
        if (this.determinedDate != null && obj != null && obj.determinedDate != null) {
            return obj.determinedDate.compareTo(this.determinedDate);
        }
        return this.timestampCreated != null && obj != null && obj.timestampCreated != null ? this.timestampCreated.compareTo(obj.timestampCreated) : 0;
    }
}

