/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.Accession;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.DeaccessionAgent;
import edu.ku.brc.specify.datamodel.DeaccessionPreparation;
import java.io.Serializable;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="deaccession")
@Table(appliesTo="deaccession", indexes={@Index(name="DeaccessionNumberIDX", columnNames={"DeaccessionNumber"}), @Index(name="DeaccessionDateIDX", columnNames={"DeaccessionDate"})})
public class Deaccession
extends DataModelObjBase
implements Serializable {
    protected Integer deaccessionId;
    protected String type;
    protected String deaccessionNumber;
    protected Calendar deaccessionDate;
    protected String remarks;
    protected String text1;
    protected String text2;
    protected Float number1;
    protected Float number2;
    protected Boolean yesNo1;
    protected Boolean yesNo2;
    protected Set<DeaccessionAgent> deaccessionAgents;
    protected Set<DeaccessionPreparation> deaccessionPreparations;
    protected Accession accession;

    public Deaccession() {
    }

    public Deaccession(Integer deaccessionId) {
        this.deaccessionId = deaccessionId;
    }

    @Override
    public void initialize() {
        super.init();
        this.deaccessionId = null;
        this.type = null;
        this.deaccessionNumber = null;
        this.deaccessionDate = null;
        this.remarks = null;
        this.text1 = null;
        this.text2 = null;
        this.number1 = null;
        this.number2 = null;
        this.yesNo1 = null;
        this.yesNo2 = null;
        this.deaccessionAgents = new HashSet<DeaccessionAgent>();
        this.deaccessionPreparations = new HashSet<DeaccessionPreparation>();
        this.accession = null;
    }

    @Id
    @GeneratedValue
    @Column(name="DeaccessionID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getDeaccessionId() {
        return this.deaccessionId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.deaccessionId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return Deaccession.class;
    }

    public void setDeaccessionId(Integer deaccessionId) {
        this.deaccessionId = deaccessionId;
    }

    @Column(name="Type", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Column(name="DeaccessionNumber", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getDeaccessionNumber() {
        return this.deaccessionNumber;
    }

    public void setDeaccessionNumber(String deaccessionNumber) {
        this.deaccessionNumber = deaccessionNumber;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DeaccessionDate", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getDeaccessionDate() {
        return this.deaccessionDate;
    }

    public void setDeaccessionDate(Calendar deaccessionDate) {
        this.deaccessionDate = deaccessionDate;
    }

    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Column(name="Text1", length=300, unique=false, nullable=true, insertable=true, updatable=true)
    public String getText1() {
        return this.text1;
    }

    public void setText1(String text1) {
        this.text1 = text1;
    }

    @Column(name="Text2", length=300, unique=false, nullable=true, insertable=true, updatable=true)
    public String getText2() {
        return this.text2;
    }

    public void setText2(String text2) {
        this.text2 = text2;
    }

    @Column(name="Number1", unique=false, nullable=true, insertable=true, updatable=true, length=24)
    public Float getNumber1() {
        return this.number1;
    }

    public void setNumber1(Float number1) {
        this.number1 = number1;
    }

    @Column(name="Number2", unique=false, nullable=true, insertable=true, updatable=true, length=24)
    public Float getNumber2() {
        return this.number2;
    }

    public void setNumber2(Float number2) {
        this.number2 = number2;
    }

    @Column(name="YesNo1", unique=false, nullable=true, updatable=true, insertable=true)
    public Boolean getYesNo1() {
        return this.yesNo1;
    }

    public void setYesNo1(Boolean yesNo1) {
        this.yesNo1 = yesNo1;
    }

    @Column(name="YesNo2", unique=false, nullable=true, updatable=true, insertable=true)
    public Boolean getYesNo2() {
        return this.yesNo2;
    }

    public void setYesNo2(Boolean yesNo2) {
        this.yesNo2 = yesNo2;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="deaccession")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<DeaccessionAgent> getDeaccessionAgents() {
        return this.deaccessionAgents;
    }

    public void setDeaccessionAgents(Set<DeaccessionAgent> deaccessionAgents) {
        this.deaccessionAgents = deaccessionAgents;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="deaccession")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<DeaccessionPreparation> getDeaccessionPreparations() {
        return this.deaccessionPreparations;
    }

    public void setDeaccessionPreparations(Set<DeaccessionPreparation> deaccessionPreparations) {
        this.deaccessionPreparations = deaccessionPreparations;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.LOCK})
    @JoinColumn(name="AccessionID", unique=false, nullable=true, insertable=true, updatable=true)
    public Accession getAccession() {
        return this.accession;
    }

    public void setAccession(Accession accession) {
        this.accession = accession;
    }

    @Override
    @Transient
    public int getTableId() {
        return Deaccession.getClassTableId();
    }

    public static int getClassTableId() {
        return 34;
    }
}

