/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.forms.DataObjectGettable;
import edu.ku.brc.af.ui.forms.DataObjectGettableFactory;
import edu.ku.brc.af.ui.forms.DataObjectSettable;
import edu.ku.brc.af.ui.forms.DataObjectSettableFactory;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.FormHelper;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatMgr;
import edu.ku.brc.af.ui.weblink.WebLinkDataProviderIFace;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collection;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

@MappedSuperclass
public abstract class DataModelObjBase
implements FormDataObjIFace,
WebLinkDataProviderIFace,
Cloneable {
    private static final Logger log = Logger.getLogger(DataModelObjBase.class);
    protected PropertyChangeSupport changes;
    protected Timestamp timestampCreated;
    protected Timestamp timestampModified;
    protected Agent createdByAgent;
    protected Agent modifiedByAgent;
    protected int version;
    protected Integer parentTblId = null;
    protected static String errMsg = null;

    @Override
    public abstract void initialize();

    protected void init() {
        Timestamp now;
        this.timestampCreated = now = new Timestamp(System.currentTimeMillis());
        this.timestampModified = now;
        this.createdByAgent = AppContextMgr.getInstance() == null ? null : (AppContextMgr.getInstance().hasContext() ? Agent.getUserAgent() : null);
        this.modifiedByAgent = null;
    }

    @Override
    @Transient
    public abstract Integer getId();

    @Override
    @Transient
    public String getIdentityTitle() {
        try {
            String str = DataObjFieldFormatMgr.getInstance().format((Object)this, this.getDataClass());
            if (StringUtils.isEmpty((String)str)) {
                DBTableInfo tableInfo = DBTableIdMgr.getInstance().getByClassName(this.getClass().getName());
                if (tableInfo != null) {
                    return tableInfo.getTitle();
                }
                str = UIRegistry.getResourceString("DATAOBJ_ITEM");
            }
            return str;
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DataModelObjBase.class, ex);
            ex.printStackTrace();
            return String.valueOf(this.getClass().getName()) + this.hashCode();
        }
    }

    @Override
    @Column(name="TimestampCreated", nullable=false, updatable=false)
    public Timestamp getTimestampCreated() {
        return this.timestampCreated;
    }

    @Override
    public void setTimestampCreated(Timestamp timestampCreated) {
        this.timestampCreated = timestampCreated;
        this.setTimestampModified(timestampCreated);
    }

    @Override
    @Column(name="TimestampModified")
    public Timestamp getTimestampModified() {
        return this.timestampModified;
    }

    @Override
    public void setTimestampModified(Timestamp timestampModified) {
        this.timestampModified = timestampModified;
    }

    @Override
    @Version
    @Column(name="Version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="ModifiedByAgentID")
    public Agent getModifiedByAgent() {
        return this.modifiedByAgent;
    }

    @Override
    public void setModifiedByAgent(Agent lastEditedBy) {
        this.modifiedByAgent = lastEditedBy;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="CreatedByAgentID", updatable=false)
    public Agent getCreatedByAgent() {
        return this.createdByAgent;
    }

    @Override
    public void setCreatedByAgent(Agent createdByAgent) {
        this.createdByAgent = createdByAgent;
    }

    @Override
    @Transient
    public boolean isRestrictable() {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean setDataMember(FormDataObjIFace dataObject, String fieldName, FormDataObjIFace ref) {
        block6: {
            methodName = "";
            try {
                methodName = "set" + StringUtils.capitalize((String)fieldName);
                method = dataObject.getClass().getMethod(methodName, new Class[]{ref.getDataClass()});
                if (method != null) {
                    method.invoke((Object)dataObject, new Object[]{ref});
                    return true;
                }
            }
            catch (NoSuchMethodException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(DataModelObjBase.class, ex);
                DataModelObjBase.log.error((Object)("Couldn't find method [" + methodName + "] on Class [" + dataObject.getDataClass().getSimpleName() + "] for arg[" + ref.getDataClass() + "]"));
                DataModelObjBase.log.error((Object)("For Class " + dataObject.getClass().getSimpleName()));
                var8_7 = dataObject.getClass().getMethods();
                var7_8 = var8_7.length;
                var6_9 = 0;
                ** while (var6_9 < var7_8)
            }
lbl-1000:
            // 1 sources

            {
                m = var8_7[var6_9];
                mName = m.getName();
                if (mName.startsWith("set")) {
                    DataModelObjBase.log.error((Object)(String.valueOf(mName) + " " + mName.equals(methodName)));
                }
                ++var6_9;
                continue;
            }
lbl25:
            // 1 sources

            ex.printStackTrace();
            break block6;
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(DataModelObjBase.class, ex);
                ex.printStackTrace();
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean addToCollection(FormDataObjIFace dataObject, String fieldName, FormDataObjIFace ref) {
        try {
            DataObjectGettable getter = DataObjectGettableFactory.get(dataObject.getClass().getName(), "edu.ku.brc.af.ui.forms.DataGetterForObj");
            Object dataMember = getter.getFieldValue(dataObject, fieldName);
            if (dataMember == null) {
                log.error((Object)("DataMember [" + fieldName + "] was null in object of class[" + dataObject.getDataClass().getSimpleName() + "]"));
                return false;
            }
            try {
                Method method = dataMember.getClass().getMethod("add", Object.class);
                if (method != null) {
                    method.invoke(dataMember, ref);
                    return true;
                }
                log.error((Object)("Missing method add(Object) for this type of set [" + dataMember.getClass() + "]"));
                return false;
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(DataModelObjBase.class, ex);
                ex.printStackTrace();
                return false;
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DataModelObjBase.class, ex);
            ex.printStackTrace();
        }
        return false;
    }

    public static boolean removeFromCollection(Object dataObject, String fieldName, FormDataObjIFace ref) {
        Object dataMember;
        block3: {
            DataObjectGettable getter = DataObjectGettableFactory.get(dataObject.getClass().getName(), "edu.ku.brc.af.ui.forms.DataGetterForObj");
            dataMember = getter.getFieldValue(dataObject, fieldName);
            Method method = dataMember.getClass().getMethod("remove", Object.class);
            if (method == null) break block3;
            method.invoke(dataMember, ref);
            return true;
        }
        try {
            log.error((Object)("Missing method remove(Object) for this type of set [" + dataMember.getClass() + "]"));
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DataModelObjBase.class, ex);
            ex.printStackTrace();
        }
        return false;
    }

    protected Boolean isJavaCollection(Object dataObject, String fieldName) {
        try {
            Field fld = dataObject.getClass().getDeclaredField(fieldName);
            if (fld != null) {
                return Collection.class.isAssignableFrom(fld.getType());
            }
            log.error((Object)("Couldn't find field [" + fieldName + "] in class [" + this.getClass().getSimpleName() + "]"));
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DataModelObjBase.class, ex);
            ex.printStackTrace();
        }
        return null;
    }

    @Override
    public void addReference(FormDataObjIFace ref, String fieldName) {
        this.addReference(ref, fieldName, true);
    }

    @Override
    public void addReference(FormDataObjIFace ref, String fieldName, boolean doOtherSide) {
        DBTableInfo tblInfo;
        if (ref == null) {
            return;
        }
        String fldName = fieldName;
        FormDataObjIFace parentDataObject = this;
        if (StringUtils.contains((String)fldName, (char)'.')) {
            String[] fieldNames = StringUtils.split((String)fldName, (char)'.');
            String[] parentPath = new String[fieldNames.length - 1];
            int i = 0;
            while (i < parentPath.length) {
                parentPath[i] = fieldNames[i];
                ++i;
            }
            DataObjectGettable getter = DataObjectGettableFactory.get(this.getClass().getName(), "edu.ku.brc.af.ui.forms.DataGetterForObj");
            Object[] values = UIHelper.getFieldValues(parentPath, (Object)this, getter);
            parentDataObject = (FormDataObjIFace)values[parentPath.length - 1];
            fldName = fieldNames[fieldNames.length - 1];
        }
        if ((tblInfo = DBTableIdMgr.getInstance().getInfoById(parentDataObject.getTableId())) != null) {
            DBRelationshipInfo rel = tblInfo.getRelationshipByName(fldName);
            if (rel != null) {
                Boolean isJavaCollection = this.isJavaCollection(parentDataObject, fldName);
                if (isJavaCollection != null) {
                    String otherSide = rel.getOtherSide();
                    if (isJavaCollection.booleanValue()) {
                        DataModelObjBase.addToCollection(parentDataObject, fldName, ref);
                        if (StringUtils.isNotEmpty((String)otherSide) && doOtherSide) {
                            Boolean isOtherSideCollection = this.isJavaCollection(ref, otherSide);
                            if (isOtherSideCollection != null && isOtherSideCollection.booleanValue()) {
                                DataModelObjBase.addToCollection(ref, otherSide, parentDataObject);
                            } else {
                                DataObjectSettable setter = DataObjectSettableFactory.get(ref.getClass().getName(), "edu.ku.brc.af.ui.forms.DataSetterForObj");
                                setter.setFieldValue(ref, otherSide, parentDataObject);
                            }
                        }
                    } else if (doOtherSide) {
                        if (otherSide != null) {
                            DataModelObjBase.addToCollection(ref, otherSide, parentDataObject);
                        }
                        DataObjectSettable setter = DataObjectSettableFactory.get(ref.getClass().getName(), "edu.ku.brc.af.ui.forms.DataSetterForObj");
                        setter.setFieldValue(parentDataObject, fldName, ref);
                    }
                } else {
                    log.error((Object)("Could not find field[" + fieldName + "] [" + fldName + "] in class[" + parentDataObject.getClass().getSimpleName() + "]"));
                }
            } else {
                log.error((Object)("Couldn't find relationship[" + fieldName + "] [" + fldName + "] For Table[" + ref.getTableId() + "]"));
            }
        } else {
            log.error((Object)("Couldn't find TableInfo [" + ref.getTableId() + "]"));
        }
    }

    @Override
    public void removeReference(FormDataObjIFace ref, String fieldName) {
        this.removeReference(ref, fieldName, false);
    }

    @Override
    public void removeReference(FormDataObjIFace ref, String fieldName, boolean doOtherSide) {
        Boolean isJavaCollection;
        DBRelationshipInfo rel;
        DBTableInfo tblInfo;
        if (ref == null) {
            return;
        }
        String fldName = fieldName;
        FormDataObjIFace parentDataObject = this;
        if (StringUtils.contains((String)fldName, (char)'.')) {
            String[] fieldNames = StringUtils.split((String)fldName, (char)'.');
            String[] parentPath = new String[fieldNames.length - 1];
            int i = 0;
            while (i < parentPath.length) {
                parentPath[i] = fieldNames[i];
                ++i;
            }
            DataObjectGettable getter = DataObjectGettableFactory.get(this.getClass().getName(), "edu.ku.brc.af.ui.forms.DataGetterForObj");
            Object[] values = UIHelper.getFieldValues(parentPath, (Object)this, getter);
            parentDataObject = (FormDataObjIFace)values[parentPath.length - 1];
            fldName = fieldNames[fieldNames.length - 1];
        }
        if ((tblInfo = DBTableIdMgr.getInstance().getInfoById(parentDataObject.getTableId())) != null && (rel = tblInfo.getRelationshipByName(fldName)) != null && (isJavaCollection = this.isJavaCollection(parentDataObject, fldName)) != null) {
            if (isJavaCollection.booleanValue()) {
                String otherSide = rel.getOtherSide();
                DataModelObjBase.removeFromCollection(parentDataObject, fldName, ref);
                if (StringUtils.isNotEmpty((String)otherSide) && doOtherSide) {
                    Boolean isOtherSideCollection = this.isJavaCollection(ref, otherSide);
                    if (isOtherSideCollection != null && isOtherSideCollection.booleanValue()) {
                        DataModelObjBase.removeFromCollection(ref, otherSide, parentDataObject);
                    } else {
                        DataObjectSettable setter = DataObjectSettableFactory.get(ref.getClass().getName(), "edu.ku.brc.af.ui.forms.DataSetterForObj");
                        setter.setFieldValue(ref, otherSide, null);
                    }
                }
            } else {
                DataObjectSettable setter = DataObjectSettableFactory.get(ref.getClass().getName(), "edu.ku.brc.af.ui.forms.DataSetterForObj");
                setter.setFieldValue(parentDataObject, fldName, null);
            }
        }
    }

    @Override
    public Object getReferenceValue(String refName) {
        throw new RuntimeException(this.getClass() + "MUST override getReferenceValue()");
    }

    @Override
    public void onDelete() {
    }

    @Override
    public void onSave() {
    }

    @Override
    public void onUpdate() {
    }

    @Override
    @Transient
    public abstract int getTableId();

    @Override
    @Transient
    public abstract Class<?> getDataClass();

    @Override
    @Transient
    public boolean isChangeNotifier() {
        return true;
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.parentTblId;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return null;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changes == null) {
            this.changes = new PropertyChangeSupport(this);
        }
        this.changes.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.changes == null) {
            this.changes = new PropertyChangeSupport(this);
        }
        this.changes.addPropertyChangeListener(propertyName, listener);
    }

    public void firePropertyChange(PropertyChangeEvent evt) {
        if (this.changes == null) {
            this.changes = new PropertyChangeSupport(this);
        }
        this.changes.firePropertyChange(evt);
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if (this.changes == null) {
            this.changes = new PropertyChangeSupport(this);
        }
        this.changes.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        if (this.changes == null) {
            this.changes = new PropertyChangeSupport(this);
        }
        this.changes.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changes == null) {
            this.changes = new PropertyChangeSupport(this);
        }
        this.changes.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changes == null) {
            this.changes = new PropertyChangeSupport(this);
        }
        this.changes.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.changes == null) {
            this.changes = new PropertyChangeSupport(this);
        }
        this.changes.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public void forceLoad() {
    }

    @Override
    public String getWebLinkData(String dataName) {
        if (StringUtils.isNotEmpty((String)dataName)) {
            Object data = FormHelper.getValue(this, dataName);
            return data != null ? data.toString() : null;
        }
        return null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DataModelObjBase obj = (DataModelObjBase)super.clone();
        obj.init();
        return obj;
    }

    public String toString() {
        return String.valueOf(super.toString()) + " : " + this.timestampModified;
    }

    public static <T> T getDataObj(Class<?> cls, int id) {
        DataProviderSessionIFace session = null;
        try {
            session = DataProviderFactory.getInstance().createSession();
            DataModelObjBase dmObj = (DataModelObjBase)session.get(cls, id);
            dmObj.forceLoad();
            DataModelObjBase dataModelObjBase = dmObj;
            return (T)dataModelObjBase;
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DataModelObjBase.class, ex);
            ex.printStackTrace();
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return null;
    }

    public static boolean save(Object ... dataObjs) {
        return DataModelObjBase.save(false, dataObjs);
    }

    public static boolean save(boolean doShowError, Object ... dataObjs) {
        errMsg = null;
        DataProviderSessionIFace session = null;
        boolean transOpen = false;
        try {
            try {
                Object obj;
                int n;
                int n2;
                Object[] objectArray;
                session = DataProviderFactory.getInstance().createSession();
                session.beginTransaction();
                transOpen = true;
                boolean doSave = true;
                if (dataObjs.length == 1) {
                    objectArray = dataObjs;
                    n2 = dataObjs.length;
                    n = 0;
                    while (n < n2) {
                        obj = objectArray[n];
                        if (obj instanceof Collection) {
                            for (Object dObj : (Collection)obj) {
                                session.saveOrUpdate(dObj);
                            }
                            doSave = false;
                        }
                        ++n;
                    }
                }
                if (doSave) {
                    objectArray = dataObjs;
                    n2 = dataObjs.length;
                    n = 0;
                    while (n < n2) {
                        obj = objectArray[n];
                        session.saveOrUpdate(obj);
                        ++n;
                    }
                }
                session.commit();
                transOpen = false;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                log.error((Object)ex);
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(DataModelObjBase.class, ex);
                errMsg = ex.toString();
                if (doShowError) {
                    UIRegistry.showError(errMsg);
                }
                if (transOpen) {
                    session.rollback();
                }
                if (session != null) {
                    session.close();
                }
                return false;
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return true;
    }

    public static boolean delete(Object ... dataObjs) {
        return DataModelObjBase.delete(false, dataObjs);
    }

    public static boolean delete(boolean doShowError, Object ... dataObjs) {
        errMsg = null;
        DataProviderSessionIFace session = null;
        try {
            try {
                session = DataProviderFactory.getInstance().createSession();
                session.beginTransaction();
                Object[] objectArray = dataObjs;
                int n = dataObjs.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    session.delete(obj);
                    ++n2;
                }
                session.commit();
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(DataModelObjBase.class, ex);
                ex.printStackTrace();
                log.error((Object)ex);
                errMsg = ex.toString();
                if (doShowError) {
                    UIRegistry.showError(errMsg);
                }
                if (session != null) {
                    session.close();
                }
                return false;
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return true;
    }

    public static boolean delete(int id, int tableId) {
        return DataModelObjBase.delete(id, tableId, false);
    }

    public static boolean delete(int id, int tableId, boolean doShowError) {
        errMsg = null;
        DBTableInfo ti = DBTableIdMgr.getInstance().getInfoById(tableId);
        Connection connection = DBConnection.getInstance().createConnection();
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            int numRecs = stmt.executeUpdate("DELETE FROM " + ti.getName() + " WHERE " + ti.getIdColumnName() + " = " + id);
            if (numRecs != 1) {
                return false;
            }
        }
        catch (SQLException ex) {
            UsageTracker.incrSQLUsageCount();
            ExceptionTracker.getInstance().capture(DataModelObjBase.class, ex);
            ex.printStackTrace();
            errMsg = ex.toString();
            try {
                connection.rollback();
            }
            catch (SQLException ex2) {
                UsageTracker.incrSQLUsageCount();
                ExceptionTracker.getInstance().capture(DataModelObjBase.class, ex2);
                ex.printStackTrace();
            }
            return false;
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException ex) {
                UsageTracker.incrSQLUsageCount();
                ExceptionTracker.getInstance().capture(DataModelObjBase.class, ex);
                ex.printStackTrace();
            }
        }
        return true;
    }

    public static String getErrorMsg() {
        return errMsg;
    }
}

