/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.AttachmentOwnerIFace;
import edu.ku.brc.specify.datamodel.CollectionMember;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.DNASequenceAttachment;
import edu.ku.brc.specify.datamodel.DNASequencingRun;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="dnasequence")
@Table(appliesTo="dnasequence", indexes={@Index(name="GenBankAccIDX", columnNames={"GenBankAccessionNumber"}), @Index(name="BOLDBarcodeIDX", columnNames={"BOLDBarcodeID"}), @Index(name="BOLDSampleIDX", columnNames={"BOLDSampleID"})})
public class DNASequence
extends CollectionMember
implements AttachmentOwnerIFace<DNASequenceAttachment> {
    protected Integer dnaSequenceId;
    protected String moleculeType;
    protected String targetMarker;
    protected String boldBarcodeId;
    protected String genbankAccessionNumber;
    protected String boldSampleId;
    protected String boldTranslationMatrix;
    protected String geneSequence;
    protected String remarks;
    protected String text1;
    protected String text2;
    protected String text3;
    protected Boolean yesNo1;
    protected Boolean yesNo2;
    protected Boolean yesNo3;
    protected Integer totalResidues;
    protected Integer compA;
    protected Integer compG;
    protected Integer compC;
    protected Integer compT;
    protected Integer ambiguousResidues;
    protected Float number1;
    protected Float number2;
    protected Float number3;
    protected Calendar boldLastUpdateDate;
    protected Agent sequencer;
    protected CollectionObject collectionObject;
    protected Set<DNASequenceAttachment> attachments;
    protected Set<DNASequencingRun> dnaSequencingRuns;

    @Override
    public void initialize() {
        super.init();
        this.dnaSequenceId = null;
        this.moleculeType = null;
        this.targetMarker = null;
        this.boldBarcodeId = null;
        this.genbankAccessionNumber = null;
        this.boldSampleId = null;
        this.boldTranslationMatrix = null;
        this.geneSequence = null;
        this.remarks = null;
        this.text1 = null;
        this.text2 = null;
        this.text3 = null;
        this.yesNo1 = null;
        this.yesNo2 = null;
        this.yesNo3 = null;
        this.totalResidues = null;
        this.compA = null;
        this.compG = null;
        this.compC = null;
        this.compT = null;
        this.ambiguousResidues = null;
        this.number1 = null;
        this.number2 = null;
        this.number3 = null;
        this.boldLastUpdateDate = null;
        this.sequencer = null;
        this.collectionObject = null;
        this.attachments = new TreeSet<DNASequenceAttachment>();
        this.dnaSequencingRuns = new HashSet<DNASequencingRun>();
    }

    @Override
    public void forceLoad() {
        this.dnaSequencingRuns.size();
    }

    @Column(name="MoleculeType", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getMoleculeType() {
        return this.moleculeType;
    }

    @Column(name="TargetMarker", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getTargetMarker() {
        return this.targetMarker;
    }

    @Column(name="BOLDBarcodeID", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getBoldBarcodeId() {
        return this.boldBarcodeId;
    }

    @Column(name="GenBankAccessionNumber", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getGenbankAccessionNumber() {
        return this.genbankAccessionNumber;
    }

    @Column(name="BOLDSampleID", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getBoldSampleId() {
        return this.boldSampleId;
    }

    @Column(name="BOLDTranslationMatrix", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getBoldTranslationMatrix() {
        return this.boldTranslationMatrix;
    }

    @Lob
    @Column(name="GeneSequence", unique=false, nullable=true, insertable=true, updatable=true, length=2048)
    public String getGeneSequence() {
        return this.geneSequence;
    }

    @Lob
    @Column(name="Remarks", unique=false, nullable=true, insertable=true, updatable=true, length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    @Column(name="Text1", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getText1() {
        return this.text1;
    }

    @Column(name="Text2", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getText2() {
        return this.text2;
    }

    @Column(name="Text3", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getText3() {
        return this.text3;
    }

    @Column(name="YesNo1", unique=false, nullable=true, updatable=true, insertable=true)
    public Boolean getYesNo1() {
        return this.yesNo1;
    }

    @Column(name="YesNo2", unique=false, nullable=true, updatable=true, insertable=true)
    public Boolean getYesNo2() {
        return this.yesNo2;
    }

    @Column(name="YesNo3", unique=false, nullable=true, updatable=true, insertable=true)
    public Boolean getYesNo3() {
        return this.yesNo3;
    }

    @Column(name="TotalResidues", unique=false, nullable=true, insertable=true, updatable=true)
    public Integer getTotalResidues() {
        return this.totalResidues;
    }

    @Column(name="CompA", unique=false, nullable=true, insertable=true, updatable=true)
    public Integer getCompA() {
        return this.compA;
    }

    @Column(name="CompG", unique=false, nullable=true, insertable=true, updatable=true)
    public Integer getCompG() {
        return this.compG;
    }

    @Column(name="CompC", unique=false, nullable=true, insertable=true, updatable=true)
    public Integer getCompC() {
        return this.compC;
    }

    @Column(name="compT", unique=false, nullable=true, insertable=true, updatable=true)
    public Integer getCompT() {
        return this.compT;
    }

    @Column(name="AmbiguousResidues", unique=false, nullable=true, insertable=true, updatable=true)
    public Integer getAmbiguousResidues() {
        return this.ambiguousResidues;
    }

    @Column(name="Number1", unique=false, nullable=true, insertable=true, updatable=true)
    public Float getNumber1() {
        return this.number1;
    }

    @Column(name="Number2", unique=false, nullable=true, insertable=true, updatable=true)
    public Float getNumber2() {
        return this.number2;
    }

    @Column(name="Number3", unique=false, nullable=true, insertable=true, updatable=true)
    public Float getNumber3() {
        return this.number3;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="BOLDLastUpdateDate", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getBoldLastUpdateDate() {
        return this.boldLastUpdateDate;
    }

    public void setTargetMarker(String targetMarker) {
        this.targetMarker = targetMarker;
    }

    public void setBoldBarcodeId(String boldBarcodeId) {
        this.boldBarcodeId = boldBarcodeId;
    }

    public void setGenbankAccessionNumber(String genbankAccessionNumber) {
        this.genbankAccessionNumber = genbankAccessionNumber;
    }

    public void setBoldSampleId(String boldSampleId) {
        this.boldSampleId = boldSampleId;
    }

    public void setBoldTranslationMatrix(String boldTranslationMatrix) {
        this.boldTranslationMatrix = boldTranslationMatrix;
    }

    public void setGeneSequence(String geneSequence) {
        this.geneSequence = geneSequence;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public void setText1(String text1) {
        this.text1 = text1;
    }

    public void setText2(String text2) {
        this.text2 = text2;
    }

    public void setText3(String text3) {
        this.text3 = text3;
    }

    public void setYesNo1(Boolean yesNo1) {
        this.yesNo1 = yesNo1;
    }

    public void setYesNo2(Boolean yesNo2) {
        this.yesNo2 = yesNo2;
    }

    public void setYesNo3(Boolean yesNo3) {
        this.yesNo3 = yesNo3;
    }

    public void setTotalResidues(Integer totalResidues) {
        this.totalResidues = totalResidues;
    }

    public void setCompA(Integer compA) {
        this.compA = compA;
    }

    public void setCompG(Integer compG) {
        this.compG = compG;
    }

    public void setCompC(Integer compC) {
        this.compC = compC;
    }

    public void setCompT(Integer compT) {
        this.compT = compT;
    }

    public void setAmbiguousResidues(Integer ambiguousResidues) {
        this.ambiguousResidues = ambiguousResidues;
    }

    public void setNumber1(Float number1) {
        this.number1 = number1;
    }

    public void setNumber2(Float number2) {
        this.number2 = number2;
    }

    public void setNumber3(Float number3) {
        this.number3 = number3;
    }

    public void setBoldLastUpdateDate(Calendar boldLastUpdateDate) {
        this.boldLastUpdateDate = boldLastUpdateDate;
    }

    public void setMoleculeType(String moleculeType) {
        this.moleculeType = moleculeType;
    }

    public void setDnaSequenceId(Integer dnaSequenceId) {
        this.dnaSequenceId = dnaSequenceId;
    }

    public void setSequencer(Agent sequencer) {
        this.sequencer = sequencer;
    }

    public void setAttachments(Set<DNASequenceAttachment> attachments) {
        this.attachments = attachments;
    }

    public void setCollectionObject(CollectionObject collectionObject) {
        this.collectionObject = collectionObject;
    }

    @Id
    @GeneratedValue
    @Column(name="DnaSequenceID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getDnaSequenceId() {
        return this.dnaSequenceId;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="AgentID", unique=false, nullable=true, insertable=true, updatable=true)
    public Agent getSequencer() {
        return this.sequencer;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="CollectionObjectID", unique=false, nullable=true, insertable=true, updatable=true)
    public CollectionObject getCollectionObject() {
        return this.collectionObject;
    }

    @OneToMany(mappedBy="dnaSequence")
    @Cascade(value={CascadeType.ALL})
    @OrderBy(value="ordinal ASC")
    public Set<DNASequencingRun> getDnaSequencingRuns() {
        return this.dnaSequencingRuns;
    }

    public void setDnaSequencingRuns(Set<DNASequencingRun> dnaSequencingRuns) {
        this.dnaSequencingRuns = dnaSequencingRuns;
    }

    @OneToMany(mappedBy="dnaSequence")
    @Cascade(value={CascadeType.ALL})
    @OrderBy(value="ordinal ASC")
    public Set<DNASequenceAttachment> getAttachments() {
        return this.attachments;
    }

    @Override
    @Transient
    public Set<DNASequenceAttachment> getAttachmentReferences() {
        return this.attachments;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return CollectionObject.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.collectionObject != null ? this.collectionObject.getId() : null;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.dnaSequenceId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return DNASequence.class;
    }

    @Override
    @Transient
    public int getTableId() {
        return DNASequence.getClassTableId();
    }

    public static int getClassTableId() {
        return 121;
    }
}

