/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.datamodel.CollectionMember;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.Storage;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.hibernate.LazyInitializationException;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="container")
@Table(appliesTo="container", indexes={@Index(name="ContainerNameIDX", columnNames={"Name"}), @Index(name="ContainerMemIDX", columnNames={"CollectionMemberID"})})
public class Container
extends CollectionMember
implements Serializable,
Comparable<Container> {
    protected Integer containerId;
    protected Short type;
    protected String name;
    protected String description;
    protected Integer number;
    protected Set<CollectionObject> collectionObjects;
    protected Set<CollectionObject> collectionObjectKids;
    protected Storage storage;
    protected Container parent;
    protected Set<Container> children;
    protected Vector<Container> childrenList = null;

    public Container() {
    }

    public Container(Integer containerId) {
        this.containerId = containerId;
        System.err.println("2constructor " + this.hashCode());
    }

    @Override
    public void initialize() {
        super.init();
        this.containerId = null;
        this.type = null;
        this.name = null;
        this.description = null;
        this.number = null;
        this.parent = null;
        this.collectionObjects = new HashSet<CollectionObject>();
        this.collectionObjectKids = new HashSet<CollectionObject>();
        this.storage = null;
        this.children = new HashSet<Container>();
    }

    @Id
    @GeneratedValue
    @Column(name="ContainerID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getContainerId() {
        return this.containerId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.containerId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return Container.class;
    }

    public void setContainerId(Integer containerId) {
        this.containerId = containerId;
    }

    @Column(name="Type", unique=false, nullable=true, insertable=true, updatable=true)
    public Short getType() {
        return this.type;
    }

    public void setType(Short type) {
        this.type = type;
    }

    @Column(name="Name", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="Description", unique=false, nullable=true, insertable=true, updatable=true)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Column(name="Number", unique=false, nullable=true, insertable=true, updatable=true)
    public Integer getNumber() {
        return this.number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    @Transient
    public CollectionObject getCollectionObject() {
        Set<CollectionObject> colObjsSet = this.getCollectionObjects();
        return colObjsSet != null && colObjsSet.size() > 0 ? colObjsSet.iterator().next() : null;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="container")
    @Cascade(value={CascadeType.SAVE_UPDATE, CascadeType.MERGE, CascadeType.LOCK})
    public Set<CollectionObject> getCollectionObjects() {
        return this.collectionObjects;
    }

    public void setCollectionObjects(Set<CollectionObject> collectionObjects) {
        this.collectionObjects = collectionObjects;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="containerOwner")
    @Cascade(value={CascadeType.SAVE_UPDATE, CascadeType.MERGE, CascadeType.LOCK})
    public Set<CollectionObject> getCollectionObjectKids() {
        return this.collectionObjectKids;
    }

    public void setCollectionObjectKids(Set<CollectionObject> collectionObjectKids) {
        this.collectionObjectKids = collectionObjectKids;
    }

    @Transient
    public Vector<Container> getChildrenList() {
        if (this.childrenList == null) {
            this.childrenList = new Vector();
            this.childrenList.addAll(this.children);
        }
        return this.childrenList;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="StorageID", unique=false, nullable=true, insertable=true, updatable=true)
    public Storage getStorage() {
        return this.storage;
    }

    public void setStorage(Storage storage) {
        this.storage = storage;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="ParentID")
    public Container getParent() {
        return this.parent;
    }

    public void setParent(Container parent) {
        this.parent = parent;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return Container.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.parent != null ? this.parent.getId() : null;
    }

    @OneToMany(mappedBy="parent")
    @Cascade(value={CascadeType.SAVE_UPDATE, CascadeType.MERGE, CascadeType.LOCK})
    public Set<Container> getChildren() {
        return this.children;
    }

    public void setChildren(Set<Container> children) {
        this.children = children;
    }

    @Override
    public void forceLoad() {
        block8: {
            try {
                this.getCollectionObjects().size();
                this.getCollectionObjectKids().size();
                this.getChildren().size();
            }
            catch (LazyInitializationException ex) {
                DataProviderSessionIFace tmpSession = null;
                try {
                    try {
                        tmpSession = DataProviderFactory.getInstance().createSession();
                        tmpSession.attach(this);
                        this.getCollectionObjects().size();
                        this.getCollectionObjectKids().size();
                        this.getChildren().size();
                    }
                    catch (Exception exx) {
                        ex.printStackTrace();
                        if (tmpSession != null) {
                            tmpSession.close();
                        }
                    }
                }
                finally {
                    if (tmpSession == null) break block8;
                    tmpSession.close();
                }
            }
        }
    }

    @Override
    @Transient
    public int getTableId() {
        return Container.getClassTableId();
    }

    @Override
    public String toString() {
        return StringUtils.isNotEmpty((String)this.name) ? this.name : "N/A";
    }

    @Override
    public int compareTo(Container o) {
        if (this.name == null || o.name == null) {
            return 0;
        }
        return this.name.compareTo(o.name);
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        return StringUtils.isNotEmpty((String)this.name) ? this.name : super.getIdentityTitle();
    }

    public static int getClassTableId() {
        return 31;
    }
}

