/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.AttachmentOwnerIFace;
import edu.ku.brc.specify.datamodel.ConservDescription;
import edu.ku.brc.specify.datamodel.ConservEventAttachment;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import java.io.Serializable;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="conservevent")
@Table(appliesTo="conservevent", indexes={@Index(name="ConservExamDateIDX", columnNames={"ExamDate"}), @Index(name="ConservCompletedDateIDX", columnNames={"completedDate"})})
public class ConservEvent
extends DataModelObjBase
implements AttachmentOwnerIFace<ConservEventAttachment>,
Serializable {
    protected Integer conservEventId;
    protected Calendar examDate;
    protected String conditionReport;
    protected String advTestingExam;
    protected String advTestingExamResults;
    protected String photoDocs;
    protected Agent examinedByAgent;
    protected String recommendedComments;
    protected Agent curator;
    protected Calendar curatorApprovalDate;
    protected String treatmentReport;
    protected Calendar treatmentCompDate;
    protected Agent treatedByAgent;
    protected Calendar completedDate;
    protected String completedComments;
    protected String remarks;
    protected String text1;
    protected String text2;
    protected Integer number1;
    protected Integer number2;
    protected Boolean yesNo1;
    protected Boolean yesNo2;
    protected ConservDescription conservDescription;
    protected Set<ConservEventAttachment> conservEventAttachments;

    public ConservEvent() {
    }

    public ConservEvent(Integer conservEventId) {
        this.conservEventId = conservEventId;
    }

    @Override
    public void initialize() {
        super.init();
        this.examDate = null;
        this.conditionReport = null;
        this.advTestingExam = null;
        this.advTestingExamResults = null;
        this.treatmentReport = null;
        this.treatmentCompDate = null;
        this.photoDocs = null;
        this.examinedByAgent = null;
        this.treatedByAgent = null;
        this.conservDescription = null;
        this.recommendedComments = null;
        this.completedDate = null;
        this.completedComments = null;
        this.remarks = null;
        this.curatorApprovalDate = null;
        this.curator = null;
        this.text1 = null;
        this.text2 = null;
        this.number1 = null;
        this.number2 = null;
        this.yesNo1 = null;
        this.yesNo2 = null;
        this.conservEventAttachments = new HashSet<ConservEventAttachment>();
    }

    @Id
    @GeneratedValue
    @Column(name="ConservEventID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getConservEventId() {
        return this.conservEventId;
    }

    public void setConservEventId(Integer conservEventId) {
        this.conservEventId = conservEventId;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="ExamDate", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getExamDate() {
        return this.examDate;
    }

    public void setExamDate(Calendar examDate) {
        this.examDate = examDate;
    }

    @Lob
    @Column(name="ConditionReport", unique=false, nullable=true, insertable=true, updatable=true, length=8192)
    public String getConditionReport() {
        return this.conditionReport;
    }

    public void setConditionReport(String conditionReport) {
        this.conditionReport = conditionReport;
    }

    @Lob
    @Column(name="AdvTestingExam", unique=false, nullable=true, insertable=true, updatable=true, length=8192)
    public String getAdvTestingExam() {
        return this.advTestingExam;
    }

    public void setAdvTestingExam(String advTestingExam) {
        this.advTestingExam = advTestingExam;
    }

    @Lob
    @Column(name="AdvTestingExamResults", unique=false, nullable=true, insertable=true, updatable=true, length=8192)
    public String getAdvTestingExamResults() {
        return this.advTestingExamResults;
    }

    public void setAdvTestingExamResults(String advTestingExamResults) {
        this.advTestingExamResults = advTestingExamResults;
    }

    @Lob
    @Column(name="TreatmentReport", unique=false, nullable=true, insertable=true, updatable=true, length=8192)
    public String getTreatmentReport() {
        return this.treatmentReport;
    }

    public void setTreatmentReport(String treatmentReport) {
        this.treatmentReport = treatmentReport;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="TreatmentCompDate", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getTreatmentCompDate() {
        return this.treatmentCompDate;
    }

    public void setTreatmentCompDate(Calendar treatmentCompDate) {
        this.treatmentCompDate = treatmentCompDate;
    }

    @Lob
    @Column(name="PhotoDocs", unique=false, nullable=true, insertable=true, updatable=true, length=8192)
    public String getPhotoDocs() {
        return this.photoDocs;
    }

    public void setPhotoDocs(String photoDocs) {
        this.photoDocs = photoDocs;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="ExaminedByAgentID", unique=false, nullable=true, insertable=true, updatable=true)
    public Agent getExaminedByAgent() {
        return this.examinedByAgent;
    }

    public void setExaminedByAgent(Agent examinedByAgent) {
        this.examinedByAgent = examinedByAgent;
    }

    @Lob
    @Column(name="CompletedComments", length=4096)
    public String getCompletedComments() {
        return this.completedComments;
    }

    public void setCompletedComments(String completedComments) {
        this.completedComments = completedComments;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="CuratorApprovalDate", unique=false, nullable=true, insertable=true, updatable=true, length=8192)
    public Calendar getCuratorApprovalDate() {
        return this.curatorApprovalDate;
    }

    public void setCuratorApprovalDate(Calendar curatorApprovalDate) {
        this.curatorApprovalDate = curatorApprovalDate;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="CuratorID", unique=false, nullable=true, insertable=true, updatable=true)
    public Agent getCurator() {
        return this.curator;
    }

    public void setCurator(Agent curator) {
        this.curator = curator;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="TreatedByAgentID", unique=false, nullable=true, insertable=true, updatable=true)
    public Agent getTreatedByAgent() {
        return this.treatedByAgent;
    }

    public void setTreatedByAgent(Agent treatedByAgent) {
        this.treatedByAgent = treatedByAgent;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="CompletedDate", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getCompletedDate() {
        return this.completedDate;
    }

    public void setCompletedDate(Calendar completedDate) {
        this.completedDate = completedDate;
    }

    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Column(name="Text1", length=64, unique=false, nullable=true, insertable=true, updatable=true)
    public String getText1() {
        return this.text1;
    }

    public void setText1(String text1) {
        this.text1 = text1;
    }

    @Column(name="Text2", length=64, unique=false, nullable=true, insertable=true, updatable=true)
    public String getText2() {
        return this.text2;
    }

    public void setText2(String text2) {
        this.text2 = text2;
    }

    @Column(name="Number1", unique=false, nullable=true, insertable=true, updatable=true)
    public Integer getNumber1() {
        return this.number1;
    }

    public void setNumber1(Integer number1) {
        this.number1 = number1;
    }

    @Column(name="Number2", unique=false, nullable=true, insertable=true, updatable=true)
    public Integer getNumber2() {
        return this.number2;
    }

    public void setNumber2(Integer number2) {
        this.number2 = number2;
    }

    @Column(name="YesNo1", unique=false, nullable=true, updatable=true, insertable=true)
    public Boolean getYesNo1() {
        return this.yesNo1;
    }

    public void setYesNo1(Boolean yesNo1) {
        this.yesNo1 = yesNo1;
    }

    @Column(name="YesNo2", unique=false, nullable=true, updatable=true, insertable=true)
    public Boolean getYesNo2() {
        return this.yesNo2;
    }

    public void setYesNo2(Boolean yesNo2) {
        this.yesNo2 = yesNo2;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="ConservDescriptionID", unique=false, nullable=false, insertable=true, updatable=true)
    public ConservDescription getConservDescription() {
        return this.conservDescription;
    }

    public void setConservDescription(ConservDescription conservDescription) {
        this.conservDescription = conservDescription;
    }

    @OneToMany(mappedBy="conservEvent")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    @OrderBy(value="ordinal ASC")
    public Set<ConservEventAttachment> getConservEventAttachments() {
        return this.conservEventAttachments;
    }

    public void setConservEventAttachments(Set<ConservEventAttachment> conservEventAttachments) {
        this.conservEventAttachments = conservEventAttachments;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return ConservDescription.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.conservDescription != null ? this.conservDescription.getId() : null;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.conservEventId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return ConservEvent.class;
    }

    @Override
    @Transient
    public int getTableId() {
        return ConservEvent.getClassTableId();
    }

    public static int getClassTableId() {
        return 73;
    }

    @Override
    @Transient
    public Set<ConservEventAttachment> getAttachmentReferences() {
        return this.conservEventAttachments;
    }
}

