/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.CommonNameTxCitation;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.Taxon;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="commonnametx")
@Table(appliesTo="commonnametx", indexes={@Index(name="CommonNameTxNameIDX", columnNames={"Name"}), @Index(name="CommonNameTxCountryIDX", columnNames={"Country"})})
public class CommonNameTx
extends DataModelObjBase
implements Serializable,
Cloneable {
    protected Integer commonNameTxId;
    protected String country;
    protected String language;
    protected String variant;
    protected String name;
    protected String author;
    protected Taxon taxon;
    protected Set<CommonNameTxCitation> citations;

    public CommonNameTx() {
    }

    public CommonNameTx(Integer commonNameId) {
        this.commonNameTxId = commonNameId;
    }

    @Override
    public void initialize() {
        super.init();
        this.commonNameTxId = null;
        this.name = null;
        this.country = null;
        this.language = null;
        this.variant = null;
        this.taxon = null;
        this.citations = new HashSet<CommonNameTxCitation>();
    }

    @Id
    @GeneratedValue
    @Column(name="CommonNameTxID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getCommonNameTxId() {
        return this.commonNameTxId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.commonNameTxId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return CommonNameTx.class;
    }

    public void setCommonNameTxId(Integer commonNameId) {
        this.commonNameTxId = commonNameId;
    }

    @Column(name="Name", unique=false, nullable=true, insertable=true, updatable=true, length=255)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="Language", unique=false, nullable=true, insertable=true, updatable=true, length=2)
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    @Column(name="Country", unique=false, nullable=true, insertable=true, updatable=true, length=2)
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    @Column(name="Variant", unique=false, nullable=true, insertable=true, updatable=true, length=2)
    public String getVariant() {
        return this.variant;
    }

    public void setVariant(String variant) {
        this.variant = variant;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="TaxonID", unique=false, nullable=false, insertable=true, updatable=true)
    public Taxon getTaxon() {
        return this.taxon;
    }

    public void setTaxon(Taxon taxon) {
        this.taxon = taxon;
    }

    @Column(name="Author", length=128)
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return Taxon.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.taxon != null ? this.taxon.getId() : null;
    }

    @Override
    @Transient
    public int getTableId() {
        return CommonNameTx.getClassTableId();
    }

    public static int getClassTableId() {
        return 106;
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        return this.name != null ? this.name : super.getIdentityTitle();
    }

    @OneToMany(mappedBy="commonNameTx")
    @Cascade(value={CascadeType.SAVE_UPDATE, CascadeType.MERGE, CascadeType.LOCK})
    public Set<CommonNameTxCitation> getCitations() {
        return this.citations;
    }

    public void setCitations(Set<CommonNameTxCitation> citations) {
        this.citations = citations;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CommonNameTx obj = (CommonNameTx)super.clone();
        obj.commonNameTxId = null;
        obj.taxon = null;
        obj.citations = new HashSet<CommonNameTxCitation>();
        return obj;
    }
}

